/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.hcs.io;

import danyfel80.wells.data.IField;
import danyfel80.wells.data.IPlate;
import danyfel80.wells.data.IWell;
import danyfel80.wells.data.columbus.ColumbusField;
import danyfel80.wells.data.im.ImChannel;
import danyfel80.wells.data.im.ImField;
import danyfel80.wells.data.im.ImPlane;
import danyfel80.wells.data.im.ImPlate;
import danyfel80.wells.data.im.ImTimepoint;
import danyfel80.wells.util.MessageProgressListener;
import danyfel80.wells.util.stream.StreamUtils;
import icy.image.IcyBufferedImage;
import icy.image.colormap.IcyColorMap;
import icy.image.colormap.LinearColorMap;
import icy.sequence.Sequence;
import icy.type.dimension.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import ome.xml.meta.OMEXMLMetadata;
import ome.xml.model.primitives.PositiveInteger;
import plugins.adufour.hcs.io.AbstractWellPlateReader;

public class WellPlateReader_Im
extends AbstractWellPlateReader {
    @Override
    public String getSystemName() {
        return "IM";
    }

    @Override
    public boolean isValidPlate(File file) {
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        Path folderPath = file.toPath();
        Path xmlFile = Paths.get("" + folderPath.getParent(), folderPath.getFileName() + ".xml");
        return Files.exists(xmlFile, new LinkOption[0]);
    }

    public Future<ImPlate> loadPlateFromFolder(File folder, MessageProgressListener progressListener) {
        ExecutorService executor = Executors.newSingleThreadExecutor(r -> new Thread(r, "ImWellPlateReader"));
        Future<ImPlate> future = executor.submit(() -> this.loadPlateFromFolder_internal(folder, progressListener));
        executor.shutdown();
        return future;
    }

    private ImPlate loadPlateFromFolder_internal(File folder, MessageProgressListener progressListener) throws IOException {
        Path folderPath = folder.toPath();
        Path xmlFilePath = Paths.get("" + folderPath.getParent(), folderPath.getFileName() + ".xml");
        if (progressListener != null) {
            progressListener.notifyProgress(-1.0, "Loading well plate: " + xmlFilePath);
        }
        ImPlate plate = new ImPlate.Builder(xmlFilePath.toString(), folder.toString()).progressListener(progressListener).build();
        if (progressListener != null) {
            progressListener.notifyProgress(1.0, "Well plate loaded: " + xmlFilePath);
        }
        return plate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Future<? extends Sequence> loadField(IPlate plate, IWell well, IField field, Sequence sequence, MessageProgressListener progressListener) {
        CompletableFuture<Sequence> future = new CompletableFuture<Sequence>();
        if (!(field instanceof ImField)) {
            future.completeExceptionally(new ClassCastException("Provided field is not of type " + ColumbusField.class.getName()));
            return future;
        }
        if (!(plate instanceof ImPlate)) {
            future.completeExceptionally(new ClassCastException("Provided field is not of type " + ColumbusField.class.getName()));
            return future;
        }
        if (sequence == null) {
            sequence = new Sequence();
        }
        sequence.beginUpdate();
        ImPlate imPlate = (ImPlate)plate;
        OMEXMLMetadata metadata = sequence.getOMEXMLMetadata();
        metadata.setPlateName(imPlate.getName(), 0);
        metadata.setPlateID(imPlate.getId(), 0);
        metadata.setPlateRows(new PositiveInteger(Integer.valueOf(imPlate.getDimension().height)), 0);
        metadata.setPlateColumns(new PositiveInteger(Integer.valueOf(imPlate.getDimension().width)), 0);
        sequence.setPositionX(field.getPosition().getX());
        sequence.setPositionY(field.getPosition().getY());
        Dimension2D.Double pixelSize = new Dimension2D.Double();
        HashMap<Integer, String> channelNames = new HashMap<Integer, String>();
        HashMap<Integer, IcyColorMap> channelColors = new HashMap<Integer, IcyColorMap>();
        try {
            this.loadPlanes(imPlate, (ImField)field, sequence, pixelSize, channelNames, channelColors);
            sequence.setPixelSizeX(pixelSize.getSizeX());
            sequence.setPixelSizeY(pixelSize.getSizeY());
            for (Map.Entry entry : channelNames.entrySet()) {
                sequence.setChannelName(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            for (Map.Entry entry : channelColors.entrySet()) {
                sequence.setColormap(((Integer)entry.getKey()).intValue(), (IcyColorMap)entry.getValue(), true);
            }
        }
        finally {
            sequence.endUpdate();
        }
        future.complete(sequence);
        return future;
    }

    private void loadPlanes(ImPlate plate, ImField field, Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors) {
        List planes = field.getPlanes().values().stream().sorted(Comparator.comparingDouble(ImPlane::getPositionZ)).map(StreamUtils.wrapFunction(plane -> this.loadPlane(sequence, pixelSize, channelNames, channelColors, plate, field, (ImPlane)plane))).collect(Collectors.toList());
        int z = 0;
        for (List planeImages : planes) {
            int t = 0;
            for (IcyBufferedImage image : planeImages) {
                sequence.setImage(t, z, (BufferedImage)image);
                ++t;
            }
            ++z;
        }
    }

    private List<IcyBufferedImage> loadPlane(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, ImPlate plate, ImField field, ImPlane plane) {
        List<IcyBufferedImage> timeImages = plane.getTimepoints().values().stream().sorted(Comparator.comparingLong(ImTimepoint::getId)).map(StreamUtils.wrapFunction(t -> this.loadTimePoint(sequence, pixelSize, channelNames, channelColors, plate, field, plane, (ImTimepoint)t))).collect(Collectors.toList());
        return timeImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IcyBufferedImage loadTimePoint(Sequence sequence, Dimension2D.Double pixelSize, Map<Integer, String> channelNames, Map<Integer, IcyColorMap> channelColors, ImPlate plate, ImField field, ImPlane plane, ImTimepoint t) throws IOException {
        ImChannel firstChannel = t.getChannels().values().stream().findFirst().get();
        pixelSize.setSize(firstChannel.getImage().getResolution());
        String imageFile = firstChannel.getImage().getUrl();
        ImageReader reader = ImageIO.getImageReadersByFormatName("tiff").next();
        try {
            reader.setInput(new FileInputStream(imageFile));
            int nChannels = t.getChannels().size();
            ArrayList<BufferedImage> channels = new ArrayList<BufferedImage>(nChannels);
            List colorMaps = LinearColorMap.getLinearColorMaps((boolean)false, (boolean)false);
            for (int ch = 0; ch < nChannels; ++ch) {
                ImageReadParam p = new ImageReadParam();
                p.setDestination(new BufferedImage(reader.getWidth(ch), reader.getHeight(ch), 11));
                channels.add(reader.read(ch, p));
                channelNames.put(ch, "ch" + ch);
                channelColors.put(ch, (IcyColorMap)colorMaps.get((1 + ch) % colorMaps.size()));
            }
            IcyBufferedImage icyBufferedImage = IcyBufferedImage.createFrom(channels);
            return icyBufferedImage;
        }
        finally {
            reader.dispose();
        }
    }
}

