/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.progress;

import java.util.ArrayList;
import java.util.List;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressManager;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressReport;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackable;

public abstract class ProgressTrackableMasterTask
extends ProgressReport
implements ProgressTrackable {
    private List<ProgressTrackable> tasks = new ArrayList<ProgressTrackable>();

    public ProgressTrackableMasterTask add(ProgressTrackable task) {
        this.tasks.add(task);
        super.setChanged();
        super.notifyObservers(task);
        return this;
    }

    @Override
    public void visit(ProgressManager progressManager) {
        super.addObserver(progressManager);
        for (ProgressTrackable progressTrackable : this.tasks) {
            progressManager.subscribe(progressTrackable);
        }
    }

    @Override
    public ProgressReport getProgress() {
        return this;
    }

    @Override
    public int getCompleted() {
        return (int)this.tasks.stream().filter(task -> task.getProgress().isCompleted()).count();
    }

    @Override
    public int getTotal() {
        return this.tasks.size();
    }

    protected List<ProgressTrackable> getTaskList() {
        return this.tasks;
    }
}

