/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.registration;

import Jama.Matrix;
import Jama.SingularValueDecomposition;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.matrix.MatrixUtil;
import plugins.perrine.ec_clem.ec_clem.registration.AffineRegistrationParameterComputer;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.transformation.Similarity;

public class SimilarityRegistrationParameterComputer
extends AffineRegistrationParameterComputer {
    @Inject
    public SimilarityRegistrationParameterComputer(MatrixUtil matrixUtil) {
        super(matrixUtil);
    }

    @Override
    public RegistrationParameter compute(FiducialSet fiducialSet) {
        Dataset clonedSourceDataset = fiducialSet.getSourceDataset().clone();
        Dataset clonedTargetDataset = fiducialSet.getTargetDataset().clone();
        Point sourceBarycentre = clonedSourceDataset.getBarycentre();
        Point targetBarycentre = clonedTargetDataset.getBarycentre();
        clonedSourceDataset.substractBarycentre();
        clonedTargetDataset.substractBarycentre();
        Matrix R = this.getR(clonedSourceDataset, clonedTargetDataset);
        if (R.getColumnDimension() > 2 && R.get(2, 2) == -1.0) {
            R.set(2, 2, 1.0);
        }
        Matrix S = this.getS(clonedSourceDataset.getMatrix(), clonedTargetDataset.getMatrix(), R);
        Matrix T = this.getT(sourceBarycentre.getMatrix(), targetBarycentre.getMatrix(), R, S);
        Similarity similarity = new Similarity(R, T, S);
        Matrix residuals = fiducialSet.getTargetDataset().getMatrix().minus(similarity.apply(fiducialSet.getSourceDataset()).getMatrix());
        double sum = 0.0;
        for (int i = 0; i < residuals.getRowDimension(); ++i) {
            Matrix current = residuals.getMatrix(i, i, 0, residuals.getColumnDimension() - 1);
            Matrix times = current.times(current.transpose());
            assert (times.getRowDimension() == 1);
            assert (times.getColumnDimension() == 1);
            sum += times.get(0, 0);
        }
        Matrix lambda = Matrix.identity((int)fiducialSet.getTargetDataset().getDimension(), (int)fiducialSet.getTargetDataset().getDimension()).times(sum / (double)(fiducialSet.getN() * fiducialSet.getTargetDataset().getDimension()));
        return new RegistrationParameter(similarity, lambda, this.getLogLikelihood(residuals, lambda));
    }

    protected Matrix getS(Matrix sourceDataset, Matrix targetDataset, Matrix R) {
        Dataset ratioDataset = new Dataset(targetDataset.arrayRightDivide(R.times(sourceDataset.transpose()).transpose()), PointType.FIDUCIAL);
        Point ratioPoint = ratioDataset.getBarycentre();
        Matrix scale = Matrix.identity((int)R.getRowDimension(), (int)R.getColumnDimension());
        for (int i = 0; i < R.getRowDimension(); ++i) {
            if (Double.isNaN(ratioPoint.get(i)) || ratioPoint.get(i) == 0.0) {
                scale.set(i, i, 1.0);
                continue;
            }
            scale.set(i, i, ratioPoint.get(i));
        }
        return scale;
    }

    private Matrix getR(Dataset source, Dataset target) {
        Matrix S = target.getMatrix().transpose().times(source.getMatrix());
        SingularValueDecomposition svd = S.svd();
        Matrix E = Matrix.identity((int)svd.getS().getRowDimension(), (int)svd.getS().getColumnDimension());
        E.set(E.getRowDimension() - 1, E.getColumnDimension() - 1, Math.signum(svd.getU().times(svd.getV().transpose()).det()));
        return svd.getU().times(E).times(svd.getV().transpose());
    }

    private Matrix getT(Matrix sourceBarycentre, Matrix targetBarycentre, Matrix R, Matrix scale) {
        return targetBarycentre.minus(R.times(scale).times(sourceBarycentre));
    }
}

