/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence;

import icy.image.IcyBufferedImage;
import icy.sequence.Sequence;
import icy.type.DataType;
import java.awt.image.BufferedImage;
import java.lang.reflect.Array;
import java.util.function.Supplier;
import plugins.perrine.ec_clem.ec_clem.progress.ProgressTrackableChildTask;

public class VtkDataSequenceSupplier
extends ProgressTrackableChildTask
implements Supplier<Sequence> {
    private Sequence sequence;
    private Object vtkDataSetArray;
    private int xSize;
    private int ySize;
    private int zSize;
    private int tSize;
    private int cSize;
    private int channel;
    private double spacingX;
    private double spacingY;
    private double spacingZ;
    private DataType dataType;
    private int c;
    private int sizeC;

    public VtkDataSequenceSupplier(Sequence sequence, DataType datatype, int c, int sizeC, Object vtkDataSetArray, int xSize, int ySize, int zSize, int tSize, double spacingX, double spacingY, double spacingZ) {
        super(tSize * zSize);
        this.sequence = sequence;
        this.dataType = this.dataType;
        this.vtkDataSetArray = vtkDataSetArray;
        this.xSize = xSize;
        this.ySize = ySize;
        this.zSize = zSize;
        this.tSize = tSize;
        this.cSize = this.cSize;
        this.channel = this.channel;
        this.spacingX = spacingX;
        this.spacingY = spacingY;
        this.spacingZ = spacingZ;
        this.dataType = datatype;
        this.c = c;
        this.sizeC = sizeC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sequence get() {
        this.sequence.beginUpdate();
        try {
            Object inData = this.vtkDataSetArray;
            Object outData = Array.newInstance(this.dataType.toPrimitiveClass(), this.xSize * this.ySize);
            for (int t = 0; t < this.tSize; ++t) {
                for (int z = 0; z < this.zSize; ++z) {
                    IcyBufferedImage image = this.sequence.getImage(t, z);
                    if (image == null) {
                        image = new IcyBufferedImage(this.xSize, this.ySize, this.sizeC, this.dataType);
                        this.sequence.setImage(t, z, (BufferedImage)image);
                        image.setVolatile(this.sequence.isVolatile());
                    }
                    System.arraycopy(inData, t * this.zSize * this.xSize * this.ySize + z * this.xSize * this.ySize, outData, 0, this.xSize * this.ySize);
                    image.setDataXY(this.c, outData);
                    super.incrementCompleted();
                }
            }
            this.sequence.setPixelSizeX(this.spacingX);
            this.sequence.setPixelSizeY(this.spacingY);
            this.sequence.setPixelSizeZ(this.spacingZ);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.sequence.endUpdate();
        }
        this.vtkDataSetArray = null;
        return this.sequence;
    }

    public void setData(Object vtkDataSetArray) {
        this.vtkDataSetArray = vtkDataSetArray;
    }
}

