/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation.csv;

import Jama.Matrix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class CsvToMatrixFileReader {
    @Inject
    public CsvToMatrixFileReader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Matrix read(File file) {
        try (CSVParser parser = CSVParser.parse(file, StandardCharsets.UTF_8, CSVFormat.DEFAULT);){
            List<CSVRecord> records = parser.getRecords();
            Matrix matrix = new Matrix(records.size(), records.get(0).size(), 0.0);
            for (int i = 0; i < matrix.getRowDimension(); ++i) {
                for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                    matrix.set(i, j, Double.parseDouble(records.get(i).get(j)));
                }
            }
            Matrix matrix2 = matrix;
            return matrix2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

