/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader;

import icy.sequence.DimensionId;
import icy.util.XMLUtil;
import java.util.ArrayList;
import javax.inject.Inject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.sequence.DimensionSize;
import plugins.perrine.ec_clem.ec_clem.sequence.SequenceSize;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.XmlTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.NoiseModel;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationType;

public class XmlTransformationReader {
    @Inject
    public XmlTransformationReader() {
    }

    public TransformationSchema read(Element transformationElement) {
        TransformationType transformationType = TransformationType.valueOf(transformationElement.getAttribute(XmlTransformation.transformationTypeAttributeName));
        NoiseModel noiseModel = NoiseModel.valueOf(transformationElement.getAttribute(XmlTransformation.transformationNoiseModelAttributeName));
        ArrayList datasetElements = XMLUtil.getElements((Node)transformationElement, (String)XmlTransformation.datasetElementName);
        if (datasetElements.size() != 2) {
            throw new RuntimeException("Element should contain exactly 2 dataset");
        }
        Dataset sourceDataset = this.readDataset((Element)datasetElements.get(0));
        Dataset targetDataset = this.readDataset((Element)datasetElements.get(1));
        FiducialSet fiducialSet = ((Element)datasetElements.get(0)).getAttribute(XmlTransformation.datasetTypeAttributeName).equals("source") ? new FiducialSet(sourceDataset, targetDataset) : new FiducialSet(targetDataset, sourceDataset);
        ArrayList sequenceSizeElements = XMLUtil.getElements((Node)transformationElement, (String)XmlTransformation.sequenceSizeElementName);
        if (sequenceSizeElements.size() != 2) {
            throw new RuntimeException("Element should contain exactly 2 sequenceSize");
        }
        SequenceSize sourceSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(0));
        SequenceSize targetSequenceSize = this.readSequenceSize((Element)sequenceSizeElements.get(1));
        if (((Element)sequenceSizeElements.get(0)).getAttribute(XmlTransformation.sequenceTypeAttributeName).equals("source")) {
            return new TransformationSchema(fiducialSet, transformationType, noiseModel, sourceSequenceSize, targetSequenceSize);
        }
        return new TransformationSchema(fiducialSet, transformationType, noiseModel, targetSequenceSize, sourceSequenceSize);
    }

    private SequenceSize readSequenceSize(Element sequenceSizeElement) {
        SequenceSize sequenceSize = new SequenceSize();
        ArrayList elements = XMLUtil.getElements((Node)sequenceSizeElement);
        for (Element dimension : elements) {
            sequenceSize.add(new DimensionSize(DimensionId.valueOf((String)dimension.getAttribute(XmlTransformation.dimensionSizeDimensionNameAttributeName)), Integer.parseInt(dimension.getTextContent()), Double.parseDouble(dimension.getAttribute(XmlTransformation.dimensionSizePixelSizeAttributeName))));
        }
        return sequenceSize;
    }

    private Dataset readDataset(Element datasetElement) {
        Dataset result = new Dataset(Integer.parseInt(datasetElement.getAttribute(XmlTransformation.datasetDimensionAttributeName)), PointType.valueOf(datasetElement.getAttribute(XmlTransformation.datasetPointTypeAttributeName)));
        ArrayList pointElements = XMLUtil.getElements((Node)datasetElement);
        for (Element pointElement : pointElements) {
            result.addPoint(this.readPoint(pointElement));
        }
        return result;
    }

    private Point readPoint(Element pointElement) {
        ArrayList coordinateElements = XMLUtil.getElements((Node)pointElement);
        Point result = new Point(coordinateElements.size());
        for (Element coordinate : coordinateElements) {
            result.getMatrix().set(Integer.parseInt(coordinate.getAttribute(XmlTransformation.coordinateDimensionAttributeName)), 0, Double.parseDouble(coordinate.getTextContent()));
        }
        return result;
    }
}

