/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.transformation;

import Jama.Matrix;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;

public class AffineTransformation
implements Transformation {
    private Matrix A;
    protected Matrix T;

    public AffineTransformation(Matrix A, Matrix T) {
        this.A = A;
        this.T = T;
    }

    public AffineTransformation(Matrix M) {
        this.A = M.getMatrix(0, M.getRowDimension() - 2, 0, M.getColumnDimension() - 2);
        this.T = M.getMatrix(0, M.getRowDimension() - 2, M.getColumnDimension() - 1, M.getColumnDimension() - 1);
    }

    @Override
    public Point apply(Point point) {
        return new Point(this.A.times(point.getMatrix()).plus(this.T));
    }

    @Override
    public Dataset apply(Dataset dataset) {
        Matrix M = this.getHomogeneousMatrix().times(dataset.getHomogeneousMatrixRight().transpose()).transpose();
        M = M.getMatrix(0, M.getRowDimension() - 1, 0, M.getColumnDimension() - 2);
        return new Dataset(M, dataset.getPointType());
    }

    public Matrix getMatrixRight() {
        int i;
        Matrix M = new Matrix(this.A.getRowDimension(), this.A.getColumnDimension() + 1, 0.0);
        for (i = 0; i < this.A.getRowDimension(); ++i) {
            for (int j = 0; j < this.A.getColumnDimension(); ++j) {
                M.set(i, j, this.A.get(i, j));
            }
        }
        for (i = 0; i < this.T.getRowDimension(); ++i) {
            M.set(i, M.getColumnDimension() - 1, this.T.get(i, 0));
        }
        return M;
    }

    public Matrix getMatrixLeft() {
        int i;
        Matrix M = new Matrix(this.A.getRowDimension(), this.A.getColumnDimension() + 1, 0.0);
        for (i = 0; i < this.A.getRowDimension(); ++i) {
            for (int j = 0; j < this.A.getColumnDimension(); ++j) {
                M.set(i, j + 1, this.A.get(i, j));
            }
        }
        for (i = 0; i < this.T.getRowDimension(); ++i) {
            M.set(i, 0, this.T.get(i, 0));
        }
        return M;
    }

    public Matrix getHomogeneousMatrix() {
        Matrix H = this.getMatrixRight();
        Matrix M = new Matrix(H.getRowDimension() + 1, H.getColumnDimension(), 0.0);
        M.setMatrix(0, H.getRowDimension() - 1, 0, H.getColumnDimension() - 1, H);
        M.set(M.getRowDimension() - 1, M.getColumnDimension() - 1, 1.0);
        return M;
    }
}

