/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import icy.gui.dialog.MessageDialog;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.swing.JButton;
import plugins.perrine.ec_clem.ec_clem.ui.ProgressBarManager;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;
import plugins.perrine.ec_clem.ec_clem.workspace.WorkspaceTransformer;

public class UpdateTransformationButton
extends JButton {
    private ProgressBarManager progressBarManager;
    private Workspace workspace;

    @Inject
    public UpdateTransformationButton(ProgressBarManager progressBarManager) {
        super("Update Transformation");
        this.progressBarManager = progressBarManager;
        this.setToolTipText("Press this button if you have moved the points, prepared set of points, \n or obtained some black part of the image. This will refresh it");
        this.addActionListener(arg0 -> this.action());
    }

    private void action() {
        WorkspaceTransformer workspaceTransformer = new WorkspaceTransformer(this.workspace);
        this.progressBarManager.subscribe(workspaceTransformer);
        CompletableFuture.runAsync(workspaceTransformer).exceptionally(e -> {
            e.printStackTrace();
            MessageDialog.showDialog((String)("Something went wrong: " + e.getCause().getMessage()), (int)0);
            return null;
        });
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

