/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui.overlay;

import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSetFactory;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class ErrorInPositionOverlay
extends Overlay {
    private Workspace workspace;
    private FiducialSetFactory fiducialSetFactory;

    @Inject
    public ErrorInPositionOverlay(FiducialSetFactory fiducialSetFactory) {
        super("Difference in position");
        this.fiducialSetFactory = fiducialSetFactory;
    }

    public ErrorInPositionOverlay setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (canvas instanceof IcyCanvas2D && g != null && this.workspace.getTransformationSchema() != null) {
            FiducialSet fiducialSet = this.fiducialSetFactory.getFrom(this.workspace);
            Dataset sourceDataset = fiducialSet.getSourceDataset();
            Dataset targetDataset = fiducialSet.getTargetDataset();
            g.setColor(Color.RED);
            g.setStroke(new BasicStroke(1.0f));
            for (int index = 0; index < sourceDataset.getN(); ++index) {
                double error = sourceDataset.getPoint(index).getDistance(targetDataset.getPoint(index));
                g.drawOval((int)Math.round((sourceDataset.getPoint(index).getMatrix().get(0, 0) - error) / sequence.getPixelSizeX()), (int)Math.round((sourceDataset.getPoint(index).getMatrix().get(1, 0) - error) / sequence.getPixelSizeY()), (int)Math.round(error / sequence.getPixelSizeX() * 2.0), (int)Math.round(error / sequence.getPixelSizeY() * 2.0));
            }
        }
    }
}

