/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.error.ellipse.rigid;

import Jama.Matrix;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.matrix.MatrixUtil;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;

public abstract class InverseFisherInformationMatrixEstimator {
    private MatrixUtil matrixUtil;

    public InverseFisherInformationMatrixEstimator(MatrixUtil matrixUtil) {
        this.matrixUtil = matrixUtil;
    }

    public Matrix getInverseFisherInformationMatrix(FiducialSet fiducialSet, RegistrationParameter registrationParameter) {
        Matrix noiseCovarianceInv = this.matrixUtil.pseudoInverse(registrationParameter.getNoiseCovariance());
        Matrix H = new Matrix(this.getNParameters(), this.getNParameters(), 0.0);
        for (int i = 0; i < this.getNParameters(); ++i) {
            for (int j = 0; j <= i; ++j) {
                double Hij = 0.0;
                for (int n = 0; n < fiducialSet.getN(); ++n) {
                    Hij += noiseCovarianceInv.times(2.0).times(this.getGradientX(fiducialSet, registrationParameter, n, j)).transpose().times(this.getGradientX(fiducialSet, registrationParameter, n, i)).plus(noiseCovarianceInv.times(2.0).times(this.getX(fiducialSet, registrationParameter, n)).transpose().times(this.getHessianX(fiducialSet, registrationParameter, n, i, j))).get(0, 0);
                }
                H.set(i, j, Hij / 2.0);
                H.set(j, i, Hij / 2.0);
            }
        }
        return this.matrixUtil.pseudoInverse(H);
    }

    protected abstract int getNParameters();

    protected abstract Matrix getX(FiducialSet var1, RegistrationParameter var2, int var3);

    protected abstract Matrix getGradientX(FiducialSet var1, RegistrationParameter var2, int var3, int var4);

    protected abstract Matrix getHessianX(FiducialSet var1, RegistrationParameter var2, int var3, int var4, int var5);
}

