/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fiducialset;

import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;

public class FiducialSet
implements Cloneable {
    private int minNumberOfPoints = 3;
    private Dataset sourceDataset;
    private Dataset targetDataset;
    private int n;

    public FiducialSet(Dataset sourceDataset, Dataset targetDataset) {
        this.sourceDataset = sourceDataset;
        this.targetDataset = targetDataset;
        this.n = sourceDataset.getN();
        if (this.n < this.minNumberOfPoints) {
            throw new RuntimeException(String.format("Minimum number of fiducial points is %d", this.minNumberOfPoints));
        }
        if (targetDataset.getPointType() != PointType.FIDUCIAL || sourceDataset.getPointType() != PointType.FIDUCIAL) {
            throw new RuntimeException("Source dataset and target dataset should have FIDUCIAL type");
        }
        if (sourceDataset.getN() != targetDataset.getN()) {
            throw new RuntimeException("Source dataset and target dataset do not have the same number of points");
        }
    }

    public FiducialSet clone() {
        FiducialSet clone = null;
        try {
            clone = (FiducialSet)super.clone();
            clone.sourceDataset = this.sourceDataset.clone();
            clone.targetDataset = this.targetDataset.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public void remove(int i) {
        this.sourceDataset.removePoint(i);
        this.targetDataset.removePoint(i);
        --this.n;
    }

    public void add(int i, Point source, Point target) {
        this.sourceDataset.addPoint(source, i);
        this.targetDataset.addPoint(target, i);
        ++this.n;
    }

    public Dataset getSourceDataset() {
        return this.sourceDataset;
    }

    public Dataset getTargetDataset() {
        return this.targetDataset;
    }

    public int getN() {
        return this.n;
    }
}

