/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.fixtures.fiducialset;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import javax.inject.Inject;
import org.apache.commons.math3.distribution.MultivariateNormalDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;
import org.apache.commons.math3.random.SynchronizedRandomGenerator;
import plugins.perrine.ec_clem.ec_clem.fiducialset.FiducialSet;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.Dataset;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;

public class TestFiducialSetFactory {
    private SynchronizedRandomGenerator random = new SynchronizedRandomGenerator(new JDKRandomGenerator());

    @Inject
    public TestFiducialSetFactory() {
    }

    public FiducialSet getIdentityFiducialSet2DWithNoise100_0_0_100() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{7.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{8.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{9.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{12.0}, {25.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-5.66543}, {12.11796}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{3.26596}, {-15.17124}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.39882}, {0.82489}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{3.33783}, {-1.9317}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{15.97593}, {8.84992}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.17434}, {3.52065}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{13.53713}, {34.08704}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getSimpleRotationFiducialSet2D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{7.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{8.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{9.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{12.0}, {25.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.3623365}, {2.206516}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-1.5478108}, {1.613779}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.5927372}, {-1.910147}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{5.2036726}, {6.849948}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{6.1587463}, {7.146317}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{7.7065571}, {5.532538}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{4.0516693}, {27.433264}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getSimpleTranslationFiducialSet2D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{7.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{8.0}, {5.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{9.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{12.0}, {25.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{2.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {-1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{8.0}, {6.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{9.0}, {6.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{10.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{13.0}, {26.0}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getIdentityFiducialSet3D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getSimpleRotationFiducialSet3D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {2.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {-2.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{4.0}, {0.0}, {6.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {2.0}, {6.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {2.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {-2.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{4.0}, {0.0}, {6.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-4.0}, {2.0}, {6.0}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getSimpleTranslationFiducialSet3D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{2.0}, {3.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {3.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {-1.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{2.0}, {3.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{2.0}, {3.0}, {2.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {3.0}, {3.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {-1.0}, {4.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{2.0}, {3.0}, {4.0}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getComplexRotationFiducialSet3D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{-1.0}, {2.0}, {2.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{0.0}, {-2.0}, {3.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{1.0}, {2.0}, {3.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-2.1213204}, {1.0}, {-0.7071068}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-2.8284272}, {-1.0}, {0.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-0.7071068}, {0.0}, {3.535534}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-3.535534}, {1.0}, {0.7071068}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-2.1213204}, {1.0}, {-0.7071068}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-2.8284272}, {-1.0}, {0.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-0.7071068}, {0.0}, {3.535534}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{-3.535534}, {1.0}, {0.7071068}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getTranslationRotationScalingFiducialSet3D() {
        ArrayList<Point> sourcePoints = new ArrayList<Point>();
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{168.0454}, {158.1362}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{343.47724}, {298.7388}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{236.15495}, {427.03367}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{59.662}, {306.42565}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{123.16499}, {226.27039}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{189.46474}, {271.82878}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{229.31887}, {321.75632}, {1.0}})));
        sourcePoints.add(new Point(new Matrix((double[][])new double[][]{{298.71181}, {368.81018}, {1.0}})));
        Dataset source = new Dataset(sourcePoints, PointType.FIDUCIAL);
        ArrayList<Point> targetPoints = new ArrayList<Point>();
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{160.0}, {306.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{610.0}, {332.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{576.0}, {674.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{144.0}, {670.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{160.0}, {470.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{326.0}, {474.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{442.0}, {498.0}, {1.0}})));
        targetPoints.add(new Point(new Matrix((double[][])new double[][]{{608.0}, {502.0}, {1.0}})));
        Dataset target = new Dataset(targetPoints, PointType.FIDUCIAL);
        return new FiducialSet(source, target);
    }

    public FiducialSet getRandomFromTransformation(Transformation transformation, int n, int[] range) {
        LinkedList<Point> points = new LinkedList<Point>();
        for (int i = 0; i < n; ++i) {
            points.add(this.getRandomPoint(range));
        }
        Dataset source = new Dataset(points, PointType.FIDUCIAL);
        Dataset target = transformation.apply(source);
        return new FiducialSet(source, target);
    }

    private double[] getGaussian(double[][] covariance) {
        double[] means = new double[covariance.length];
        Arrays.fill(means, 0.0);
        MultivariateNormalDistribution multivariateNormalDistribution = new MultivariateNormalDistribution(this.random, means, covariance);
        return multivariateNormalDistribution.sample();
    }

    private double[] getUniform(int[] range) {
        double[] result = new double[range.length];
        for (int i = 0; i < range.length; ++i) {
            result[i] = this.random.nextInt(range[i]);
        }
        return result;
    }

    public Point getRandomPoint(int[] range) {
        return new Point(this.getUniform(range));
    }

    public FiducialSet getRandomAndNoisyFromTransformation(Transformation transformation, int n, int[] range, double[][] covariance) {
        FiducialSet fiducialSet = this.getRandomFromTransformation(transformation, n, range);
        this.addGaussianNoise(fiducialSet.getSourceDataset(), covariance);
        this.addGaussianNoise(fiducialSet.getTargetDataset(), covariance);
        return fiducialSet;
    }

    public Dataset addGaussianNoise(Dataset dataset, double[][] covariance) {
        for (int i = 0; i < dataset.getN(); ++i) {
            Point point = dataset.getPoint(i);
            dataset.setPoint(i, this.addGaussianNoise(point, covariance));
        }
        return dataset;
    }

    public Dataset addUniformNoise(Dataset dataset, int[] range) {
        for (int i = 0; i < dataset.getN(); ++i) {
            Point point = dataset.getPoint(i);
            dataset.setPoint(i, point.plus(this.getRandomPoint(range)));
        }
        return dataset;
    }

    public Point addGaussianNoise(Point point, double[][] covariance) {
        Point noise = new Point(this.getGaussian(covariance));
        return point.plus(noise);
    }
}

