/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.monitor;

import Jama.Matrix;
import icy.canvas.IcyCanvas;
import icy.canvas.IcyCanvas2D;
import icy.main.Icy;
import icy.painter.Overlay;
import icy.sequence.Sequence;
import icy.type.point.Point5D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import plugins.perrine.ec_clem.ec_clem.fiducialset.dataset.point.Point;
import plugins.perrine.ec_clem.ec_clem.monitor.MonitorTargetPoint;

public class MonitorTargetOverlay
extends Overlay {
    private MonitorTargetPoint monitorTargetPoint;
    private boolean notplacedyet = true;
    private Point point;

    public MonitorTargetOverlay(MonitorTargetPoint monitorTargetPoint) {
        super("Target point where to monitor accuracy");
        this.monitorTargetPoint = monitorTargetPoint;
        this.point = new Point(2);
    }

    public void mouseMove(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (this.notplacedyet && canvas instanceof IcyCanvas2D && imagePoint != null) {
            this.point.getMatrix().set(0, 0, imagePoint.getX());
            this.point.getMatrix().set(1, 0, imagePoint.getY());
            Icy.getMainInterface().setSelectedTool("none");
            this.painterChanged();
        }
    }

    public void mouseClick(MouseEvent e, Point5D.Double imagePoint, IcyCanvas canvas) {
        if (this.notplacedyet && canvas instanceof IcyCanvas2D && imagePoint != null) {
            this.notplacedyet = false;
            this.painterChanged();
            this.monitorTargetPoint.setMonitoringPoint(new Point(new Matrix((double[][])new double[][]{{imagePoint.getX()}, {imagePoint.getY()}, {imagePoint.getZ()}})));
        }
    }

    public void paint(Graphics2D g, Sequence sequence, IcyCanvas canvas) {
        if (canvas instanceof IcyCanvas2D && g != null) {
            int xm = (int)this.point.getMatrix().get(0, 0);
            int ym = (int)this.point.getMatrix().get(1, 0);
            g.setColor(Color.GREEN);
            g.setStroke(new BasicStroke(3.0f));
            int diameter = Math.round((float)sequence.getWidth() / 25.0f);
            g.drawOval(xm - diameter / 2, ym - diameter / 2, Math.round(diameter), Math.round(diameter));
            g.setStroke(new BasicStroke(1.0f));
            g.drawLine(xm - diameter / 2, ym - diameter / 2, xm + diameter / 2, ym + diameter / 2);
            g.drawLine(xm - diameter / 2, ym + diameter / 2, xm + diameter / 2, ym - diameter / 2);
            g.drawLine(xm - diameter / 2, ym - diameter / 2, xm + diameter / 2, ym + diameter / 2);
            g.drawLine(xm - diameter / 2, ym + diameter / 2, xm + diameter / 2, ym - diameter / 2);
        }
    }
}

