/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence;

import Jama.Matrix;
import javax.inject.Inject;
import plugins.perrine.ec_clem.ec_clem.matrix.MatrixUtil;
import plugins.perrine.ec_clem.ec_clem.transformation.AffineTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.SplineTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;
import vtk.vtkAbstractTransform;
import vtk.vtkMatrix4x4;
import vtk.vtkTransform;

public class VtkAbstractTransformFactory {
    private MatrixUtil matrixUtil;

    @Inject
    public VtkAbstractTransformFactory(MatrixUtil matrixUtil) {
        this.matrixUtil = matrixUtil;
    }

    public vtkAbstractTransform getFrom(Transformation transformation) {
        if (transformation instanceof AffineTransformation) {
            Matrix matrixInverse = this.matrixUtil.pseudoInverse(((AffineTransformation)transformation).getHomogeneousMatrix());
            if (matrixInverse.getRowDimension() != 4) {
                Matrix correctedmatrixinverse = new Matrix(4, 4);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        correctedmatrixinverse.set(i, j, matrixInverse.get(i, j));
                    }
                }
                correctedmatrixinverse.set(0, 3, matrixInverse.get(0, 2));
                correctedmatrixinverse.set(1, 3, matrixInverse.get(1, 2));
                correctedmatrixinverse.set(3, 3, 1.0);
                matrixInverse = correctedmatrixinverse.copy();
            }
            vtkTransform vtkTransform2 = new vtkTransform();
            vtkMatrix4x4 vtkMatrix = new vtkMatrix4x4();
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 4; ++j) {
                    vtkMatrix.SetElement(i, j, matrixInverse.get(i, j));
                }
            }
            vtkMatrix.SetElement(2, 2, 1.0);
            vtkTransform2.SetMatrix(vtkMatrix);
            return vtkTransform2;
        }
        if (transformation instanceof SplineTransformation) {
            return ((SplineTransformation)transformation).getSplineTransform().GetInverse();
        }
        throw new RuntimeException("Unsupported transformation");
    }
}

