/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.sequence_listener;

import icy.canvas.IcyCanvas2D;
import icy.main.Icy;
import icy.roi.ROI;
import icy.sequence.Sequence;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.type.point.Point5D;
import java.awt.geom.Point2D;
import java.util.List;
import javax.inject.Inject;
import plugins.kernel.roi.roi2d.plugin.ROI2DPointPlugin;
import plugins.kernel.roi.roi3d.plugin.ROI3DPointPlugin;
import plugins.perrine.ec_clem.ec_clem.roi.PointType;
import plugins.perrine.ec_clem.ec_clem.roi.RoiFactory;
import plugins.perrine.ec_clem.ec_clem.sequence_listener.SequenceListenerUtil;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class FiducialRoiListener
implements SequenceListener {
    private static PointType type = PointType.FIDUCIAL;
    private Sequence sequence;
    private Workspace workspace;
    private SequenceListenerUtil sequenceListenerUtil;
    private RoiFactory roiFactory;

    @Inject
    public FiducialRoiListener(SequenceListenerUtil sequenceListenerUtil, RoiFactory roiFactory) {
        this.sequenceListenerUtil = sequenceListenerUtil;
        this.roiFactory = roiFactory;
    }

    public FiducialRoiListener setSequence(Sequence sequence) {
        this.sequence = sequence;
        return this;
    }

    public FiducialRoiListener setWorkspace(Workspace workspace) {
        this.workspace = workspace;
        return this;
    }

    public void sequenceChanged(SequenceEvent event) {
        if (event.getSourceType() != SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI || event.getType() != SequenceEvent.SequenceEventType.ADDED) {
            return;
        }
        ROI roi = this.roiFactory.getRoiFrom((ROI)event.getSource(), this.roiFactory.getFrom(event.getSequence(), type).size() + 1, type);
        ROI roiCopy = roi.getCopy();
        Point5D position = (Point5D)roi.getPosition5D().clone();
        if (this.workspace.getTransformationSchema() == null) {
            Point2D.Double imagePosition = ((IcyCanvas2D)this.sequence.getFirstViewer().getCanvas()).canvasToImage(this.sequence.getFirstViewer().getCanvas().getCanvasSizeX() / 2, this.sequence.getFirstViewer().getCanvas().getCanvasSizeY() / 2);
            position.setX(imagePosition.getX());
            position.setY(imagePosition.getY());
        }
        position.setZ((double)this.sequence.getFirstViewer().getPositionZ());
        position.setT((double)this.sequence.getFirstViewer().getPositionT());
        position.setC((double)this.sequence.getFirstViewer().getPositionC());
        roiCopy.setPosition5D(position);
        List<SequenceListener> sequenceListeners = this.sequenceListenerUtil.removeListeners(this.sequence, FiducialRoiListener.class);
        this.sequence.addROI(roiCopy);
        this.sequenceListenerUtil.addListeners(this.sequence, sequenceListeners);
        Icy.getMainInterface().setSelectedTool(this.getSelectedTool(roi).getName());
    }

    public void sequenceClosed(Sequence sequence) {
    }

    private Class<?> getSelectedTool(ROI roi) {
        switch (roi.getDimension()) {
            case 2: {
                return ROI2DPointPlugin.class;
            }
            case 3: {
                return ROI3DPointPlugin.class;
            }
        }
        throw new RuntimeException("Unsupported dimension");
    }
}

