/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation.xml;

import Jama.Matrix;
import icy.util.XMLUtil;
import java.io.File;
import java.util.Date;
import javax.inject.Inject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.writer.XmlTransformationWriter;
import plugins.perrine.ec_clem.ec_clem.transformation.AffineTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.SplineTransformation;
import plugins.perrine.ec_clem.ec_clem.transformation.Transformation;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class TransformationToXmlFileWriter {
    @Inject
    public TransformationToXmlFileWriter() {
    }

    public void save(Transformation transformation, TransformationSchema transformationSchema, File xmlFile) {
        if (!(transformation instanceof AffineTransformation)) {
            if (transformation instanceof SplineTransformation) {
                throw new RuntimeException("Not implemented");
            }
            throw new RuntimeException("Missing binding");
        }
        this.format((AffineTransformation)transformation, transformationSchema, xmlFile);
    }

    private void format(AffineTransformation transformation, TransformationSchema transformationSchema, File xmlFile) {
        Document document = XMLUtil.createDocument((boolean)true);
        this.writeMatrix(document, transformation.getHomogeneousMatrix());
        XmlTransformationWriter writer = new XmlTransformationWriter();
        writer.writeSequenceInfoOnly(document, transformationSchema);
        XMLUtil.saveDocument((Document)document, (File)xmlFile);
    }

    private void writeMatrix(Document document, Matrix matrix) {
        Element element = XMLUtil.addElement((Node)document.getDocumentElement(), (String)"MatrixTransformation");
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                XMLUtil.setAttributeDoubleValue((Element)element, (String)String.format("m%d%d", i, j), (double)matrix.get(i, j));
            }
        }
        XMLUtil.setAttributeValue((Element)element, (String)"process_date", (String)new Date().toString());
    }
}

