/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader;

import icy.util.XMLUtil;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.inject.Inject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.XmlTransformation;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlTransformationReader;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;

public class XmlTransformationElementListReader {
    private XmlTransformationReader xmlTransformationReader;

    @Inject
    public XmlTransformationElementListReader(XmlTransformationReader xmlTransformationReader) {
        this.xmlTransformationReader = xmlTransformationReader;
    }

    public Element getLastTransformationElement(Document document) {
        List<Element> list = this.read(document);
        this.sortTransformationElementsByDate(list);
        return list.get(list.size() - 1);
    }

    public List<TransformationSchema> getTransformationList(Document document) {
        ArrayList<TransformationSchema> transformationSchemaList = new ArrayList<TransformationSchema>();
        List<Element> elementList = this.read(document);
        this.sortTransformationElementsByDate(elementList);
        for (Element element : elementList) {
            transformationSchemaList.add(this.xmlTransformationReader.read(element));
        }
        return transformationSchemaList;
    }

    private List<Element> read(Document document) {
        return XMLUtil.getElements((Node)document.getDocumentElement(), (String)XmlTransformation.transformationElementName);
    }

    private void sortTransformationElementsByDate(List<Element> list) {
        list.sort(Comparator.comparing(o -> ZonedDateTime.parse(o.getAttribute(XmlTransformation.transformationDateAttributeName))));
    }

    @Inject
    public void setXmlTransformationReader(XmlTransformationReader xmlTransformationReader) {
        this.xmlTransformationReader = xmlTransformationReader;
    }
}

