/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.ec_clem.ui;

import icy.gui.dialog.MessageDialog;
import icy.gui.viewer.Viewer;
import icy.image.colormap.FireColorMap;
import icy.image.colormap.IcyColorMap;
import icy.system.thread.ThreadUtil;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.swing.JButton;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TargetRegistrationErrorMapFactory;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TargetRegistrationErrorMapSupplier;
import plugins.perrine.ec_clem.ec_clem.ui.ProgressBarManager;
import plugins.perrine.ec_clem.ec_clem.workspace.Workspace;

public class ComputeErrorMapButton
extends JButton {
    private Workspace workspace;
    private TargetRegistrationErrorMapFactory targetRegistrationErrorMapFactory;
    private ProgressBarManager progressBarManager;

    @Inject
    public ComputeErrorMapButton(TargetRegistrationErrorMapFactory targetRegistrationErrorMapFactory, ProgressBarManager progressBarManager) {
        super("Compute the whole predicted error map ");
        this.targetRegistrationErrorMapFactory = targetRegistrationErrorMapFactory;
        this.progressBarManager = progressBarManager;
        this.setToolTipText(" This will compute a new image were each pixel value stands for the statistical registration error (called Target Registration Error");
        this.addActionListener(arg0 -> this.action());
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    private void action() {
        try {
            TargetRegistrationErrorMapSupplier targetRegistrationErrorMapSupplier = this.targetRegistrationErrorMapFactory.getFrom(this.workspace);
            this.progressBarManager.subscribe(targetRegistrationErrorMapSupplier);
            CompletableFuture.supplyAsync(targetRegistrationErrorMapSupplier).thenAccept(sequence -> ThreadUtil.invokeLater(() -> {
                Viewer viewer = new Viewer(sequence);
                viewer.getLut().getLutChannel(0).setColorMap((IcyColorMap)new FireColorMap(), false);
            }));
        }
        catch (RuntimeException e) {
            MessageDialog.showDialog((String)e.getMessage(), (int)0);
        }
    }
}

