/*
 * Decompiled with CFR 0.152.
 */
package plugins.perrine.ec_clem.error;

import icy.gui.viewer.Viewer;
import icy.image.colormap.FireColorMap;
import icy.image.colormap.IcyColorMap;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import java.io.File;
import javax.inject.Inject;
import plugins.adufour.blocks.lang.Block;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzComponent;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.ezplug.EzVarFile;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarFile;
import plugins.adufour.vars.lang.VarSequence;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TargetRegistrationErrorMapFactory;
import plugins.perrine.ec_clem.ec_clem.error.fitzpatrick.TargetRegistrationErrorMapSupplier;
import plugins.perrine.ec_clem.ec_clem.registration.RegistrationParameter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.csv.TransformationToCsvFileWriter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation.csv.TransformationToCsvFormatter;
import plugins.perrine.ec_clem.ec_clem.storage.transformation_schema.reader.XmlToTransformationSchemaFileReader;
import plugins.perrine.ec_clem.ec_clem.transformation.RegistrationParameterFactory;
import plugins.perrine.ec_clem.ec_clem.transformation.schema.TransformationSchema;
import plugins.perrine.ec_clem.error.DaggerEcClemErrorComponent;

public class EcClemError
extends EzPlug
implements Block {
    private XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader;
    private RegistrationParameterFactory registrationParameterFactory;
    private TransformationToCsvFormatter transformationToCsvFormatter;
    private TargetRegistrationErrorMapFactory targetRegistrationErrorMapFactory;
    private TransformationToCsvFileWriter transformationToCsvFileWriter;
    private EzVarFile inputFiducialFile = new EzVarFile("transformation schema file", null);
    private VarFile outputTransformationFile = new VarFile("transformation file", null);
    private VarSequence outputErrorMap = new VarSequence("error map", null);

    public EcClemError() {
        DaggerEcClemErrorComponent.builder().build().inject(this);
    }

    public void declareInput(VarList varList) {
        varList.add("0", this.inputFiducialFile.getVariable());
    }

    public void declareOutput(VarList varList) {
        varList.add("1", (Var)this.outputTransformationFile);
        varList.add("2", (Var)this.outputErrorMap);
    }

    protected void initialize() {
        this.addEzComponent((EzComponent)this.inputFiducialFile);
    }

    protected void execute() {
        TransformationSchema transformationSchema = this.xmlToTransformationSchemaFileReader.read((File)this.inputFiducialFile.getValue());
        RegistrationParameter registrationParameter = this.registrationParameterFactory.getFrom(transformationSchema);
        File outputFile = new File("transformation");
        this.transformationToCsvFileWriter.save(registrationParameter.getTransformation(), outputFile);
        this.outputTransformationFile.setValue((Object)outputFile);
        TargetRegistrationErrorMapSupplier targetRegistrationErrorMapSupplier = this.targetRegistrationErrorMapFactory.getFrom(transformationSchema);
        this.outputErrorMap.setValue(targetRegistrationErrorMapSupplier.get());
        if (!this.isHeadLess()) {
            ThreadUtil.invokeLater(() -> {
                Viewer viewer = new Viewer((Sequence)this.outputErrorMap.getValue());
                viewer.getLut().getLutChannel(0).setColorMap((IcyColorMap)new FireColorMap(), false);
            });
        }
    }

    public void clean() {
    }

    @Inject
    public void setXmlToTransformationSchemaFileReader(XmlToTransformationSchemaFileReader xmlToTransformationSchemaFileReader) {
        this.xmlToTransformationSchemaFileReader = xmlToTransformationSchemaFileReader;
    }

    @Inject
    public void setRegistrationParameterFactory(RegistrationParameterFactory registrationParameterFactory) {
        this.registrationParameterFactory = registrationParameterFactory;
    }

    @Inject
    public void setTransformationToCsvFormatter(TransformationToCsvFormatter transformationToCsvFormatter) {
        this.transformationToCsvFormatter = transformationToCsvFormatter;
    }

    @Inject
    public void setTargetRegistrationErrorMapFactory(TargetRegistrationErrorMapFactory targetRegistrationErrorMapFactory) {
        this.targetRegistrationErrorMapFactory = targetRegistrationErrorMapFactory;
    }

    @Inject
    public void setTransformationToCsvFileWriter(TransformationToCsvFileWriter transformationToCsvFileWriter) {
        this.transformationToCsvFileWriter = transformationToCsvFileWriter;
    }
}

