/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.gui;

import icy.gui.component.NumberTextField;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.dialog.MessageDialog;
import icy.resource.icon.IcyIcon;
import icy.system.IcyExceptionHandler;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import mmcorej.CMMCore;
import mmcorej.DeviceType;
import mmcorej.MMCoreJ;
import mmcorej.StrVector;
import org.micromanager.MMStudio;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;
import plugins.tprovoost.Microscopy.MicroManager.gui.MMMainFrame;

public class CameraSettingsPanel
extends JPanel
implements Runnable {
    private static final long serialVersionUID = -1799340043444887652L;
    final MMMainFrame mainFrame;
    String cameraName;
    NumberTextField exposureField;
    JComboBox binningCombo;
    JComboBox shuttersCombo;
    IcyToggleButton shutterOpenBtn;
    JCheckBox autoShutterCheckbox;
    IcyButton autofocusBtn;
    IcyButton autofocusSettingBtn;
    boolean modifyingExposure;
    boolean modifyingBinning;
    boolean modifyingShutter;
    private JLabel lblAutoShutter;

    public CameraSettingsPanel(MMMainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.modifyingExposure = false;
        this.modifyingBinning = false;
        this.modifyingShutter = false;
        this.initialize();
        this.exposureField.addValueListener(new NumberTextField.ValueChangeListener(){

            public void valueChanged(double newValue, boolean validate) {
                if (validate) {
                    CameraSettingsPanel.this.setExposureCore(newValue);
                }
            }
        });
        this.binningCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CameraSettingsPanel.this.binningCombo.getSelectedItem() != null) {
                    CameraSettingsPanel.this.setBinningCore(CameraSettingsPanel.this.getBinning());
                }
            }
        });
        this.shuttersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (CameraSettingsPanel.this.shuttersCombo.getSelectedItem() != null) {
                    CameraSettingsPanel.this.setShutterCore(CameraSettingsPanel.this.getShutter());
                }
            }
        });
        this.shutterOpenBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    boolean open = CameraSettingsPanel.this.shutterOpenBtn.isSelected();
                    MicroManager.setShutterOpen(open);
                    CameraSettingsPanel.this.refreshOpenShutterButton(open);
                }
                catch (Throwable t) {
                    MessageDialog.showDialog((String)("Cannot change shutter state: " + t), (int)0);
                    System.err.println("Cannot change shutter state: " + t);
                }
            }
        });
        this.lblAutoShutter.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CameraSettingsPanel.this.autoShutterCheckbox.doClick();
            }
        });
        this.autoShutterCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean autoshutter = CameraSettingsPanel.this.autoShutterCheckbox.isSelected();
                try {
                    MicroManager.setShutterOpen(false);
                    CameraSettingsPanel.this.shutterOpenBtn.setSelected(false);
                    CameraSettingsPanel.this.refreshOpenShutterButton(false);
                    MicroManager.setAutoShutter(autoshutter);
                    if (StringUtil.isEmpty((String)MicroManager.getShutter())) {
                        CameraSettingsPanel.this.shutterOpenBtn.setEnabled(false);
                    } else {
                        CameraSettingsPanel.this.shutterOpenBtn.setEnabled(!autoshutter);
                    }
                }
                catch (Throwable t) {
                    MessageDialog.showDialog((String)("Cannot set auto shutter: " + t), (int)0);
                    System.err.println("Cannot set auto shutter: " + t);
                }
            }
        });
        this.autofocusBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroManager.getMMStudio().autofocusNow();
            }
        });
        this.autofocusSettingBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MicroManager.getMMStudio().showAutofocusDialog();
            }
        });
    }

    private void initialize() {
        this.setBorder(new TitledBorder(null, "Camera settings", 4, 2, null, null));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{70, 32, 24, 24, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        this.exposureField = new NumberTextField();
        GridBagConstraints gbc_lblExposurems = new GridBagConstraints();
        gbc_lblExposurems.gridwidth = 2;
        gbc_lblExposurems.anchor = 17;
        gbc_lblExposurems.insets = new Insets(0, 0, 5, 5);
        gbc_lblExposurems.gridx = 0;
        gbc_lblExposurems.gridy = 0;
        JLabel lblExposurems = new JLabel("Exposure (ms)");
        this.add((Component)lblExposurems, gbc_lblExposurems);
        GridBagConstraints gbc_exposureField = new GridBagConstraints();
        gbc_exposureField.gridwidth = 2;
        gbc_exposureField.fill = 1;
        gbc_exposureField.insets = new Insets(0, 0, 5, 0);
        gbc_exposureField.gridx = 2;
        gbc_exposureField.gridy = 0;
        this.add((Component)this.exposureField, gbc_exposureField);
        GridBagConstraints gbc_lblBinning = new GridBagConstraints();
        gbc_lblBinning.gridwidth = 2;
        gbc_lblBinning.anchor = 17;
        gbc_lblBinning.insets = new Insets(0, 0, 5, 5);
        gbc_lblBinning.gridx = 0;
        gbc_lblBinning.gridy = 1;
        JLabel lblBinning = new JLabel("Binning");
        this.add((Component)lblBinning, gbc_lblBinning);
        this.binningCombo = new JComboBox();
        GridBagConstraints gbc_binningCombo = new GridBagConstraints();
        gbc_binningCombo.gridwidth = 2;
        gbc_binningCombo.fill = 1;
        gbc_binningCombo.insets = new Insets(0, 0, 5, 0);
        gbc_binningCombo.gridx = 2;
        gbc_binningCombo.gridy = 1;
        this.add((Component)this.binningCombo, gbc_binningCombo);
        GridBagConstraints gbc_lblShutter = new GridBagConstraints();
        gbc_lblShutter.gridwidth = 2;
        gbc_lblShutter.anchor = 17;
        gbc_lblShutter.insets = new Insets(0, 0, 5, 5);
        gbc_lblShutter.gridx = 0;
        gbc_lblShutter.gridy = 2;
        JLabel lblShutter = new JLabel("Shutter");
        this.add((Component)lblShutter, gbc_lblShutter);
        this.shuttersCombo = new JComboBox();
        GridBagConstraints gbc_shuttersCombo = new GridBagConstraints();
        gbc_shuttersCombo.gridwidth = 2;
        gbc_shuttersCombo.insets = new Insets(0, 0, 5, 0);
        gbc_shuttersCombo.fill = 1;
        gbc_shuttersCombo.gridx = 2;
        gbc_shuttersCombo.gridy = 2;
        this.add((Component)this.shuttersCombo, gbc_shuttersCombo);
        this.shutterOpenBtn = new IcyToggleButton("Open", new IcyIcon("shutter"));
        this.shutterOpenBtn.setIconTextGap(10);
        this.shutterOpenBtn.setToolTipText("Open / close the shutter");
        this.lblAutoShutter = new JLabel("Auto shutter");
        this.lblAutoShutter.setToolTipText("Enabled auto open/close shutter");
        GridBagConstraints gbc_lblAutoShutter = new GridBagConstraints();
        gbc_lblAutoShutter.anchor = 17;
        gbc_lblAutoShutter.insets = new Insets(0, 0, 5, 5);
        gbc_lblAutoShutter.gridx = 0;
        gbc_lblAutoShutter.gridy = 3;
        this.add((Component)this.lblAutoShutter, gbc_lblAutoShutter);
        this.autoShutterCheckbox = new JCheckBox("");
        this.autoShutterCheckbox.setToolTipText("Enabled auto open/close shutter");
        this.autoShutterCheckbox.setHorizontalTextPosition(10);
        GridBagConstraints gbc_autoShutterCheckbox = new GridBagConstraints();
        gbc_autoShutterCheckbox.anchor = 17;
        gbc_autoShutterCheckbox.insets = new Insets(0, 0, 5, 5);
        gbc_autoShutterCheckbox.gridx = 1;
        gbc_autoShutterCheckbox.gridy = 3;
        this.add((Component)this.autoShutterCheckbox, gbc_autoShutterCheckbox);
        GridBagConstraints gbc_shutterBtn = new GridBagConstraints();
        gbc_shutterBtn.fill = 1;
        gbc_shutterBtn.gridwidth = 2;
        gbc_shutterBtn.insets = new Insets(0, 0, 5, 0);
        gbc_shutterBtn.gridx = 2;
        gbc_shutterBtn.gridy = 3;
        this.add((Component)this.shutterOpenBtn, gbc_shutterBtn);
        JLabel lblAutofocus = new JLabel("Autofocus");
        GridBagConstraints gbc_lblAutofocus = new GridBagConstraints();
        gbc_lblAutofocus.gridwidth = 2;
        gbc_lblAutofocus.anchor = 17;
        gbc_lblAutofocus.insets = new Insets(0, 0, 0, 5);
        gbc_lblAutofocus.gridx = 0;
        gbc_lblAutofocus.gridy = 4;
        this.add((Component)lblAutofocus, gbc_lblAutofocus);
        this.autofocusBtn = new IcyButton(new IcyIcon("autofocus"));
        this.autofocusBtn.setToolTipText("Perform autofocus now");
        GridBagConstraints gbc_autofocusBtn = new GridBagConstraints();
        gbc_autofocusBtn.fill = 1;
        gbc_autofocusBtn.insets = new Insets(0, 0, 0, 5);
        gbc_autofocusBtn.gridx = 2;
        gbc_autofocusBtn.gridy = 4;
        this.add((Component)this.autofocusBtn, gbc_autofocusBtn);
        this.autofocusSettingBtn = new IcyButton(new IcyIcon("af_setting"));
        this.autofocusSettingBtn.setToolTipText("Autofocus settings");
        GridBagConstraints gbc_autoFocusSettingBtn = new GridBagConstraints();
        gbc_autoFocusSettingBtn.fill = 1;
        gbc_autoFocusSettingBtn.gridx = 3;
        gbc_autoFocusSettingBtn.gridy = 4;
        this.add((Component)this.autofocusSettingBtn, gbc_autoFocusSettingBtn);
    }

    MMStudio getMMStudio() {
        return this.mainFrame.getMMStudio();
    }

    CMMCore getCore() {
        return this.getMMStudio().getCore();
    }

    public void lock() {
        this.mainFrame.lock();
    }

    public void unlock() {
        this.mainFrame.unlock();
    }

    public void logError(Exception e) {
        this.getMMStudio().logError(e);
    }

    public void logError(Exception e, String msg) {
        this.getMMStudio().logError(e, msg);
    }

    public String getCameraName() {
        return this.cameraName;
    }

    public double getExposure() {
        return this.exposureField.getNumericValue();
    }

    public int getBinning() {
        Object item = this.binningCombo.getSelectedItem();
        if (item != null) {
            return StringUtil.parseInt((String)((String)item).substring(0, 1), (int)1);
        }
        return 1;
    }

    public String getShutter() {
        Object item = this.shuttersCombo.getSelectedItem();
        if (item != null) {
            return (String)item;
        }
        return "";
    }

    void setExposureCore(double value) {
        if (this.modifyingExposure) {
            return;
        }
        double exposure = Math.max(1.0, value);
        try {
            MicroManager.setExposure(exposure);
        }
        catch (Exception e) {
            this.logError(e, "Couldn't set exposure time.");
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
        }
    }

    void setBinningCore(int value) {
        if (this.modifyingBinning) {
            return;
        }
        int binning = Math.max(1, value);
        try {
            MicroManager.setBinning(binning);
        }
        catch (Exception e) {
            this.logError(e, "Couldn't set camera binning.");
            IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
        }
    }

    void setShutterCore(String value) {
        if (this.modifyingShutter) {
            return;
        }
        try {
            MicroManager.setShutter(value);
        }
        catch (Exception e) {
            this.getMMStudio().logError(e);
        }
    }

    public void onExposureChanged(final double exposure) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraSettingsPanel.this.modifyingExposure = true;
                try {
                    CameraSettingsPanel.this.exposureField.setText(StringUtil.toString((double)exposure));
                }
                finally {
                    CameraSettingsPanel.this.modifyingExposure = false;
                }
            }
        });
    }

    public void onBinningChanged(final String propValue) {
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraSettingsPanel.this.modifyingBinning = true;
                try {
                    CameraSettingsPanel.this.binningCombo.setSelectedItem(propValue);
                }
                finally {
                    CameraSettingsPanel.this.modifyingBinning = false;
                }
            }
        });
    }

    void refreshCameraName() {
        this.cameraName = this.getCore().getCameraDevice();
    }

    void refreshExposureComponent() {
        try {
            double exposure = this.getCore().getExposure();
            this.modifyingExposure = true;
            try {
                this.exposureField.setText(String.valueOf(exposure));
            }
            finally {
                this.modifyingExposure = false;
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshBinningComponent() {
        CMMCore core = this.getCore();
        if (core == null) {
            return;
        }
        try {
            String binning;
            StrVector availableBinnings;
            if (!StringUtil.isEmpty((String)this.cameraName)) {
                this.lock();
                try {
                    availableBinnings = core.getAllowedPropertyValues(this.cameraName, MMCoreJ.getG_Keyword_Binning());
                    binning = core.getProperty(this.cameraName, MMCoreJ.getG_Keyword_Binning());
                }
                finally {
                    this.unlock();
                }
            } else {
                availableBinnings = new StrVector();
                availableBinnings.add("1");
                binning = "1";
            }
            this.modifyingBinning = true;
            try {
                this.binningCombo.removeAllItems();
                for (String v : availableBinnings) {
                    this.binningCombo.addItem(v);
                }
                this.binningCombo.setMaximumRowCount((int)availableBinnings.size());
                this.binningCombo.setEditable(availableBinnings.isEmpty());
                this.binningCombo.setSelectedItem(binning);
            }
            finally {
                this.modifyingBinning = false;
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshShutterComponents() {
        CMMCore core = this.getCore();
        if (core == null) {
            return;
        }
        try {
            boolean shutterOpen;
            boolean autoShutter;
            String shutter;
            StrVector availableShutters;
            this.lock();
            try {
                availableShutters = core.getLoadedDevicesOfType(DeviceType.ShutterDevice);
                shutter = core.getShutterDevice();
                autoShutter = core.getAutoShutter();
                shutterOpen = core.getShutterOpen();
            }
            finally {
                this.unlock();
            }
            this.modifyingShutter = true;
            try {
                this.shuttersCombo.removeAllItems();
                for (String v : availableShutters) {
                    this.shuttersCombo.addItem(v);
                }
                this.shuttersCombo.setSelectedItem(shutter);
            }
            finally {
                this.modifyingShutter = false;
            }
            this.shutterOpenBtn.setSelected(shutterOpen);
            this.refreshOpenShutterButton(shutterOpen);
            if (StringUtil.isEmpty((String)shutter)) {
                this.shutterOpenBtn.setEnabled(false);
            } else {
                this.shutterOpenBtn.setEnabled(!autoShutter);
            }
            this.autoShutterCheckbox.setSelected(autoShutter);
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    void refreshOpenShutterButton(boolean open) {
        if (open) {
            this.shutterOpenBtn.setText("Close");
            this.shutterOpenBtn.setToolTipText("Close the shutter (currently opened)");
        } else {
            this.shutterOpenBtn.setText("Open");
            this.shutterOpenBtn.setToolTipText("Open the shutter (currently closed)");
        }
    }

    public void refreshNow() {
        this.refreshCameraName();
        this.refreshExposureComponent();
        this.refreshBinningComponent();
        this.refreshShutterComponents();
    }

    public void refresh() {
        ThreadUtil.bgRunSingle((Runnable)this);
    }

    @Override
    public void run() {
        ThreadUtil.sleep((int)20);
        ThreadUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CameraSettingsPanel.this.refreshNow();
            }
        });
    }
}

