/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import loci.common.DateTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class BaseZeissReader
extends FormatReader {
    protected int bpp;
    protected String[] imageFiles;
    protected int[] offsets;
    protected int[][] coordinates;
    protected transient Timestamp acquisitionDate;
    protected Map<Integer, String> timestamps;
    protected Map<Integer, String> exposureTime;
    protected int cIndex = -1;
    protected boolean isJPEG;
    protected boolean isZlib;
    protected int realWidth;
    protected int realHeight;
    protected List<String> tagsToParse;
    protected int nextEmWave = 0;
    protected int nextExWave = 0;
    protected int nextChName = 0;
    protected final Map<Integer, Length> stageX = new HashMap<Integer, Length>();
    protected final Map<Integer, Length> stageY = new HashMap<Integer, Length>();
    protected int timepoint = 0;
    protected int[] channelColors;
    protected int lastPlane = 0;
    protected final Map<Integer, Integer> tiles = new HashMap<Integer, Integer>();
    protected final Map<Integer, Double> detectorGain = new HashMap<Integer, Double>();
    protected final Map<Integer, Double> detectorOffset = new HashMap<Integer, Double>();
    protected final Map<Integer, Length> emWavelength = new HashMap<Integer, Length>();
    protected final Map<Integer, Length> exWavelength = new HashMap<Integer, Length>();
    protected final Map<Integer, String> channelName = new HashMap<Integer, String>();
    protected Double physicalSizeX;
    protected Double physicalSizeY;
    protected Double physicalSizeZ;
    protected int rowCount;
    protected int colCount;
    protected int rawCount;
    protected String imageDescription;
    protected Set<Integer> channelIndices = new HashSet<Integer>();
    protected Set<Integer> zIndices = new HashSet<Integer>();
    protected Set<Integer> timepointIndices = new HashSet<Integer>();
    protected Set<Integer> tileIndices = new HashSet<Integer>();
    protected List<String> roiIDs = new ArrayList<String>();
    public ArrayList<Layer> layers = new ArrayList();

    public BaseZeissReader(String name, String suffix) {
        super(name, suffix);
    }

    public BaseZeissReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    protected void initFileMain(String id) throws FormatException, IOException {
        MetadataStore store = this.makeFilterMetadata();
        this.initVars(id);
        this.fillMetadataPass1(store);
        this.fillMetadataPass2(store);
        this.fillMetadataPass3(store);
        this.fillMetadataPass4(store);
        this.fillMetadataPass5(store);
        this.fillMetadataPass6(store);
        MetadataTools.populatePixels(store, this, true);
        this.storeROIs(store);
        this.fillMetadataPass7(store);
    }

    protected void initVars(String id) throws FormatException, IOException {
        this.timestamps = new HashMap<Integer, String>();
        this.exposureTime = new HashMap<Integer, String>();
        this.tagsToParse = new ArrayList<String>();
    }

    protected void countImages() {
        if (this.getImageCount() == 0) {
            ((CoreMetadata)this.core.get((int)0)).imageCount = 1;
        }
        this.offsets = new int[this.getImageCount()];
        this.coordinates = new int[this.getImageCount()][3];
        this.imageFiles = new String[this.getImageCount()];
    }

    protected void fillMetadataPass1(MetadataStore store) throws FormatException, IOException {
    }

    protected void fillMetadataPass2(MetadataStore store) throws FormatException, IOException {
        LOGGER.info("Populating metadata");
        this.stageX.clear();
        this.stageY.clear();
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.sizeZ = this.zIndices.size();
        m3.sizeT = this.timepointIndices.size();
        m3.sizeC = this.channelIndices.size();
        m3.littleEndian = true;
        m3.interleaved = true;
        m3.falseColor = true;
        m3.metadataComplete = true;
        m3.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        if (this.getImageCount() == 0 || this.getImageCount() == 1) {
            m3.imageCount = 1;
            m3.sizeZ = 1;
            m3.sizeC = 1;
            m3.sizeT = 1;
        }
        boolean bl = m3.rgb = this.bpp % 3 == 0;
        if (this.isRGB()) {
            m3.sizeC *= 3;
        }
    }

    protected void fillMetadataPass3(MetadataStore store) throws FormatException, IOException {
    }

    protected void fillMetadataPass4(MetadataStore store) throws FormatException, IOException {
        int totalTiles = this.offsets.length / this.getImageCount();
        if (totalTiles <= 1) {
            totalTiles = 1;
        }
        if (totalTiles > 1) {
            for (int i = 1; i < totalTiles; ++i) {
                this.core.add(new CoreMetadata(this, 0));
            }
        }
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.dimensionOrder = "XY";
        if (this.isRGB()) {
            m3.dimensionOrder = m3.dimensionOrder + 'C';
        }
        for (int i = 0; i < this.coordinates.length - 1; ++i) {
            int[] zct1 = this.coordinates[i];
            int[] zct2 = this.coordinates[i + 1];
            int deltaZ = zct2[0] - zct1[0];
            int deltaC = zct2[1] - zct1[1];
            int deltaT = zct2[2] - zct1[2];
            if (deltaZ > 0 && this.getDimensionOrder().indexOf(90) == -1) {
                m3.dimensionOrder = m3.dimensionOrder + 'Z';
            }
            if (deltaC > 0 && this.getDimensionOrder().indexOf(67) == -1) {
                m3.dimensionOrder = m3.dimensionOrder + 'C';
            }
            if (deltaT <= 0 || this.getDimensionOrder().indexOf(84) != -1) continue;
            m3.dimensionOrder = m3.dimensionOrder + 'T';
        }
        m3.dimensionOrder = MetadataTools.makeSaneDimensionOrder(this.getDimensionOrder());
    }

    protected void fillMetadataPass5(MetadataStore store) throws FormatException, IOException {
    }

    protected void fillMetadataPass6(MetadataStore store) throws FormatException, IOException {
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        if (this.getSizeX() == 0) {
            m3.sizeX = 1;
        }
        if (this.getSizeY() == 0) {
            m3.sizeY = 1;
        }
        if (this.bpp == 1 || this.bpp == 3) {
            m3.pixelType = 1;
        } else if (this.bpp == 2 || this.bpp == 6) {
            m3.pixelType = 3;
        }
        if (this.isJPEG) {
            m3.pixelType = 1;
        }
        m3.bitsPerPixel = FormatTools.getBytesPerPixel(m3.pixelType) * 8;
        m3.indexed = !this.isRGB() && this.channelColors != null;
        for (int i = 1; i < this.core.size(); ++i) {
            this.core.set(i, new CoreMetadata((CoreMetadata)this.core.get(0)));
        }
    }

    protected void fillMetadataPass7(MetadataStore store) throws FormatException, IOException {
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            long firstStamp = 0L;
            if (this.timestamps.size() > 0) {
                String timestamp = this.timestamps.get(0);
                store.setImageAcquisitionDate(new Timestamp(timestamp), i);
                continue;
            }
            if (this.acquisitionDate == null) continue;
            store.setImageAcquisitionDate(this.acquisitionDate, i);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            int i;
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            String objectiveID = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objectiveID, 0, 0);
            store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
            store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
            Object[] channelKeys = this.channelName.keySet().toArray(new Integer[this.channelName.size()]);
            Arrays.sort(channelKeys);
            for (i = 0; i < this.getEffectiveSizeC(); ++i) {
                String detectorID = MetadataTools.createLSID("Detector", 0, i);
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorType(MetadataTools.getDetectorType("Other"), 0, i);
                for (int s2 = 0; s2 < this.getSeriesCount(); ++s2) {
                    int c = i;
                    if (i < channelKeys.length) {
                        c = (Integer)channelKeys[i];
                    }
                    store.setDetectorSettingsID(detectorID, s2, i);
                    store.setDetectorSettingsGain(this.detectorGain.get(c), s2, i);
                    store.setDetectorSettingsOffset(this.detectorOffset.get(c), s2, i);
                    store.setChannelName(this.channelName.get(c), s2, i);
                    store.setChannelEmissionWavelength(this.emWavelength.get(c), s2, i);
                    store.setChannelExcitationWavelength(this.exWavelength.get(c), s2, i);
                    if (this.channelColors == null || i >= this.channelColors.length) continue;
                    int color = this.channelColors[i];
                    int red = color & 0xFF;
                    int green = (color & 0xFF00) >> 8;
                    int blue = (color & 0xFF0000) >> 16;
                    store.setChannelColor(new Color(red, green, blue, 255), s2, i);
                }
            }
            for (i = 0; i < this.getSeriesCount(); ++i) {
                store.setImageInstrumentRef(instrumentID, i);
                store.setObjectiveSettingsID(objectiveID, i);
                if (this.imageDescription != null) {
                    store.setImageDescription(this.imageDescription, i);
                }
                if (this.getSeriesCount() > 1) {
                    store.setImageName("Tile #" + (i + 1), i);
                }
                Length sizeX = FormatTools.getPhysicalSizeX(this.physicalSizeX);
                Length sizeY = FormatTools.getPhysicalSizeY(this.physicalSizeY);
                Length sizeZ = FormatTools.getPhysicalSizeZ(this.physicalSizeZ);
                if (sizeX != null) {
                    store.setPixelsPhysicalSizeX(sizeX, i);
                }
                if (sizeY != null) {
                    store.setPixelsPhysicalSizeY(sizeY, i);
                }
                if (sizeZ != null) {
                    store.setPixelsPhysicalSizeZ(sizeZ, i);
                }
                Timestamp firstStamp = null;
                if (this.timestamps.get(0) != null) {
                    firstStamp = new Timestamp(this.timestamps.get(0));
                }
                for (int plane = 0; plane < this.getImageCount(); ++plane) {
                    String exposure;
                    int[] zct = this.getZCTCoords(plane);
                    int expIndex = zct[1];
                    if (channelKeys.length > 0) {
                        expIndex += ((Integer)channelKeys[0]).intValue();
                    }
                    if ((exposure = this.exposureTime.get(expIndex)) == null && this.exposureTime.size() == 1) {
                        exposure = this.exposureTime.values().iterator().next();
                    }
                    Double exp = 0.0;
                    try {
                        exp = new Double(exposure);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    store.setPlaneExposureTime(new Time(exp, UNITS.SECOND), i, plane);
                    int posIndex = i * this.getImageCount() + plane;
                    if (posIndex < this.timestamps.size() && firstStamp != null) {
                        Timestamp timestamp = new Timestamp(this.timestamps.get(posIndex));
                        long difference = timestamp.asInstant().getMillis() - firstStamp.asInstant().getMillis();
                        double delta = difference;
                        store.setPlaneDeltaT(new Time(delta, UNITS.MILLISECOND), i, plane);
                    }
                    if (this.stageX.get(posIndex) != null) {
                        store.setPlanePositionX(this.stageX.get(posIndex), i, plane);
                    }
                    if (this.stageY.get(posIndex) == null) continue;
                    store.setPlanePositionY(this.stageY.get(posIndex), i, plane);
                }
            }
            for (i = 0; i < this.getSeriesCount(); ++i) {
                for (int roi = 0; roi < this.roiIDs.size(); ++roi) {
                    store.setImageROIRef(this.roiIDs.get(roi), i, roi);
                }
            }
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    protected void storeROIs(MetadataStore store) throws FormatException, IOException {
        int roiIndex = 0;
        int shapeIndex = 0;
        for (Layer layer : this.layers) {
            for (Shape shape : layer.shapes) {
                shapeIndex = 0;
                if (shape.type == FeatureType.UNKNOWN || shape.type == FeatureType.LUT) continue;
                String roiID = MetadataTools.createLSID("ROI", roiIndex);
                this.roiIDs.add(roiID);
                store.setROIID(roiID, roiIndex);
                if (shape.name != null) {
                    store.setROIName(shape.name, roiIndex);
                }
                if (shape.text != null && shape.text.length() == 0) {
                    shape.text = null;
                }
                switch (shape.type) {
                    case POINT: 
                    case POINTS: 
                    case MEAS_POINT: 
                    case MEAS_POINTS: {
                        String shapeID;
                        for (int i = 0; i < shape.points.length / 2; ++i) {
                            shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                            store.setPointID(shapeID, roiIndex, shapeIndex);
                            store.setPointX(shape.points[i * 2], roiIndex, shapeIndex);
                            store.setPointY(shape.points[i * 2 + 1], roiIndex, shapeIndex);
                            if (shape.text != null && i == 0) {
                                store.setPointText(shape.text, roiIndex, shapeIndex);
                            }
                            ++shapeIndex;
                        }
                        break;
                    }
                    case LINE: 
                    case MEAS_LINE: 
                    case MEAS_PROFILE: {
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setLineID(shapeID, roiIndex, shapeIndex);
                        store.setLineX1(shape.points[0], roiIndex, shapeIndex);
                        store.setLineY1(shape.points[1], roiIndex, shapeIndex);
                        store.setLineX2(shape.points[2], roiIndex, shapeIndex);
                        store.setLineY2(shape.points[3], roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setLineText(shape.text, roiIndex, shapeIndex);
                        }
                        ++shapeIndex;
                        break;
                    }
                    case CALIPER: 
                    case MEAS_CALIPER: 
                    case MULTIPLE_CALIPER: 
                    case MEAS_MULTIPLE_CALIPER: 
                    case DISTANCE: 
                    case MEAS_DISTANCE: 
                    case MULTIPLE_DISTANCE: 
                    case MEAS_MULTIPLE_DISTANCE: {
                        String shapeID;
                        int caliperPoints = shape.points.length / 2;
                        if (shape.type == FeatureType.CALIPER || shape.type == FeatureType.MEAS_CALIPER) {
                            caliperPoints -= 2;
                        }
                        for (int i = 0; i < caliperPoints; ++i) {
                            shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                            store.setLineID(shapeID, roiIndex, shapeIndex);
                            store.setLineX1(shape.points[i * 2 + 0], roiIndex, shapeIndex);
                            store.setLineY1(shape.points[i * 2 + 1], roiIndex, shapeIndex);
                            store.setLineX2(shape.points[i * 2 + 2], roiIndex, shapeIndex);
                            store.setLineY2(shape.points[i * 2 + 3], roiIndex, shapeIndex);
                            if (shape.text != null && i == caliperPoints - 2) {
                                store.setLineText(shape.text, roiIndex, shapeIndex);
                            }
                            ++shapeIndex;
                        }
                        break;
                    }
                    case ANGLE3: 
                    case MEAS_ANGLE3: 
                    case ANGLE4: 
                    case MEAS_ANGLE4: {
                        String shapeID;
                        for (int i = 0; i < 4; i += 2) {
                            shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                            store.setLineID(shapeID, roiIndex, shapeIndex);
                            store.setLineX1(shape.points[i * 2 + 0], roiIndex, shapeIndex);
                            store.setLineY1(shape.points[i * 2 + 1], roiIndex, shapeIndex);
                            store.setLineX2(shape.points[i * 2 + 2], roiIndex, shapeIndex);
                            store.setLineY2(shape.points[i * 2 + 3], roiIndex, shapeIndex);
                            if (shape.text != null && i == 0) {
                                store.setLineText(shape.text, roiIndex, shapeIndex);
                            }
                            ++shapeIndex;
                        }
                        break;
                    }
                    case CIRCLE: 
                    case MEAS_CIRCLE: {
                        double xdiff = Math.abs(shape.points[0] - shape.points[2]);
                        double ydiff = Math.abs(shape.points[1] - shape.points[3]);
                        double radius = Math.sqrt(Math.pow(xdiff, 2.0) + Math.pow(ydiff, 2.0));
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setEllipseID(shapeID, roiIndex, shapeIndex);
                        store.setEllipseX(shape.points[0], roiIndex, shapeIndex);
                        store.setEllipseY(shape.points[1], roiIndex, shapeIndex);
                        store.setEllipseRadiusX(radius, roiIndex, shapeIndex);
                        store.setEllipseRadiusY(radius, roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setEllipseText(shape.text, roiIndex, shapeIndex);
                        }
                        shapeID = MetadataTools.createLSID("Shape", roiIndex, ++shapeIndex);
                        store.setLineID(shapeID, roiIndex, shapeIndex);
                        store.setLineX1(shape.points[0], roiIndex, shapeIndex);
                        store.setLineY1(shape.points[1], roiIndex, shapeIndex);
                        store.setLineX2(shape.points[2], roiIndex, shapeIndex);
                        store.setLineY2(shape.points[3], roiIndex, shapeIndex);
                        ++shapeIndex;
                        break;
                    }
                    case SCALE_BAR: {
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setLineID(shapeID, roiIndex, shapeIndex);
                        store.setLineX1(shape.points[0], roiIndex, shapeIndex);
                        store.setLineY1(shape.points[1], roiIndex, shapeIndex);
                        store.setLineX2(shape.points[2], roiIndex, shapeIndex);
                        store.setLineY2(shape.points[3], roiIndex, shapeIndex);
                        store.setLineText(shape.text, roiIndex, shapeIndex);
                        shapeID = MetadataTools.createLSID("Shape", roiIndex, ++shapeIndex);
                        store.setLabelID(shapeID, roiIndex, shapeIndex);
                        store.setLabelX(shape.points[0], roiIndex, shapeIndex);
                        store.setLabelY(shape.points[1], roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setLabelText(shape.text, roiIndex, shapeIndex);
                        }
                        shapeID = MetadataTools.createLSID("Shape", roiIndex, ++shapeIndex);
                        store.setRectangleID(shapeID, roiIndex, shapeIndex);
                        store.setRectangleX(shape.points[0], roiIndex, shapeIndex);
                        store.setRectangleY(shape.points[1], roiIndex, shapeIndex);
                        store.setRectangleWidth(shape.points[2] - shape.points[0], roiIndex, shapeIndex);
                        store.setRectangleHeight(shape.points[3] - shape.points[1], roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setRectangleText(shape.text, roiIndex, shapeIndex);
                        }
                        ++shapeIndex;
                        break;
                    }
                    case POLYLINE_OPEN: 
                    case MEAS_POLYLINE_OPEN: 
                    case POLYLINE_CLOSED: 
                    case MEAS_POLYLINE_CLOSED: 
                    case SPLINE_OPEN: 
                    case MEAS_SPLINE_OPEN: 
                    case SPLINE_CLOSED: 
                    case MEAS_SPLINE_CLOSED: {
                        boolean closed;
                        StringBuilder points = new StringBuilder();
                        for (int p = 0; p < shape.points.length; p += 2) {
                            points.append(shape.points[p + 0]);
                            points.append(",");
                            points.append(shape.points[p + 1]);
                            if (p >= shape.points.length - 2) continue;
                            points.append(" ");
                        }
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        boolean bl = closed = shape.type == FeatureType.POLYLINE_CLOSED || shape.type == FeatureType.SPLINE_CLOSED || shape.type == FeatureType.MEAS_POLYLINE_CLOSED || shape.type == FeatureType.MEAS_SPLINE_CLOSED;
                        if (closed) {
                            store.setPolygonID(shapeID, roiIndex, shapeIndex);
                            store.setPolygonPoints(points.toString(), roiIndex, shapeIndex);
                            if (shape.text != null) {
                                store.setPolygonText(shape.text, roiIndex, shapeIndex);
                            }
                        } else {
                            store.setPolylineID(shapeID, roiIndex, shapeIndex);
                            store.setPolylinePoints(points.toString(), roiIndex, shapeIndex);
                            if (shape.text != null) {
                                store.setPolylineText(shape.text, roiIndex, shapeIndex);
                            }
                        }
                        ++shapeIndex;
                        break;
                    }
                    case ALIGNED_RECTANGLE: 
                    case MEAS_ALIGNED_RECTANGLE: 
                    case TEXT: {
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setLabelID(shapeID, roiIndex, shapeIndex);
                        store.setLabelX(shape.points[0], roiIndex, shapeIndex);
                        store.setLabelY(shape.points[1], roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setLabelText(shape.text, roiIndex, shapeIndex);
                        }
                        shapeID = MetadataTools.createLSID("Shape", roiIndex, ++shapeIndex);
                        store.setRectangleID(shapeID, roiIndex, shapeIndex);
                        store.setRectangleX(shape.points[0], roiIndex, shapeIndex);
                        store.setRectangleY(shape.points[1], roiIndex, shapeIndex);
                        store.setRectangleWidth(shape.points[4] - shape.points[0], roiIndex, shapeIndex);
                        store.setRectangleHeight(shape.points[5] - shape.points[1], roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setRectangleText(shape.text, roiIndex, shapeIndex);
                        }
                        ++shapeIndex;
                        break;
                    }
                    case RECTANGLE: 
                    case MEAS_RECTANGLE: {
                        StringBuilder points = new StringBuilder();
                        for (int p = 0; p < 8; p += 2) {
                            points.append(shape.points[p + 0]);
                            points.append(",");
                            points.append(shape.points[p + 1]);
                            if (p >= 3) continue;
                            points.append(" ");
                        }
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setPolygonID(shapeID, roiIndex, shapeIndex);
                        store.setPolygonPoints(points.toString(), roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setPolygonText(shape.text, roiIndex, shapeIndex);
                        }
                        ++shapeIndex;
                        break;
                    }
                    case ELLIPSE: 
                    case MEAS_ELLIPSE: {
                        String shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                        store.setEllipseID(shapeID, roiIndex, shapeIndex);
                        store.setEllipseX((shape.points[0] + shape.points[4]) / 2.0, roiIndex, shapeIndex);
                        store.setEllipseY((shape.points[1] + shape.points[5]) / 2.0, roiIndex, shapeIndex);
                        store.setEllipseRadiusX((shape.points[4] - shape.points[0]) / 2.0, roiIndex, shapeIndex);
                        store.setEllipseRadiusY((shape.points[5] - shape.points[1]) / 2.0, roiIndex, shapeIndex);
                        if (shape.text != null) {
                            store.setEllipseText(shape.text, roiIndex, shapeIndex);
                        }
                        ++shapeIndex;
                        break;
                    }
                    case LENGTH: 
                    case MEAS_LENGTH: {
                        String shapeID;
                        for (int i = 0; i < 6; i += 2) {
                            shapeID = MetadataTools.createLSID("Shape", roiIndex, shapeIndex);
                            store.setLineID(shapeID, roiIndex, shapeIndex);
                            store.setLineX1(shape.points[i * 2 + 0], roiIndex, shapeIndex);
                            store.setLineY1(shape.points[i * 2 + 1], roiIndex, shapeIndex);
                            store.setLineX2(shape.points[i * 2 + 2], roiIndex, shapeIndex);
                            store.setLineY2(shape.points[i * 2 + 3], roiIndex, shapeIndex);
                            if (shape.text != null && i == 0) {
                                store.setLineText(shape.text, roiIndex, shapeIndex);
                            }
                            ++shapeIndex;
                        }
                        break;
                    }
                }
                ++roiIndex;
            }
        }
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 0 && pixelType != 1 || !this.isIndexed()) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        int channel = this.getZCTCoords(this.lastPlane)[1];
        if (channel >= this.channelColors.length) {
            return null;
        }
        int color = this.channelColors[channel];
        float red = (float)(color & 0xFF) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)((color & 0xFF0000) >> 16) / 255.0f;
        for (int i = 0; i < lut[0].length; ++i) {
            lut[0][i] = (byte)(red * (float)i);
            lut[1][i] = (byte)(green * (float)i);
            lut[2][i] = (byte)(blue * (float)i);
        }
        return lut;
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        int pixelType = this.getPixelType();
        if (pixelType != 2 && pixelType != 3 || !this.isIndexed()) {
            return null;
        }
        short[][] lut = new short[3][65536];
        int channel = this.getZCTCoords(this.lastPlane)[1];
        if (channel >= this.channelColors.length) {
            return null;
        }
        int color = this.channelColors[channel];
        float red = (float)(color & 0xFF) / 255.0f;
        float green = (float)((color & 0xFF00) >> 8) / 255.0f;
        float blue = (float)((color & 0xFF0000) >> 16) / 255.0f;
        for (int i = 0; i < lut[0].length; ++i) {
            lut[0][i] = (short)(red * (float)i);
            lut[1][i] = (short)(green * (float)i);
            lut[2][i] = (short)(blue * (float)i);
        }
        return lut;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.acquisitionDate = null;
            this.exposureTime = null;
            this.timestamps = null;
            this.offsets = null;
            this.coordinates = null;
            this.imageFiles = null;
            this.cIndex = -1;
            this.bpp = 0;
            this.isZlib = false;
            this.isJPEG = false;
            this.tagsToParse = null;
            this.nextChName = 0;
            this.nextExWave = 0;
            this.nextEmWave = 0;
            this.realHeight = 0;
            this.realWidth = 0;
            this.stageX.clear();
            this.stageY.clear();
            this.channelColors = null;
            this.lastPlane = 0;
            this.tiles.clear();
            this.detectorGain.clear();
            this.detectorOffset.clear();
            this.emWavelength.clear();
            this.exWavelength.clear();
            this.channelName.clear();
            this.physicalSizeZ = null;
            this.physicalSizeY = null;
            this.physicalSizeX = null;
            this.rawCount = 0;
            this.colCount = 0;
            this.rowCount = 0;
            this.imageDescription = null;
            this.channelIndices.clear();
            this.zIndices.clear();
            this.timepointIndices.clear();
            this.tileIndices.clear();
            this.timepoint = 0;
            this.roiIDs.clear();
            this.layers.clear();
        }
    }

    void parseMainTags(int image, MetadataStore store, ArrayList<Tag> tags) throws FormatException, IOException {
        int effectiveSizeC = 0;
        try {
            effectiveSizeC = this.getEffectiveSizeC();
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        block10: for (Tag t : tags) {
            String key = t.getKey();
            String value = t.getValue();
            try {
                if (key.equals("Image Channel Index")) {
                    this.cIndex = Integer.parseInt(value);
                    this.addGlobalMetaList(key, this.cIndex);
                    continue;
                }
                if (key.equals("ImageWidth")) {
                    int v = Integer.parseInt(value);
                    if (this.getSizeX() == 0 || v < this.getSizeX()) {
                        ((CoreMetadata)this.core.get((int)0)).sizeX = v;
                    }
                    if (this.realWidth == 0 && v > this.realWidth) {
                        this.realWidth = v;
                    }
                } else if (key.equals("ImageHeight")) {
                    int v = Integer.parseInt(value);
                    if (this.getSizeY() == 0 || v < this.getSizeY()) {
                        ((CoreMetadata)this.core.get((int)0)).sizeY = v;
                    }
                    if (this.realHeight == 0 || v > this.realHeight) {
                        this.realHeight = v;
                    }
                }
                if (this.cIndex != -1) {
                    key = key + " " + this.cIndex;
                }
                if (!key.startsWith("Camera Acquisition Time") && !key.startsWith("ImageRelativeTime")) {
                    String metavalue = value;
                    if (key.endsWith("Date")) {
                        try {
                            metavalue = DateTools.convertDate(this.parseTimestamp(value), 0, "yyyy-MM-dd'T'HH:mm:ss.SSS");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.addGlobalMeta(key, metavalue);
                }
                if (key.startsWith("ImageTile") && !(store instanceof DummyMetadata)) {
                    if (!this.tiles.containsKey(new Integer(value))) {
                        this.tiles.put(Integer.valueOf(value), 1);
                    } else {
                        int v = this.tiles.get(new Integer(value)) + 1;
                        this.tiles.put(new Integer(value), new Integer(v));
                    }
                }
                if (key.startsWith("MultiChannel Color")) {
                    int c;
                    if (this.cIndex >= 0 && this.cIndex < effectiveSizeC) {
                        if (this.channelColors == null || effectiveSizeC > this.channelColors.length) {
                            this.channelColors = new int[effectiveSizeC];
                        }
                        if (this.channelColors[this.cIndex] != 0) continue;
                        this.channelColors[this.cIndex] = Integer.parseInt(value);
                        continue;
                    }
                    if (this.cIndex == effectiveSizeC && this.channelColors != null && this.channelColors[0] == 0) {
                        System.arraycopy(this.channelColors, 1, this.channelColors, 0, this.channelColors.length - 1);
                        this.channelColors[this.cIndex - 1] = Integer.parseInt(value);
                        continue;
                    }
                    if (this.channelColors == null || this.channelColors[0] <= 0 || this.channelColors.length <= 1) continue;
                    for (c = 1; c < this.channelColors.length - 1 && this.channelColors[c] != 0; ++c) {
                    }
                    if (this.channelColors[c] != 0) continue;
                    this.channelColors[c] = Integer.parseInt(value);
                    continue;
                }
                if (key.startsWith("Scale Factor for X") && this.physicalSizeX == null) {
                    this.physicalSizeX = Double.parseDouble(value);
                    continue;
                }
                if (key.startsWith("Scale Factor for Y") && this.physicalSizeY == null) {
                    this.physicalSizeY = Double.parseDouble(value);
                    continue;
                }
                if (key.startsWith("Scale Factor for Z") && this.physicalSizeZ == null) {
                    this.physicalSizeZ = Double.parseDouble(value);
                    continue;
                }
                if (key.startsWith("Number Rows") && this.rowCount == 0) {
                    this.rowCount = BaseZeissReader.parseInt(value);
                    continue;
                }
                if (key.startsWith("Number Columns") && this.colCount == 0) {
                    this.colCount = BaseZeissReader.parseInt(value);
                    continue;
                }
                if (key.startsWith("NumberOfRawImages") && this.rawCount == 0) {
                    this.rawCount = BaseZeissReader.parseInt(value);
                    continue;
                }
                if (key.startsWith("Emission Wavelength")) {
                    Double wave;
                    Length emission;
                    if (this.cIndex == -1 || (emission = FormatTools.getEmissionWavelength(wave = new Double(value))) == null) continue;
                    this.emWavelength.put(this.cIndex, emission);
                    continue;
                }
                if (key.startsWith("Excitation Wavelength")) {
                    Double wave;
                    Length excitation;
                    if (this.cIndex == -1 || (excitation = FormatTools.getExcitationWavelength(wave = new Double(Double.parseDouble(value)))) == null) continue;
                    this.exWavelength.put(this.cIndex, excitation);
                    continue;
                }
                if (key.startsWith("Channel Name")) {
                    if (this.cIndex == -1) continue;
                    this.channelName.put(this.cIndex, value);
                    continue;
                }
                if (key.startsWith("Exposure Time [ms]")) {
                    if (this.exposureTime.get(new Integer(this.cIndex)) != null) continue;
                    double exp = Double.parseDouble(value) / 1000.0;
                    this.exposureTime.put(new Integer(this.cIndex), String.valueOf(exp));
                    continue;
                }
                if (key.startsWith("User Name")) {
                    String[] username = value.split(" ");
                    if (username.length < 2) continue;
                    String id = MetadataTools.createLSID("Experimenter", 0);
                    store.setExperimenterID(id, 0);
                    store.setExperimenterFirstName(username[0], 0);
                    store.setExperimenterLastName(username[username.length - 1], 0);
                    continue;
                }
                if (key.equals("User company")) {
                    String id = MetadataTools.createLSID("Experimenter", 0);
                    store.setExperimenterID(id, 0);
                    store.setExperimenterInstitution(value, 0);
                    continue;
                }
                if (key.startsWith("Objective Magnification")) {
                    Double magnification = Double.parseDouble(value);
                    store.setObjectiveNominalMagnification(magnification, 0, 0);
                    continue;
                }
                if (key.startsWith("Objective ID")) {
                    store.setObjectiveID("Objective:" + value, 0, 0);
                    store.setObjectiveCorrection(MetadataTools.getCorrection("Other"), 0, 0);
                    store.setObjectiveImmersion(MetadataTools.getImmersion("Other"), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective N.A.")) {
                    store.setObjectiveLensNA(new Double(value), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective Name")) {
                    String[] tokens = value.split(" ");
                    for (int q = 0; q < tokens.length; ++q) {
                        int slash = tokens[q].indexOf(47);
                        if (slash == -1 || slash - q <= 0) continue;
                        Double mag = Double.parseDouble(tokens[q].substring(0, slash - q));
                        String na = tokens[q].substring(slash + 1);
                        store.setObjectiveNominalMagnification(mag, 0, 0);
                        store.setObjectiveLensNA(new Double(na), 0, 0);
                        store.setObjectiveCorrection(MetadataTools.getCorrection(tokens[q - 1]), 0, 0);
                        continue block10;
                    }
                    continue;
                }
                if (key.startsWith("Objective Working Distance")) {
                    store.setObjectiveWorkingDistance(new Length(new Double(value), UNITS.MICROMETER), 0, 0);
                    continue;
                }
                if (key.startsWith("Objective Immersion Type")) {
                    String immersion = "Other";
                    switch (Integer.parseInt(value)) {
                        case 2: {
                            immersion = "Oil";
                            break;
                        }
                        case 3: {
                            immersion = "Water";
                        }
                    }
                    store.setObjectiveImmersion(MetadataTools.getImmersion(immersion), 0, 0);
                    continue;
                }
                if (key.startsWith("Stage Position X")) {
                    Double number = Double.valueOf(value);
                    this.stageX.put(image, new Length(number, UNITS.REFERENCEFRAME));
                    this.addGlobalMetaList("X position for position", value);
                    continue;
                }
                if (key.startsWith("Stage Position Y")) {
                    Double number = Double.valueOf(value);
                    this.stageY.put(image, new Length(number, UNITS.REFERENCEFRAME));
                    this.addGlobalMetaList("Y position for position", value);
                    continue;
                }
                if (key.startsWith("Orca Analog Gain")) {
                    this.detectorGain.put(this.cIndex, new Double(value));
                    continue;
                }
                if (key.startsWith("Orca Analog Offset")) {
                    this.detectorOffset.put(this.cIndex, new Double(value));
                    continue;
                }
                if (key.startsWith("Comments")) {
                    this.imageDescription = value;
                    continue;
                }
                if (key.startsWith("Acquisition Date")) {
                    this.acquisitionDate = new Timestamp(DateTools.convertDate(this.parseTimestamp(value), 0, "yyyy-MM-dd'T'HH:mm:ss.SSS"));
                    continue;
                }
                if (image >= 0 && key.startsWith("Camera Acquisition Time")) {
                    String date = DateTools.convertDate(this.parseTimestamp(value), 0, "yyyy-MM-dd'T'HH:mm:ss.SSS");
                    this.addSeriesMetaList(key, date);
                    if (this.timepoint != 0) {
                        this.timestamps.put(this.timepoint - 1, date);
                    } else {
                        this.timestamps.put(this.timepoint, date);
                    }
                    ++this.timepoint;
                    continue;
                }
                if (image < 0 || !key.startsWith("ImageRelativeTime")) continue;
                Time time = new Time(Double.parseDouble(value), UNITS.DAY);
                String timestr = time.value().toString() + " " + time.unit().getSymbol();
                this.addSeriesMetaList(key, timestr);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected static int parseInt(String number) {
        return BaseZeissReader.parseInt(number, 0);
    }

    protected static int parseInt(String number, int defaultnum) {
        if (number != null && number.trim().length() > 0) {
            return Integer.parseInt(number);
        }
        return defaultnum;
    }

    private long parseTimestamp(String s2) {
        try {
            double dstamp = Double.parseDouble(s2);
            DateTime epoch = new DateTime(1900, 1, 1, 0, 0, DateTimeZone.UTC);
            long millisInDay = 86400000L;
            int days = (int)Math.floor(dstamp);
            int millis = (int)((dstamp - (double)days) * (double)millisInDay + 0.5);
            if (--days > 60) {
                --days;
            }
            DateTime dtstamp = epoch.plusDays(days);
            dtstamp = dtstamp.plusMillis(millis);
            return dtstamp.getMillis();
        }
        catch (NumberFormatException e) {
            String us_format = "MM/dd/yyyy hh:mm:ss aa";
            return DateTools.getTime(s2, us_format, null);
        }
    }

    protected static int parseColor(byte r, byte g2, byte b) {
        return (r & 0xFF) << 24 | (g2 & 0xFF) << 16 | (b & 0xFF) << 8;
    }

    class Layer {
        int key;
        String flags;
        public String name;
        public ArrayList<Shape> shapes = new ArrayList();

        Layer() {
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder("LAYER: ");
            s2.append(this.key);
            if (this.name != null) {
                s2.append(" (");
                s2.append(this.name);
                s2.append(")");
            }
            s2.append("\n");
            for (Shape shape : this.shapes) {
                s2.append(shape);
            }
            return s2.toString();
        }
    }

    class Shape {
        int id = 0;
        FeatureType type = FeatureType.UNKNOWN;
        int unknown1;
        int unknown2;
        int unknown3;
        int x1 = 0;
        int y1 = 0;
        int x2 = 0;
        int y2 = 0;
        int width = 0;
        int height = 0;
        int unknown4;
        int unknown5;
        int unknown6;
        int unknown7;
        byte fb = (byte)-1;
        int fillColour = BaseZeissReader.parseColor(this.fb, this.fb, this.fb);
        int textColour = BaseZeissReader.parseColor(this.fb, this.fb, this.fb);
        int drawColour = BaseZeissReader.parseColor(this.fb, this.fb, this.fb);
        int lineWidth = 1;
        DrawStyle drawStyle = DrawStyle.NO_LINE;
        FillStyle fillStyle = FillStyle.NONE;
        int unknown8;
        int unknown10;
        int unknown11;
        int unknown12;
        int unknown13;
        int unknown14;
        int unknown15;
        int unknown16;
        int unknown17;
        int unknown18;
        int unknown19;
        LineEndStyle lineEndStyle = LineEndStyle.NONE;
        PointStyle pointStyle = PointStyle.CROSS;
        int lineEndSize = 10;
        LineEndPositions lineEndPositions = LineEndPositions.NONE;
        String fontName;
        int fontSize = 10;
        int fontWeight = 300;
        boolean bold = false;
        boolean italic = false;
        boolean underline = false;
        boolean strikeout = false;
        Charset charset = Charset.ANSI;
        TextAlignment textAlignment = TextAlignment.LEFT;
        String name;
        String text;
        Tag tagID;
        boolean displayTag;
        int handleSize;
        int pointCount = 0;
        double[] points;

        Shape() {
        }

        public String toString() {
            StringBuilder s2 = new StringBuilder("  SHAPE: ");
            s2.append(this.id);
            this.appendValue(s2, "    Type=", (Object)this.type);
            this.appendHexValue(s2, "    Unknown1=", this.unknown1);
            this.appendHexValue(s2, " Unknown2=", this.unknown2);
            this.appendHexValue(s2, " Unknown3=", this.unknown3);
            s2.append("\n    Bbox=");
            s2.append(this.x1);
            s2.append(",");
            s2.append(this.y1);
            s2.append("  ");
            s2.append(this.x2);
            s2.append(",");
            s2.append(this.y2);
            this.appendHexValue(s2, "\n    Unknown4=", this.unknown4);
            this.appendHexValue(s2, " Unknown5=", this.unknown5);
            this.appendHexValue(s2, " Unknown6=", this.unknown6);
            this.appendHexValue(s2, " Unknown7=", this.unknown7);
            this.appendHexValue(s2, "\n    Unknown8=", this.unknown8);
            this.appendHexValue(s2, "\n    Unknown10=", this.unknown10);
            this.appendHexValue(s2, " Unknown11=", this.unknown11);
            this.appendHexValue(s2, " Unknown12=", this.unknown12);
            this.appendHexValue(s2, "\n    Unknown13=", this.unknown13);
            this.appendHexValue(s2, " Unknown14=", this.unknown14);
            this.appendHexValue(s2, " Unknown15=", this.unknown15);
            this.appendHexValue(s2, " Unknown16=", this.unknown16);
            this.appendHexValue(s2, "\n    Unknown17=", this.unknown17);
            this.appendHexValue(s2, " Unknown18=", this.unknown18);
            this.appendHexValue(s2, " Unknown19=", this.unknown19);
            this.appendHexValue(s2, "\n    fillColour=", this.fillColour);
            this.appendHexValue(s2, " textColour=", this.textColour);
            this.appendHexValue(s2, " drawColour=", this.drawColour);
            this.appendValue(s2, "\n    drawStyle=", (Object)this.drawStyle);
            this.appendValue(s2, " fillStyle=", (Object)this.fillStyle);
            this.appendValue(s2, " lineEndStyle=", (Object)this.lineEndStyle);
            this.appendValue(s2, " lineEndSize=", this.lineEndSize);
            this.appendValue(s2, " lineEndPositions=", (Object)this.lineEndPositions);
            this.appendValue(s2, "\ndisplayTag=", this.displayTag);
            this.appendValue(s2, "\n  fontName=", this.fontName);
            this.appendValue(s2, " size=", this.fontSize);
            this.appendValue(s2, " weight=", this.fontWeight);
            this.appendValue(s2, " bold=", this.bold);
            this.appendValue(s2, " italic=", this.italic);
            this.appendValue(s2, " underline=", this.underline);
            this.appendValue(s2, " strikeout=", this.strikeout);
            this.appendValue(s2, " alignment=", (Object)this.textAlignment);
            this.appendValue(s2, " charset=", (Object)this.charset);
            this.appendValue(s2, "\n  name: ", this.name);
            this.appendValue(s2, "\n  text: ", this.text);
            this.appendValue(s2, "\n  tagID: ", this.tagID.getKey());
            this.appendValue(s2, "\n  handleSize:", this.handleSize);
            this.appendValue(s2, "\n  pointCount:", this.pointCount);
            s2.append("\n    ");
            for (double point : this.points) {
                s2.append(point);
                s2.append(", ");
            }
            s2.append("\n");
            return s2.toString();
        }

        private void appendHexValue(StringBuilder s2, String key, int i) {
            this.appendValue(s2, key, this.formatHex(i));
        }

        private void appendValue(StringBuilder s2, String key, Object value) {
            s2.append(key);
            s2.append(value);
        }

        private String formatHex(int i) {
            return Long.toHexString((long)i & 0xFFFFFFFFL);
        }
    }

    static enum Charset {
        ANSI(0, "windows-1252"),
        MAC_CHARSET(77, "MacRoman"),
        SHIFTJIS_CHARSET(128, "x-MS932_0213"),
        HANGUL_CHARSET(129, "x-windows-949"),
        GB2313_CHARSET(134, "x-mswin-936"),
        CHINESEBIG5_CHARSET(136, "x-windows-950"),
        GREEK_CHARSET(161, "windows-1253"),
        TURKISH_CHARSET(162, "windows-1254"),
        VIETNAMESE_CHARSET(163, "CP-1258"),
        HEBREW_CHARSET(177, "windows-1255"),
        ARABIC_CHARSET(178, "windows-1256"),
        BALTIC_CHARSET(186, "windows-1257"),
        RUSSIAN_CHARSET(204, "windows-1251"),
        THAI_CHARSET(222, "x-windows-874"),
        EASTEUROPE_CHARSET(238, "windows-1250");

        private static final Map<Integer, Charset> lookup;
        private int value;
        String name;

        private Charset(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public int getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public static Charset get(int value) {
            Charset ret = lookup.get(value);
            if (ret == null) {
                ret = ANSI;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, Charset>();
            for (Charset f : EnumSet.allOf(Charset.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum TextAlignment {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        NONE(3);

        private static final Map<Integer, TextAlignment> lookup;
        private int value;

        private TextAlignment(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static TextAlignment get(int value) {
            TextAlignment ret = lookup.get(value);
            if (ret == null) {
                ret = LEFT;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, TextAlignment>();
            for (TextAlignment f : EnumSet.allOf(TextAlignment.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum LineEndPositions {
        NONE(0),
        LEFT(1),
        RIGHT(2),
        BOTH(3);

        private static final Map<Integer, LineEndPositions> lookup;
        private int value;

        private LineEndPositions(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LineEndPositions get(int value) {
            LineEndPositions ret = lookup.get(value);
            if (ret == null) {
                ret = NONE;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, LineEndPositions>();
            for (LineEndPositions f : EnumSet.allOf(LineEndPositions.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum PointStyle {
        NONE(0),
        PLUS(2),
        CROSS(7),
        SQUARE(1),
        DIAMOND(3),
        ASTERISK(4),
        ARROW(5),
        BAR(6),
        FILLED_ARROW(8),
        CROSSHAIR(9);

        private static final Map<Integer, PointStyle> lookup;
        private int value;

        private PointStyle(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static PointStyle get(int value) {
            PointStyle ret = lookup.get(value);
            if (ret == null) {
                ret = CROSS;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, PointStyle>();
            for (PointStyle f : EnumSet.allOf(PointStyle.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum LineEndStyle {
        NONE(1),
        ARROWS(5),
        END_TICKS(2),
        FILLED_ARROWS(3);

        private static final Map<Integer, LineEndStyle> lookup;
        private int value;

        private LineEndStyle(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static LineEndStyle get(int value) {
            LineEndStyle ret = lookup.get(value);
            if (ret == null) {
                ret = ARROWS;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, LineEndStyle>();
            for (LineEndStyle f : EnumSet.allOf(LineEndStyle.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum FillStyle {
        NONE(1),
        SOLID(0),
        HORIZONTAL_LINE(2),
        VERTICAL_LINE(3),
        DOWNWARDS_DIAGONAL(4),
        UPWARDS_DIAGONAL(5),
        CROSS(6),
        DIAGONAL_CROSS(7);

        private static final Map<Integer, FillStyle> lookup;
        private int value;

        private FillStyle(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static FillStyle get(int value) {
            FillStyle ret = lookup.get(value);
            if (ret == null) {
                ret = SOLID;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, FillStyle>();
            for (FillStyle f : EnumSet.allOf(FillStyle.class)) {
                lookup.put(f.getValue(), f);
            }
        }
    }

    static enum DrawStyle {
        NO_LINE(0),
        SOLID(1),
        DOT(3),
        DASH(2),
        DASH_DOT(4),
        DASH_DOT_DOT(5);

        private static final Map<Integer, DrawStyle> lookup;
        private int value;

        private DrawStyle(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DrawStyle get(int value) {
            DrawStyle ret = lookup.get(value);
            if (ret == null) {
                ret = SOLID;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, DrawStyle>();
            for (DrawStyle d : EnumSet.allOf(DrawStyle.class)) {
                lookup.put(d.getValue(), d);
            }
        }
    }

    static enum FeatureType {
        UNKNOWN(-1, 0),
        POINT(0, 1),
        POINTS(1, 0),
        LINE(2, 2),
        CALIPER(3, 6),
        DISTANCE(4, 6),
        MULTIPLE_CALIPER(5, -4),
        MULTIPLE_DISTANCE(5, -4),
        ANGLE3(7, 4),
        ANGLE4(8, 4),
        CIRCLE(9, 2),
        SCALE_BAR(10, 2),
        POLYLINE_OPEN(12, -2),
        ALIGNED_RECTANGLE(13, 5),
        RECTANGLE(14, 5),
        ELLIPSE(15, 5),
        POLYLINE_CLOSED(16, -2),
        TEXT(17, 5),
        LENGTH(18, 6),
        SPLINE_OPEN(19, -3),
        SPLINE_CLOSED(20, -3),
        LUT(21, 5),
        MEAS_PROFILE(28, 2),
        MEAS_POINT(32, 1),
        MEAS_POINTS(33, 0),
        MEAS_LINE(34, 2),
        MEAS_CALIPER(35, 6),
        MEAS_DISTANCE(36, 6),
        MEAS_MULTIPLE_CALIPER(37, -4),
        MEAS_MULTIPLE_DISTANCE(38, -4),
        MEAS_ANGLE3(39, 4),
        MEAS_ANGLE4(40, 4),
        MEAS_CIRCLE(41, 2),
        MEAS_POLYLINE_OPEN(42, -2),
        MEAS_ALIGNED_RECTANGLE(43, 5),
        MEAS_RECTANGLE(44, 5),
        MEAS_ELLIPSE(45, 5),
        MEAS_POLYLINE_CLOSED(46, -2),
        MEAS_LENGTH(48, 6),
        MEAS_SPLINE_OPEN(49, -3),
        MEAS_SPLINE_CLOSED(50, -3);

        private static final Map<Integer, FeatureType> lookup;
        private int value;
        private int points;

        private FeatureType(int value, int points) {
            this.value = value;
            this.points = points;
        }

        public int getValue() {
            return this.value;
        }

        public int getPoints() {
            return this.points;
        }

        boolean checkPoints(int points) {
            boolean status = false;
            if (this.points == 0) {
                status = true;
            } else if (this.points > 0 && points == this.points) {
                status = true;
            } else if (this.points < 0 && points >= -this.points) {
                status = true;
            }
            return status;
        }

        public static FeatureType get(int value) {
            FeatureType ret = lookup.get(value);
            if (ret == null) {
                ret = UNKNOWN;
            }
            return ret;
        }

        static {
            lookup = new HashMap<Integer, FeatureType>();
            for (FeatureType d : EnumSet.allOf(FeatureType.class)) {
                lookup.put(d.getValue(), d);
            }
            lookup.put(284, MEAS_PROFILE);
        }
    }

    public class Tag {
        private int index;
        private int keyid;
        private String value;
        private int category;
        private Context context;

        public Tag(int index, Context context) {
            this.index = index;
            this.keyid = -1;
            this.value = null;
            this.category = -1;
            this.context = context;
        }

        public Tag(int keyid, String value, Context context) {
            this.index = 0;
            this.keyid = keyid;
            this.value = value;
            this.category = 0;
            this.context = context;
        }

        public void setKey(int keyid) {
            this.keyid = keyid;
        }

        public String getKey() {
            return this.getKey(this.keyid);
        }

        public int getKeyID() {
            return this.keyid;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public void setCategory(int category) {
            this.category = category;
        }

        public int getCategory() {
            return this.category;
        }

        public boolean valid() {
            return this.keyid != -1 && this.value != null && this.category != -1;
        }

        public String toString() {
            String s2 = new String();
            s2 = s2 + this.keyid + " (" + this.getKey() + ") = " + this.getValue();
            switch (this.context) {
                case MAIN: {
                    s2 = s2 + " [main]";
                    break;
                }
                case SCALING: {
                    s2 = s2 + " [scaling]";
                    break;
                }
                case PLANE: {
                    s2 = s2 + " [plane]";
                    break;
                }
                default: {
                    s2 = s2 + " [unknown]";
                }
            }
            return s2;
        }

        protected String getKey(int tagID) {
            switch (tagID) {
                case -1: {
                    return "INVALID";
                }
                case 222: {
                    return "Compression";
                }
                case 257: {
                    return "DateMappingTable";
                }
                case 258: {
                    return "BlackValue";
                }
                case 259: {
                    return "WhiteValue";
                }
                case 260: {
                    return "ImageDataMappingAutoRange";
                }
                case 261: {
                    return "Thumbnail";
                }
                case 262: {
                    return "GammaValue";
                }
                case 264: {
                    return "ImageOverExposure";
                }
                case 265: {
                    return "ImageRelativeTime1";
                }
                case 266: {
                    return "ImageRelativeTime2";
                }
                case 267: {
                    return "ImageRelativeTime3";
                }
                case 268: {
                    return "ImageRelativeTime4";
                }
                case 300: {
                    return "ImageRelativeTime";
                }
                case 301: {
                    return "ImageBaseTime1";
                }
                case 302: {
                    return "ImageBaseTime2";
                }
                case 303: {
                    return "ImageBaseTime3";
                }
                case 305: {
                    return "ImageBaseTime4";
                }
                case 333: {
                    return "RelFocusPosition1";
                }
                case 334: {
                    return "RelFocusPosition2";
                }
                case 513: {
                    return "ObjectType";
                }
                case 515: {
                    return "ImageWidth";
                }
                case 516: {
                    return "ImageHeight";
                }
                case 517: {
                    return "Number Raw Count";
                }
                case 518: {
                    return "PixelType";
                }
                case 519: {
                    return "NumberOfRawImages";
                }
                case 520: {
                    return "ImageSize";
                }
                case 521: {
                    return "CompressionFactorForSave";
                }
                case 522: {
                    return "DocumentSaveFlags";
                }
                case 523: {
                    return "Acquisition pause annotation";
                }
                case 530: {
                    return "Document Subtype";
                }
                case 531: {
                    return "Acquisition Bit Depth";
                }
                case 532: {
                    return "Image Memory Usage (RAM)";
                }
                case 534: {
                    return "Z-Stack single representative";
                }
                case 769: {
                    return "Scale Factor for X";
                }
                case 770: {
                    return "Scale Unit for X";
                }
                case 771: {
                    return "Scale Width";
                }
                case 772: {
                    return "Scale Factor for Y";
                }
                case 773: {
                    return "Scale Unit for Y";
                }
                case 774: {
                    return "Scale Height";
                }
                case 775: {
                    return "Scale Factor for Z";
                }
                case 776: {
                    return "Scale Unit for Z";
                }
                case 777: {
                    return "Scale Depth";
                }
                case 778: {
                    return "Scaling Parent";
                }
                case 1001: {
                    return "Date";
                }
                case 1002: {
                    return "Code";
                }
                case 1003: {
                    return "Source";
                }
                case 1004: {
                    return "Message";
                }
                case 1025: {
                    return "Camera Acquisition Time";
                }
                case 1026: {
                    return "8-bit Acquisition";
                }
                case 1027: {
                    return "Camera Bit Depth";
                }
                case 1029: {
                    return "MonoReferenceLow";
                }
                case 1030: {
                    return "MonoReferenceHigh";
                }
                case 1031: {
                    return "RedReferenceLow";
                }
                case 1032: {
                    return "RedReferenceHigh";
                }
                case 1033: {
                    return "GreenReferenceLow";
                }
                case 1034: {
                    return "GreenReferenceHigh";
                }
                case 1035: {
                    return "BlueReferenceLow";
                }
                case 1036: {
                    return "BlueReferenceHigh";
                }
                case 1041: {
                    return "FrameGrabber Name";
                }
                case 1042: {
                    return "Camera";
                }
                case 1044: {
                    return "CameraTriggerSignalType";
                }
                case 1045: {
                    return "CameraTriggerEnable";
                }
                case 1046: {
                    return "GrabberTimeout";
                }
                case 1047: {
                    return "Camera Acquisition Time";
                }
                case 1281: {
                    return "MultiChannelEnabled";
                }
                case 1282: {
                    return "MultiChannel Color";
                }
                case 1283: {
                    return "MultiChannel Weight";
                }
                case 1284: {
                    return "Channel Name";
                }
                case 1536: {
                    return "DocumentInformationGroup";
                }
                case 1537: {
                    if (this.context == Context.SCALING) {
                        return "Scale Unit for Z";
                    }
                    return "Title";
                }
                case 1538: {
                    return "Author";
                }
                case 1539: {
                    return "Keywords";
                }
                case 1540: {
                    return "Comments";
                }
                case 1541: {
                    return "SampleID";
                }
                case 1542: {
                    return "Subject";
                }
                case 1543: {
                    return "RevisionNumber";
                }
                case 1544: {
                    return "Save Folder";
                }
                case 1545: {
                    return "FileLink";
                }
                case 1546: {
                    return "Document Type";
                }
                case 1547: {
                    return "Storage Media";
                }
                case 1548: {
                    return "File ID";
                }
                case 1549: {
                    return "Reference";
                }
                case 1550: {
                    return "File Date";
                }
                case 1551: {
                    return "File Size";
                }
                case 1553: {
                    return "Filename";
                }
                case 1792: {
                    return "ProjectGroup";
                }
                case 1793: {
                    return "Acquisition Date";
                }
                case 1794: {
                    return "Last modified by";
                }
                case 1795: {
                    return "User Company";
                }
                case 1796: {
                    return "User Company Logo";
                }
                case 1797: {
                    return "Image";
                }
                case 1800: {
                    return "User ID";
                }
                case 1801: {
                    return "User Name";
                }
                case 1802: {
                    return "User City";
                }
                case 1803: {
                    return "User Address";
                }
                case 1804: {
                    return "User Country";
                }
                case 1805: {
                    return "User Phone";
                }
                case 1806: {
                    return "User Fax";
                }
                case 2049: {
                    return "Objective Name";
                }
                case 2050: {
                    return "Optovar";
                }
                case 2051: {
                    return "Reflector";
                }
                case 2052: {
                    return "Condenser Contrast";
                }
                case 2053: {
                    return "Transmitted Light Filter 1";
                }
                case 2054: {
                    return "Transmitted Light Filter 2";
                }
                case 2055: {
                    return "Reflected Light Shutter";
                }
                case 2056: {
                    return "Condenser Front Lens";
                }
                case 2057: {
                    return "Excitation Filter Name";
                }
                case 2060: {
                    return "Transmitted Light Fieldstop Aperture";
                }
                case 2061: {
                    return "Reflected Light Aperture";
                }
                case 2062: {
                    return "Condenser N.A.";
                }
                case 2063: {
                    return "Light Path";
                }
                case 2064: {
                    return "HalogenLampOn";
                }
                case 2065: {
                    return "Halogen Lamp Mode";
                }
                case 2066: {
                    return "Halogen Lamp Voltage";
                }
                case 2068: {
                    return "Fluorescence Lamp Level";
                }
                case 2069: {
                    return "Fluorescence Lamp Intensity";
                }
                case 2070: {
                    return "LightManagerEnabled";
                }
                case 2071: {
                    return "tag_ID_2071";
                }
                case 2072: {
                    return "Focus Position";
                }
                case 2073: {
                    return "Stage Position X";
                }
                case 2074: {
                    return "Stage Position Y";
                }
                case 2075: {
                    return "Microscope Name";
                }
                case 2076: {
                    return "Objective Magnification";
                }
                case 2077: {
                    return "Objective N.A.";
                }
                case 2078: {
                    return "MicroscopeIllumination";
                }
                case 2079: {
                    return "External Shutter 1";
                }
                case 2080: {
                    return "External Shutter 2";
                }
                case 2081: {
                    return "External Shutter 3";
                }
                case 2082: {
                    return "External Filter Wheel 1 Name";
                }
                case 2083: {
                    return "External Filter Wheel 2 Name";
                }
                case 2084: {
                    return "Parfocal Correction";
                }
                case 2086: {
                    return "External Shutter 4";
                }
                case 2087: {
                    return "External Shutter 5";
                }
                case 2088: {
                    return "External Shutter 6";
                }
                case 2089: {
                    return "External Filter Wheel 3 Name";
                }
                case 2090: {
                    return "External Filter Wheel 4 Name";
                }
                case 2103: {
                    return "Objective Turret Position";
                }
                case 2104: {
                    return "Objective Contrast Method";
                }
                case 2105: {
                    return "Objective Immersion Type";
                }
                case 2107: {
                    return "Reflector Position";
                }
                case 2109: {
                    return "Transmitted Light Filter 1 Position";
                }
                case 2110: {
                    return "Transmitted Light Filter 2 Position";
                }
                case 2112: {
                    return "Excitation Filter Position";
                }
                case 2113: {
                    return "Lamp Mirror Position";
                }
                case 2114: {
                    return "External Filter Wheel 1 Position";
                }
                case 2115: {
                    return "External Filter Wheel 2 Position";
                }
                case 2116: {
                    return "External Filter Wheel 3 Position";
                }
                case 2117: {
                    return "External Filter Wheel 4 Position";
                }
                case 2118: {
                    return "Lightmanager Mode";
                }
                case 2119: {
                    return "Halogen Lamp Calibration";
                }
                case 2120: {
                    return "CondenserNAGoSpeed";
                }
                case 2121: {
                    return "TransmittedLightFieldstopGoSpeed";
                }
                case 2122: {
                    return "OptovarGoSpeed";
                }
                case 2123: {
                    return "Focus calibrated";
                }
                case 2124: {
                    return "FocusBasicPosition";
                }
                case 2125: {
                    return "FocusPower";
                }
                case 2126: {
                    return "FocusBacklash";
                }
                case 2127: {
                    return "FocusMeasurementOrigin";
                }
                case 2128: {
                    return "FocusMeasurementDistance";
                }
                case 2129: {
                    return "FocusSpeed";
                }
                case 2130: {
                    return "FocusGoSpeed";
                }
                case 2131: {
                    return "FocusDistance";
                }
                case 2132: {
                    return "FocusInitPosition";
                }
                case 2133: {
                    return "Stage calibrated";
                }
                case 2134: {
                    return "StagePower";
                }
                case 2135: {
                    return "StageXBacklash";
                }
                case 2136: {
                    return "StageYBacklash";
                }
                case 2137: {
                    return "StageSpeedX";
                }
                case 2138: {
                    return "StageSpeedY";
                }
                case 2139: {
                    return "StageSpeed";
                }
                case 2140: {
                    return "StageGoSpeedX";
                }
                case 2141: {
                    return "StageGoSpeedY";
                }
                case 2142: {
                    return "StageStepDistanceX";
                }
                case 2143: {
                    return "StageStepDistanceY";
                }
                case 2144: {
                    return "StageInitialisationPositionX";
                }
                case 2145: {
                    return "StageInitialisationPositionY";
                }
                case 2146: {
                    return "MicroscopeMagnification";
                }
                case 2147: {
                    return "ReflectorMagnification";
                }
                case 2148: {
                    return "LampMirrorPosition";
                }
                case 2149: {
                    return "FocusDepth";
                }
                case 2150: {
                    return "MicroscopeType";
                }
                case 2151: {
                    return "Objective Working Distance";
                }
                case 2152: {
                    return "ReflectedLightApertureGoSpeed";
                }
                case 2153: {
                    return "External Shutter";
                }
                case 2154: {
                    return "ObjectiveImmersionStop";
                }
                case 2155: {
                    return "Focus Start Speed";
                }
                case 2156: {
                    return "Focus Acceleration";
                }
                case 2157: {
                    return "ReflectedLightFieldstop";
                }
                case 2158: {
                    return "ReflectedLightFieldstopGoSpeed";
                }
                case 2159: {
                    return "ReflectedLightFilter 1";
                }
                case 2160: {
                    return "ReflectedLightFilter 2";
                }
                case 2161: {
                    return "ReflectedLightFilter1Position";
                }
                case 2162: {
                    return "ReflectedLightFilter2Position";
                }
                case 2163: {
                    return "TransmittedLightAttenuator";
                }
                case 2164: {
                    return "ReflectedLightAttenuator";
                }
                case 2165: {
                    return "Transmitted Light Shutter";
                }
                case 2166: {
                    return "TransmittedLightAttenuatorGoSpeed";
                }
                case 2167: {
                    return "ReflectedLightAttenuatorGoSpeed";
                }
                case 2176: {
                    return "TransmittedLightVirtualFilterPosition";
                }
                case 2177: {
                    return "TransmittedLightVirtualFilter";
                }
                case 2178: {
                    return "ReflectedLightVirtualFilterPosition";
                }
                case 2179: {
                    return "ReflectedLightVirtualFilter";
                }
                case 2180: {
                    return "ReflectedLightHalogenLampMode";
                }
                case 2181: {
                    return "ReflectedLightHalogenLampVoltage";
                }
                case 2182: {
                    return "ReflectedLightHalogenLampColorTemperature";
                }
                case 2183: {
                    return "ContrastManagerMode";
                }
                case 2184: {
                    return "Dazzle Protection Active";
                }
                case 2195: {
                    return "Zoom";
                }
                case 2196: {
                    return "ZoomGoSpeed";
                }
                case 2197: {
                    return "LightZoom";
                }
                case 2198: {
                    return "LightZoomGoSpeed";
                }
                case 2199: {
                    return "LightZoomCoupled";
                }
                case 2200: {
                    return "TransmittedLightHalogenLampMode";
                }
                case 2201: {
                    return "TransmittedLightHalogenLampVoltage";
                }
                case 2202: {
                    return "TransmittedLightHalogenLampColorTemperature";
                }
                case 2203: {
                    return "Reflected Coldlight Mode";
                }
                case 2204: {
                    return "Reflected Coldlight Intensity";
                }
                case 2205: {
                    return "Reflected Coldlight Color Temperature";
                }
                case 2206: {
                    return "Transmitted Coldlight Mode";
                }
                case 2207: {
                    return "Transmitted Coldlight Intensity";
                }
                case 2208: {
                    return "Transmitted Coldlight Color Temperature";
                }
                case 2209: {
                    return "Infinityspace Portchanger Position";
                }
                case 2210: {
                    return "Beamsplitter Infinity Space";
                }
                case 2211: {
                    return "TwoTv VisCamChanger Position";
                }
                case 2212: {
                    return "Beamsplitter Ocular";
                }
                case 2213: {
                    return "TwoTv CamerasChanger Position";
                }
                case 2214: {
                    return "Beamsplitter Cameras";
                }
                case 2215: {
                    return "Ocular Shutter";
                }
                case 2216: {
                    return "TwoTv CamerasChangerCube";
                }
                case 2217: {
                    return "LightWaveLength";
                }
                case 2218: {
                    return "Ocular Magnification";
                }
                case 2219: {
                    return "Camera Adapter Magnification";
                }
                case 2220: {
                    return "Microscope Port";
                }
                case 2221: {
                    return "Ocular Total Magnification";
                }
                case 2222: {
                    return "Field of View";
                }
                case 2223: {
                    return "Ocular";
                }
                case 2224: {
                    return "CameraAdapter";
                }
                case 2225: {
                    return "StageJoystickEnabled";
                }
                case 2226: {
                    return "ContrastManager Contrast Method";
                }
                case 2229: {
                    return "CamerasChanger Beamsplitter Type";
                }
                case 2235: {
                    return "Rearport Slider Position";
                }
                case 2236: {
                    return "Rearport Source";
                }
                case 2237: {
                    return "Beamsplitter Type Infinity Space";
                }
                case 2238: {
                    return "Fluorescence Attenuator";
                }
                case 2239: {
                    return "Fluorescence Attenuator Position";
                }
                case 2247: {
                    return "tag_ID_2247";
                }
                case 2252: {
                    return "tag_ID_2252";
                }
                case 2253: {
                    return "tag_ID_2253";
                }
                case 2254: {
                    return "tag_ID_2254";
                }
                case 2255: {
                    return "tag_ID_2255";
                }
                case 2256: {
                    return "tag_ID_2256";
                }
                case 2257: {
                    return "tag_ID_2257";
                }
                case 2258: {
                    return "tag_ID_2258";
                }
                case 2259: {
                    return "tag_ID_2259";
                }
                case 2260: {
                    return "tag_ID_2260";
                }
                case 2261: {
                    return "Objective ID";
                }
                case 2262: {
                    return "Reflector ID";
                }
                case 2307: {
                    return "Camera Framestart Left";
                }
                case 2308: {
                    return "Camera Framestart Top";
                }
                case 2309: {
                    return "Camera Frame Width";
                }
                case 2310: {
                    return "Camera Frame Height";
                }
                case 2311: {
                    return "Camera Binning";
                }
                case 2312: {
                    return "CameraFrameFull";
                }
                case 2313: {
                    return "CameraFramePixelDistance";
                }
                case 2318: {
                    return "DataFormatUseScaling";
                }
                case 2319: {
                    return "CameraFrameImageOrientation";
                }
                case 2320: {
                    return "VideoMonochromeSignalType";
                }
                case 2321: {
                    return "VideoColorSignalType";
                }
                case 2322: {
                    return "MeteorChannelInput";
                }
                case 2323: {
                    return "MeteorChannelSync";
                }
                case 2324: {
                    return "WhiteBalanceEnabled";
                }
                case 2325: {
                    return "CameraWhiteBalanceRed";
                }
                case 2326: {
                    return "CameraWhiteBalanceGreen";
                }
                case 2327: {
                    return "CameraWhiteBalanceBlue";
                }
                case 2331: {
                    return "CameraFrameScalingFactor";
                }
                case 2562: {
                    return "Meteor Camera Type";
                }
                case 2564: {
                    return "Exposure Time [ms]";
                }
                case 2568: {
                    return "CameraExposureTimeAutoCalculate";
                }
                case 2569: {
                    return "Meteor Gain Value";
                }
                case 2571: {
                    return "Meteor Gain Automatic";
                }
                case 2572: {
                    return "MeteorAdjustHue";
                }
                case 2573: {
                    return "MeteorAdjustSaturation";
                }
                case 2574: {
                    return "MeteorAdjustRedLow";
                }
                case 2575: {
                    return "MeteorAdjustGreenLow";
                }
                case 2576: {
                    return "Meteor Blue Low";
                }
                case 2577: {
                    return "MeteorAdjustRedHigh";
                }
                case 2578: {
                    return "MeteorAdjustGreenHigh";
                }
                case 2579: {
                    return "MeteorBlue High";
                }
                case 2582: {
                    return "CameraExposureTimeCalculationControl";
                }
                case 2585: {
                    return "AxioCamFadingCorrectionEnable";
                }
                case 2587: {
                    return "CameraLiveImage";
                }
                case 2588: {
                    return "CameraLiveEnabled";
                }
                case 2589: {
                    return "LiveImageSyncObjectName";
                }
                case 2590: {
                    return "CameraLiveSpeed";
                }
                case 2591: {
                    return "CameraImage";
                }
                case 2592: {
                    return "CameraImageWidth";
                }
                case 2593: {
                    return "CameraImageHeight";
                }
                case 2594: {
                    return "CameraImagePixelType";
                }
                case 2595: {
                    return "CameraImageShMemoryName";
                }
                case 2596: {
                    return "CameraLiveImageWidth";
                }
                case 2597: {
                    return "CameraLiveImageHeight";
                }
                case 2598: {
                    return "CameraLiveImagePixelType";
                }
                case 2599: {
                    return "CameraLiveImageShMemoryName";
                }
                case 2600: {
                    return "CameraLiveMaximumSpeed";
                }
                case 2601: {
                    return "CameraLiveBinning";
                }
                case 2602: {
                    return "CameraLiveGainValue";
                }
                case 2603: {
                    return "CameraLiveExposureTimeValue";
                }
                case 2604: {
                    return "CameraLiveScalingFactor";
                }
                case 2817: {
                    return "Image Index U";
                }
                case 2818: {
                    return "Image Index V";
                }
                case 2819: {
                    return "Image Index Z";
                }
                case 2820: {
                    return "Image Channel Index";
                }
                case 2821: {
                    return "Image Index T";
                }
                case 2822: {
                    return "ImageTile Index";
                }
                case 2823: {
                    return "Image acquisition Index";
                }
                case 2824: {
                    return "ImageCount Tiles";
                }
                case 2825: {
                    return "ImageCount A";
                }
                case 2827: {
                    return "Image Index S";
                }
                case 2828: {
                    return "Image Index Raw";
                }
                case 2832: {
                    return "Image Count Z";
                }
                case 2833: {
                    return "Image Count C";
                }
                case 2834: {
                    return "Image Count T";
                }
                case 2838: {
                    return "Number Rows";
                }
                case 2839: {
                    return "Number Columns";
                }
                case 2840: {
                    return "Image Count S";
                }
                case 2841: {
                    return "Original Stage Position X";
                }
                case 2842: {
                    return "Original Stage Position Y";
                }
                case 3088: {
                    return "LayerDrawFlags";
                }
                case 3334: {
                    return "RemainingTime";
                }
                case 3585: {
                    return "User Field 1";
                }
                case 3586: {
                    return "User Field 2";
                }
                case 3587: {
                    return "User Field 3";
                }
                case 3588: {
                    return "User Field 4";
                }
                case 3589: {
                    return "User Field 5";
                }
                case 3590: {
                    return "User Field 6";
                }
                case 3591: {
                    return "User Field 7";
                }
                case 3592: {
                    return "User Field 8";
                }
                case 3593: {
                    return "User Field 9";
                }
                case 3594: {
                    return "User Field 10";
                }
                case 3840: {
                    return "ID";
                }
                case 3841: {
                    return "Name";
                }
                case 3842: {
                    return "Value";
                }
                case 5501: {
                    return "PvCamClockingMode";
                }
                case 8193: {
                    return "Autofocus Status Report";
                }
                case 8194: {
                    return "Autofocus Position";
                }
                case 8195: {
                    return "Autofocus Position Offset";
                }
                case 8196: {
                    return "Autofocus Empty Field Threshold";
                }
                case 8197: {
                    return "Autofocus Calibration Name";
                }
                case 8198: {
                    return "Autofocus Current Calibration Item";
                }
                case 20478: {
                    return "tag_ID_20478";
                }
                case 65537: {
                    return "CameraFrameFullWidth";
                }
                case 65538: {
                    return "CameraFrameFullHeight";
                }
                case 65541: {
                    return "AxioCam Shutter Signal";
                }
                case 65542: {
                    return "AxioCam Delay Time";
                }
                case 65543: {
                    return "AxioCam Shutter Control";
                }
                case 65544: {
                    return "AxioCam BlackRefIsCalculated";
                }
                case 65545: {
                    return "AxioCam Black Reference";
                }
                case 65547: {
                    return "Camera Shading Correction";
                }
                case 65550: {
                    return "AxioCam Enhance Color";
                }
                case 65551: {
                    return "AxioCam NIR Mode";
                }
                case 65552: {
                    return "CameraShutterCloseDelay";
                }
                case 65553: {
                    return "CameraWhiteBalanceAutoCalculate";
                }
                case 65556: {
                    return "AxioCam NIR Mode Available";
                }
                case 65557: {
                    return "AxioCam Fading Correction Available";
                }
                case 65559: {
                    return "AxioCam Enhance Color Available";
                }
                case 65565: {
                    return "MeteorVideoNorm";
                }
                case 65566: {
                    return "MeteorAdjustWhiteReference";
                }
                case 65567: {
                    return "MeteorBlackReference";
                }
                case 65568: {
                    return "MeteorChannelInputCountMono";
                }
                case 65570: {
                    return "MeteorChannelInputCountRGB";
                }
                case 65571: {
                    return "MeteorEnableVCR";
                }
                case 65572: {
                    return "Meteor Brightness";
                }
                case 65573: {
                    return "Meteor Contrast";
                }
                case 65575: {
                    return "AxioCam Selector";
                }
                case 65576: {
                    return "AxioCam Type";
                }
                case 65577: {
                    return "AxioCam Info";
                }
                case 65580: {
                    return "AxioCam Resolution";
                }
                case 65581: {
                    return "AxioCam Color Model";
                }
                case 65582: {
                    return "AxioCam MicroScanning";
                }
                case 65585: {
                    return "Amplification Index";
                }
                case 65586: {
                    return "Device Command";
                }
                case 65587: {
                    return "BeamLocation";
                }
                case 65588: {
                    return "ComponentType";
                }
                case 65589: {
                    return "ControllerType";
                }
                case 65590: {
                    return "CameraWhiteBalanceCalculationRedPaint";
                }
                case 65591: {
                    return "CameraWhiteBalanceCalculationBluePaint";
                }
                case 65592: {
                    return "CameraWhiteBalanceSetRed";
                }
                case 65593: {
                    return "CameraWhiteBalanceSetGreen";
                }
                case 65594: {
                    return "CameraWhiteBalanceSetBlue";
                }
                case 65595: {
                    return "CameraWhiteBalanceSetTargetRed";
                }
                case 65596: {
                    return "CameraWhiteBalanceSetTargetGreen";
                }
                case 65597: {
                    return "CameraWhiteBalanceSetTargetBlue";
                }
                case 65598: {
                    return "ApotomeCamCalibrationMode";
                }
                case 65599: {
                    return "ApoTome Grid Position";
                }
                case 65600: {
                    return "ApotomeCamScannerPosition";
                }
                case 65601: {
                    return "ApoTome Full Phase Shift";
                }
                case 65602: {
                    return "ApoTome Grid Name";
                }
                case 65603: {
                    return "ApoTome Staining";
                }
                case 65604: {
                    return "ApoTome Processing Mode";
                }
                case 65605: {
                    return "ApotomeCamLiveCombineMode";
                }
                case 65606: {
                    return "ApoTome Filter Name";
                }
                case 65607: {
                    return "Apotome Filter Strength";
                }
                case 65608: {
                    return "ApotomeCamFilterHarmonics";
                }
                case 65609: {
                    return "ApoTome Grating Period";
                }
                case 65610: {
                    return "ApoTome Auto Shutter Used";
                }
                case 65611: {
                    return "Apotome Cam Status";
                }
                case 65612: {
                    return "ApotomeCamNormalize";
                }
                case 65613: {
                    return "ApotomeCamSettingsManager";
                }
                case 65614: {
                    return "DeepviewCamSupervisorMode";
                }
                case 65615: {
                    return "DeepView Processing";
                }
                case 65616: {
                    return "DeepviewCamFilterName";
                }
                case 65617: {
                    return "DeepviewCamStatus";
                }
                case 65618: {
                    return "DeepviewCamSettingsManager";
                }
                case 65619: {
                    return "DeviceScalingName";
                }
                case 65620: {
                    return "CameraShadingIsCalculated";
                }
                case 65621: {
                    return "CameraShadingCalculationName";
                }
                case 65622: {
                    return "CameraShadingAutoCalculate";
                }
                case 65623: {
                    return "CameraTriggerAvailable";
                }
                case 65626: {
                    return "CameraShutterAvailable";
                }
                case 65627: {
                    return "AxioCam ShutterMicroScanningEnable";
                }
                case 65628: {
                    return "ApotomeCamLiveFocus";
                }
                case 65629: {
                    return "DeviceInitStatus";
                }
                case 65630: {
                    return "DeviceErrorStatus";
                }
                case 65631: {
                    return "ApotomeCamSliderInGridPosition";
                }
                case 65632: {
                    return "Orca NIR Mode Used";
                }
                case 65633: {
                    return "Orca Analog Gain";
                }
                case 65634: {
                    return "Orca Analog Offset";
                }
                case 65635: {
                    return "Orca Binning";
                }
                case 65636: {
                    return "Orca Bit Depth";
                }
                case 65637: {
                    return "ApoTome Averaging Count";
                }
                case 65638: {
                    return "DeepView DoF";
                }
                case 65639: {
                    return "DeepView EDoF";
                }
                case 65643: {
                    return "DeepView Slider Name";
                }
                case 65651: {
                    return "tag_ID_65651";
                }
                case 65652: {
                    return "tag_ID_65652";
                }
                case 65655: {
                    return "DeepView Slider Name";
                }
                case 65657: {
                    return "tag_ID_65657";
                }
                case 65658: {
                    return "tag_ID_65658";
                }
                case 65661: {
                    return "tag_ID_65661";
                }
                case 65662: {
                    return "tag_ID_65662";
                }
                case 0x530003: {
                    return "Acquisition Software";
                }
                case 0x1000110: {
                    return "Excitation Wavelength";
                }
                case 0x1000111: {
                    return "Emission Wavelength";
                }
                case 101515267: {
                    return "File Name";
                }
                case 101253123: 
                case 101777411: {
                    return "Image Name";
                }
            }
            return "tag_ID_" + tagID;
        }
    }

    public static enum Context {
        MAIN,
        SCALING,
        PLANE;

    }
}

