/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.gui.AWTImageTools;
import loci.formats.in.BIFormatReader;
import loci.formats.meta.MetadataStore;

public abstract class ImageIOReader
extends BIFormatReader {
    private transient BufferedImage img;

    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
        this.domains = new String[]{"Graphics"};
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
        this.domains = new String[]{"Graphics"};
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.img = null;
        }
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public Object openPlane(int no, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, -1, x, y, w, h2);
        if (this.img == null) {
            this.initImage();
        }
        return AWTImageTools.getSubimage(this.img, this.isLittleEndian(), x, y, w, h2);
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Populating metadata");
        m3.imageCount = 1;
        this.initImage();
        m3.sizeX = this.img.getWidth();
        m3.sizeY = this.img.getHeight();
        m3.rgb = this.img.getRaster().getNumBands() > 1;
        m3.sizeZ = 1;
        m3.sizeC = this.isRGB() ? 3 : 1;
        m3.sizeT = 1;
        m3.dimensionOrder = "XYCZT";
        m3.pixelType = AWTImageTools.getPixelType(this.img);
        m3.interleaved = false;
        m3.littleEndian = false;
        m3.metadataComplete = true;
        m3.indexed = false;
        m3.falseColor = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    protected void initImage() throws IOException, FormatException {
        try (RandomAccessInputStream ras = new RandomAccessInputStream(this.currentId);
             DataInputStream dis = new DataInputStream(ras);){
            this.img = ImageIO.read(dis);
        }
        if (this.img == null) {
            throw new FormatException("Invalid image stream");
        }
    }
}

