/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.xml.model.primitives.Timestamp;

public class SpiderReader
extends FormatReader {
    private static final String DATE_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private long headerSize = 0L;
    private boolean oneHeaderPerSlice = false;

    public SpiderReader() {
        super("SPIDER", "spi");
        this.domains = new String[]{"Electron Microscopy (EM)"};
        this.suffixSufficient = true;
        this.suffixNecessary = false;
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 104;
        if (!FormatTools.validStream(stream, 104, true)) {
            return false;
        }
        int size = (int)stream.readFloat() * 4;
        if (size == 0) {
            stream.seek(0L);
            stream.order(false);
            size = (int)stream.readFloat() * 4;
        }
        stream.skipBytes(4);
        size *= (int)stream.readFloat();
        stream.seek(44L);
        int nsam = (int)stream.readFloat();
        size *= nsam;
        int headerSize = nsam * (int)stream.readFloat() * 4;
        stream.skipBytes(48);
        int slices = (int)stream.readFloat();
        if (slices > 0) {
            size *= slices;
        }
        return (long)(size + headerSize) == stream.length() || (long)size == stream.length();
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        long header = this.headerSize;
        if (this.oneHeaderPerSlice) {
            header += (long)(no + 1) * this.headerSize;
        }
        this.in.seek(header + (long)(no * FormatTools.getPlaneSize(this)));
        this.readPlane(this.in, x, y, w, h2, buf);
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.headerSize = 0L;
            this.oneHeaderPerSlice = false;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m3 = (CoreMetadata)this.core.get(0);
        m3.littleEndian = true;
        this.in.order(this.isLittleEndian());
        int nSlice = (int)this.in.readFloat();
        boolean bl = m3.littleEndian = nSlice > 0;
        if (!this.isLittleEndian()) {
            this.in.order(this.isLittleEndian());
            this.in.seek(0L);
            nSlice = (int)this.in.readFloat();
        }
        int nRow = (int)this.in.readFloat();
        int irec = (int)this.in.readFloat();
        this.in.skipBytes(4);
        int iform = (int)this.in.readFloat();
        int imami = (int)this.in.readFloat();
        float fmax = this.in.readFloat();
        float fmin = this.in.readFloat();
        float average = this.in.readFloat();
        float sig = this.in.readFloat();
        this.in.skipBytes(4);
        int nsam = (int)this.in.readFloat();
        int labrec = (int)this.in.readFloat();
        this.headerSize = (long)labrec * (long)nsam * 4L;
        int iAngle = (int)this.in.readFloat();
        float phi = this.in.readFloat();
        float theta = this.in.readFloat();
        float gamma = this.in.readFloat();
        float xOff = this.in.readFloat();
        float yOff = this.in.readFloat();
        float zOff = this.in.readFloat();
        float scale = this.in.readFloat();
        int labbyte = (int)this.in.readFloat();
        int lenbyte = (int)this.in.readFloat();
        int istack = (int)this.in.readFloat();
        this.in.skipBytes(4);
        float maxim = this.in.readFloat();
        float imgnum = this.in.readFloat();
        float lastIndx = this.in.readFloat();
        this.in.skipBytes(8);
        float kAngle = this.in.readFloat();
        float phi1 = this.in.readFloat();
        float theta1 = this.in.readFloat();
        float psi1 = this.in.readFloat();
        float phi2 = this.in.readFloat();
        float theta2 = this.in.readFloat();
        float psi2 = this.in.readFloat();
        float pixelSize = this.in.readFloat();
        float ev = this.in.readFloat();
        this.in.skipBytes(244);
        float psi3 = this.in.readFloat();
        float theta3 = this.in.readFloat();
        float phi3 = this.in.readFloat();
        float lAngle = this.in.readFloat();
        this.in.skipBytes(428);
        String creationDate = this.in.readString(12).trim();
        String creationTime = this.in.readString(8);
        String title = this.in.readString(160);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.addGlobalMeta("NSLICE", nSlice);
            this.addGlobalMeta("NROW", nRow);
            this.addGlobalMeta("IREC", irec);
            this.addGlobalMeta("IFORM", iform);
            this.addGlobalMeta("IMAMI", imami);
            this.addGlobalMeta("FMAX", fmax);
            this.addGlobalMeta("FMIN", fmin);
            this.addGlobalMeta("AV", average);
            this.addGlobalMeta("SIG", sig);
            this.addGlobalMeta("NSAM", nsam);
            this.addGlobalMeta("LABREC", labrec);
            this.addGlobalMeta("IANGLE", iAngle);
            this.addGlobalMeta("PHI", phi);
            this.addGlobalMeta("THETA", theta);
            this.addGlobalMeta("GAMMA", gamma);
            this.addGlobalMeta("XOFF", xOff);
            this.addGlobalMeta("YOFF", yOff);
            this.addGlobalMeta("ZOFF", zOff);
            this.addGlobalMeta("SCALE", scale);
            this.addGlobalMeta("LABBYT", labbyte);
            this.addGlobalMeta("LENBYT", lenbyte);
            this.addGlobalMeta("ISTACK/MAXINDX", istack);
            this.addGlobalMeta("MAXIM", maxim);
            this.addGlobalMeta("IMGNUM", imgnum);
            this.addGlobalMeta("LASTINDX", lastIndx);
            this.addGlobalMeta("KANGLE", kAngle);
            this.addGlobalMeta("PHI1", phi1);
            this.addGlobalMeta("THETA1", theta1);
            this.addGlobalMeta("PSI1", psi1);
            this.addGlobalMeta("PHI2", phi2);
            this.addGlobalMeta("THETA2", theta2);
            this.addGlobalMeta("PSI2", psi2);
            this.addGlobalMeta("PIXSIZ", pixelSize);
            this.addGlobalMeta("EV", ev);
            this.addGlobalMeta("PHI3", phi3);
            this.addGlobalMeta("THETA3", theta3);
            this.addGlobalMeta("PSI3", psi3);
            this.addGlobalMeta("LANGLE", lAngle);
            this.addGlobalMeta("CDAT", creationDate);
            this.addGlobalMeta("CTIM", creationTime);
            this.addGlobalMeta("CTIT", title);
        }
        m3.imageCount = Math.max(nSlice, 1);
        if (maxim > 0.0f) {
            m3.imageCount = (int)((float)m3.imageCount * maxim);
        }
        m3.sizeZ = this.getImageCount();
        m3.sizeC = 1;
        m3.sizeT = 1;
        m3.sizeY = nRow;
        m3.sizeX = nsam;
        m3.pixelType = 6;
        m3.dimensionOrder = "XYZCT";
        m3.rgb = false;
        long planeSize = FormatTools.getPlaneSize(this);
        this.oneHeaderPerSlice = (long)(irec * nsam * 4) != planeSize && (long)((irec - 1) * 4) != planeSize;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageName(title, 0);
        String date = creationDate + " " + creationTime;
        date = DateTools.formatDate(date, DATE_FORMAT);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Double size = new Double(pixelSize);
            Length sizeX = FormatTools.getPhysicalSizeX(size, UNITS.ANGSTROM);
            Length sizeY = FormatTools.getPhysicalSizeY(size, UNITS.ANGSTROM);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
        }
    }
}

