/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import ome.codecs.CodecOptions;

public class JPEG2000CodecOptions
extends CodecOptions {
    public int[] codeBlockSize;
    public Integer numDecompositionLevels;
    public Integer resolution;
    public boolean writeBox = true;

    public JPEG2000CodecOptions() {
    }

    public JPEG2000CodecOptions(CodecOptions options) {
        super(options);
        if (options instanceof JPEG2000CodecOptions) {
            JPEG2000CodecOptions j2kOptions = (JPEG2000CodecOptions)options;
            if (j2kOptions.codeBlockSize != null) {
                this.codeBlockSize = j2kOptions.codeBlockSize;
            }
            this.numDecompositionLevels = j2kOptions.numDecompositionLevels;
            this.resolution = j2kOptions.resolution;
        }
    }

    public static JPEG2000CodecOptions getDefaultOptions() {
        CodecOptions options = CodecOptions.getDefaultOptions();
        return JPEG2000CodecOptions.getDefaultOptions(options);
    }

    public static JPEG2000CodecOptions getDefaultOptions(CodecOptions options) {
        JPEG2000CodecOptions j2kOptions = new JPEG2000CodecOptions(options);
        j2kOptions.quality = j2kOptions.lossless ? Double.MAX_VALUE : 10.0;
        j2kOptions.codeBlockSize = new int[]{64, 64};
        j2kOptions.writeBox = true;
        return j2kOptions;
    }
}

