/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j.logback;

import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.AppenderBase;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Arrays;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.perf4j.GroupedTimingStatistics;
import org.perf4j.helpers.AcceptableRangeConfiguration;
import org.perf4j.helpers.MiscUtils;
import org.perf4j.helpers.StatisticsExposingMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxAttributeStatisticsAppender
extends AppenderBase<LoggingEvent> {
    private String mBeanName = "org.perf4j:type=StatisticsExposingMBean,name=Perf4J";
    private String tagNamesToExpose;
    private String notificationThresholds;
    protected StatisticsExposingMBean mBean;

    public String getMBeanName() {
        return this.mBeanName;
    }

    public void setMBeanName(String mBeanName) {
        this.mBeanName = mBeanName;
    }

    public String getTagNamesToExpose() {
        return this.tagNamesToExpose;
    }

    public void setTagNamesToExpose(String tagNamesToExpose) {
        this.tagNamesToExpose = tagNamesToExpose;
    }

    public String getNotificationThresholds() {
        return this.notificationThresholds;
    }

    public void setNotificationThresholds(String notificationThresholds) {
        this.notificationThresholds = notificationThresholds;
    }

    @Override
    public void start() {
        super.start();
        if (this.tagNamesToExpose == null) {
            throw new RuntimeException("You must set the TagNamesToExpose option before activating this appender");
        }
        String[] tagNames = MiscUtils.splitAndTrim(this.tagNamesToExpose, ",");
        ArrayList<AcceptableRangeConfiguration> rangeConfigs = new ArrayList<AcceptableRangeConfiguration>();
        if (this.notificationThresholds != null) {
            String[] rangeConfigStrings;
            for (String rangeConfigString : rangeConfigStrings = MiscUtils.splitAndTrim(this.notificationThresholds, ",")) {
                rangeConfigs.add(new AcceptableRangeConfiguration(rangeConfigString));
            }
        }
        this.mBean = new StatisticsExposingMBean(this.mBeanName, Arrays.asList(tagNames), rangeConfigs);
        try {
            MBeanServer mBeanServer = this.getMBeanServer();
            mBeanServer.registerMBean(this.mBean, new ObjectName(this.mBeanName));
        }
        catch (Exception e) {
            throw new RuntimeException("Error registering statistics MBean: " + e.getMessage(), e);
        }
    }

    @Override
    public void stop() {
        try {
            MBeanServer mBeanServer = this.getMBeanServer();
            mBeanServer.unregisterMBean(new ObjectName(this.mBeanName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.stop();
    }

    @Override
    protected void append(LoggingEvent event) {
        Object logMessage;
        if (event.getArgumentArray() != null && event.getArgumentArray().length > 0 && (logMessage = event.getArgumentArray()[0]) instanceof GroupedTimingStatistics && this.mBean != null) {
            this.mBean.updateCurrentTimingStatistics((GroupedTimingStatistics)logMessage);
        }
    }

    protected MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

