/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.roi;

import icy.file.FileUtil;
import icy.gui.main.GlobalSequenceListener;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLauncher;
import icy.plugin.PluginLoader;
import icy.preferences.XMLPreferences;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.sequence.SequenceDataIterator;
import icy.sequence.SequenceEvent;
import icy.sequence.SequenceListener;
import icy.system.IcyExceptionHandler;
import icy.system.SystemUtil;
import icy.system.thread.Processor;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import icy.type.point.Point5D;
import icy.type.rectangle.Rectangle5D;
import icy.util.StringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import plugins.adufour.blocks.tools.roi.ROIBlock;
import plugins.adufour.blocks.util.VarList;
import plugins.adufour.ezplug.EzDialog;
import plugins.adufour.ezplug.EzPlug;
import plugins.adufour.roi.Convexify;
import plugins.adufour.roi.ROIConvexHullDescriptor;
import plugins.adufour.roi.ROIEllipsoidFittingDescriptor;
import plugins.adufour.roi.ROIFeretDiameterDescriptor;
import plugins.adufour.roi.ROIHaralickTextureDescriptor;
import plugins.adufour.roi.ROIRoundnessDescriptor;
import plugins.adufour.roi.ROISphericityDescriptor;
import plugins.adufour.roi.intensitycenter.ROIIntensityCenterDescriptorsPlugin;
import plugins.adufour.vars.gui.VarEditor;
import plugins.adufour.vars.gui.swing.SwingVarEditor;
import plugins.adufour.vars.gui.swing.WorkbookEditor;
import plugins.adufour.vars.lang.Var;
import plugins.adufour.vars.lang.VarLong;
import plugins.adufour.vars.lang.VarROIArray;
import plugins.adufour.vars.lang.VarSequence;
import plugins.adufour.vars.lang.VarWorkbook;
import plugins.adufour.vars.util.VarListener;
import plugins.adufour.vars.util.VarReferencingPolicy;
import plugins.adufour.workbooks.IcySpreadSheet;
import plugins.adufour.workbooks.Workbooks;
import plugins.kernel.roi.descriptor.measure.ROIBasicMeasureDescriptorsPlugin;
import plugins.kernel.roi.descriptor.measure.ROIContourDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIInteriorDescriptor;
import plugins.kernel.roi.descriptor.measure.ROIMassCenterDescriptorsPlugin;

public class ROIMeasures
extends EzPlug
implements ROIBlock,
GlobalSequenceListener,
SequenceListener,
ROIListener {
    Processor cpus = new Processor(0x200000, SystemUtil.getNumberOfCPUs());
    final VarMeasureSelector measureSelector;
    final VarROIArray rois = new VarROIArray("Regions of interest");
    final VarWorkbook book = new VarWorkbook("Workbook", (Workbook)null);
    final VarSequence sequence = new VarSequence("Sequence", null);
    boolean measureSelectionChanged = false;

    public ROIMeasures() {
        this.measureSelector = new VarMeasureSelector(new MeasureSelector());
        XMLPreferences prefs = this.getPreferences("measures");
        long value = 0L;
        int i = 0;
        for (Measures measure : Measures.values()) {
            measure.selected = prefs.node(measure.name()).getBoolean("selected", true);
            if (i < 64 && measure.selected) {
                value |= 1L << i;
            }
            ++i;
        }
        this.measureSelector.setValue(value);
    }

    public void declareInput(VarList inputMap) {
        this.measureSelector.setReferencingPolicy(VarReferencingPolicy.NONE);
        inputMap.add("measures", (Var)this.measureSelector);
        inputMap.add("Regions of interest", (Var)this.rois);
        inputMap.add("Sequence", (Var)this.sequence);
    }

    public void declareOutput(VarList outputMap) {
        outputMap.add("Workbook", (Var)this.book);
    }

    protected void initialize() {
        this.getUI().setActionPanelVisible(false);
        this.addComponent((JComponent)this.measureSelector.createVarEditor(true).getEditorComponent());
        WorkbookEditor viewer = new WorkbookEditor(this.book);
        viewer.setReadOnly(true);
        viewer.setEnabled(true);
        viewer.setFirstRowAsHeader(true);
        viewer.setOpenButtonVisible(false);
        JComponent jc = viewer.getEditorComponent();
        jc.setPreferredSize(new Dimension(400, 300));
        this.addComponent(jc);
        if (!this.isHeadLess()) {
            Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this);
        }
        this.getUI().clickRun();
    }

    public void execute() {
        Workbook wb = (Workbook)this.book.getValue();
        if (wb == null || this.isHeadLess()) {
            wb = Workbooks.createEmptyWorkbook();
            this.book.setValue((Object)wb);
        }
        if (!this.isHeadLess()) {
            for (Sequence attachedSequence : this.getSequences()) {
                attachedSequence.addListener((SequenceListener)this);
                for (ROI roi : attachedSequence.getROIs()) {
                    roi.addListener((ROIListener)this);
                }
            }
        }
        this.updateStatistics();
    }

    private String getDataSetName(Sequence sequenceOfInterest) {
        ArrayList sequences;
        String dataSetName = "ROI Statistics";
        if (sequenceOfInterest == null && (sequences = ((ROI[])this.rois.getValue())[0].getSequences()).size() > 0) {
            sequenceOfInterest = (Sequence)sequences.get(0);
        }
        if (sequenceOfInterest == null) {
            dataSetName = "--";
        } else {
            dataSetName = FileUtil.getFileName((String)sequenceOfInterest.getFilename());
            if (StringUtil.isEmpty((String)dataSetName)) {
                dataSetName = sequenceOfInterest.getName();
            }
        }
        return dataSetName;
    }

    String getSheetName(Sequence sequenceOfInterest) {
        String sheetName = "ROI Statistics";
        if (sequenceOfInterest != null && !this.isHeadLess()) {
            sheetName = this.getDataSetName(sequenceOfInterest);
        }
        return WorkbookUtil.createSafeSheetName((String)sheetName);
    }

    private void updateStatistics() {
        if (this.isHeadLess()) {
            this.updateStatistics((Sequence)this.sequence.getValue());
        } else {
            for (Sequence sequenceOfInterest : this.getSequences()) {
                this.updateStatistics(sequenceOfInterest);
            }
        }
    }

    private void updateStatistics(final Sequence sequenceOfInterest) {
        Sheet sheet;
        if (sequenceOfInterest == null) {
            return;
        }
        final Workbook wb = (Workbook)this.book.getValue();
        String sheetName = this.getSheetName(sequenceOfInterest);
        Row header = null;
        if (wb.getSheet(sheetName) != null) {
            sheet = wb.getSheet(sheetName);
        } else {
            sheet = wb.createSheet(sheetName);
            this.measureSelectionChanged = true;
        }
        if (this.measureSelectionChanged) {
            this.measureSelectionChanged = false;
            header = sheet.createRow(0);
            Measures[] measures = Measures.values();
            int sizeC = sequenceOfInterest.getSizeC();
            int col = 0;
            block3: for (Measures measure : measures) {
                if (!measure.isSelected()) continue;
                String name = measure.toHeader();
                switch (measure) {
                    case INTENSITY_MIN: 
                    case INTENSITY_MAX: 
                    case INTENSITY_SUM: 
                    case INTENSITY_AVG: 
                    case INTENSITY_STD: 
                    case INTENSITY_TEXTURE_ASM: 
                    case INTENSITY_TEXTURE_CONT: 
                    case INTENSITY_TEXTURE_ENT: 
                    case INTENSITY_TEXTURE_HOMO: 
                    case INTENSITY_X: 
                    case INTENSITY_Y: 
                    case INTENSITY_Z: {
                        for (int c = 0; c < sizeC; ++c) {
                            header.getCell(col).setCellValue(name + " (" + sequenceOfInterest.getChannelName(c) + ")");
                            ++col;
                        }
                        continue block3;
                    }
                    default: {
                        header.getCell(col).setCellValue(name);
                        ++col;
                    }
                }
            }
        }
        final List<Object> rois2Update = this.isHeadLess() ? Arrays.asList((Object[])this.rois.getValue()) : sequenceOfInterest.getROIs(true);
        Runnable fullUpdate = new Runnable(){

            @Override
            public void run() {
                try {
                    IcySpreadSheet icySheet = new IcySpreadSheet(sheet);
                    int rowID = 1;
                    icySheet.removeRows(rowID);
                    ArrayList<Future> results = new ArrayList<Future>(rois2Update.size());
                    for (ROI roi : rois2Update) {
                        if (ROIMeasures.this.cpus.isShutdown() || ROIMeasures.this.cpus.isTerminating()) {
                            return;
                        }
                        results.add(ROIMeasures.this.cpus.submit(ROIMeasures.this.createUpdater(sequenceOfInterest, roi)));
                    }
                    for (Future result : results) {
                        ROIMeasures.this.updateWorkbook(wb, icySheet, rowID++, (List)result.get(), false);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                catch (Exception e) {
                    IcyExceptionHandler.showErrorMessage((Throwable)e, (boolean)true);
                    return;
                }
                ROIMeasures.this.book.valueChanged((Var)ROIMeasures.this.book, null, ROIMeasures.this.book.getValue());
            }
        };
        if (this.isHeadLess()) {
            fullUpdate.run();
        } else {
            ThreadUtil.bgRun((Runnable)fullUpdate);
        }
    }

    private void updateStatistics(ROI roi) {
        Workbook wb = (Workbook)this.book.getValue();
        for (Sequence sequenceOfInterest : roi.getSequences()) {
            if (!Icy.getMainInterface().isOpened(sequenceOfInterest)) continue;
            try {
                IcySpreadSheet sheet = Workbooks.getSheet((Workbook)wb, (String)this.getSheetName(sequenceOfInterest));
                int rowID = sequenceOfInterest.getROIs(true).indexOf(roi) + 1;
                List<Object> measures = this.createUpdater(sequenceOfInterest, roi).call();
                this.updateWorkbook(wb, sheet, rowID, measures, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static String colorToString(Color color) {
        return (StringUtil.toHexaString((int)color.getAlpha(), (int)2) + StringUtil.toHexaString((int)color.getRed(), (int)2) + StringUtil.toHexaString((int)color.getGreen(), (int)2) + StringUtil.toHexaString((int)color.getBlue(), (int)2)).toUpperCase();
    }

    private void updateWorkbook(Workbook wb, IcySpreadSheet sheet, int rowID, List<Object> measures, boolean updateInterface) {
        for (int colID = 0; colID < measures.size(); ++colID) {
            Object value = measures.get(colID);
            if (value instanceof Color) {
                sheet.setFillColor(rowID, colID, (Color)value);
                sheet.setValue(rowID, colID, (Object)ROIMeasures.colorToString((Color)value));
                continue;
            }
            sheet.setValue(rowID, colID, value);
        }
        if (updateInterface) {
            this.book.valueChanged((Var)this.book, null, this.book.getValue());
        }
    }

    private Callable<List<Object>> createUpdater(final Sequence sequenceOfInterest, final ROI roi2Update) {
        return new Callable<List<Object>>(){

            @Override
            public List<Object> call() throws InterruptedException {
                ROI2D rCopy;
                ArrayList<Object> measures = new ArrayList<Object>();
                ArrayList<Measures> measuresToCalculate = new ArrayList<Measures>();
                for (Measures m : Measures.values()) {
                    if (!m.isSelected()) continue;
                    measuresToCalculate.add(m);
                }
                ROI roi = roi2Update;
                Point5D center = null;
                Point3D globalCenter = null;
                if (Measures.X_CENTER.isSelected() || Measures.Y_CENTER.isSelected() || Measures.Z_CENTER.isSelected() || Measures.T_CENTER.isSelected() || Measures.C_CENTER.isSelected() || Measures.X_GLOBAL_CENTER.isSelected() || Measures.Y_GLOBAL_CENTER.isSelected() || Measures.Z_GLOBAL_CENTER.isSelected()) {
                    center = ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
                    globalCenter = center.toPoint3D();
                    if (sequenceOfInterest != null) {
                        globalCenter.setX(sequenceOfInterest.getPositionX() + globalCenter.getX() * sequenceOfInterest.getPixelSizeX());
                        globalCenter.setY(sequenceOfInterest.getPositionY() + globalCenter.getY() * sequenceOfInterest.getPixelSizeY());
                        globalCenter.setZ(sequenceOfInterest.getPositionZ() + globalCenter.getZ() * sequenceOfInterest.getPixelSizeZ());
                    }
                }
                Rectangle5D bounds5 = null;
                if (Measures.POSITION_X.isSelected() || Measures.POSITION_Y.isSelected() || Measures.POSITION_Z.isSelected() || Measures.POSITION_T.isSelected() || Measures.POSITION_C.isSelected() || Measures.SIZE_X.isSelected() || Measures.SIZE_Y.isSelected() || Measures.SIZE_Z.isSelected() || Measures.SIZE_T.isSelected() || Measures.SIZE_C.isSelected()) {
                    bounds5 = roi.getBounds5D();
                }
                double[] ellipsoidValues = null;
                if (Measures.ELLIPSE_A.isSelected() || Measures.ELLIPSE_B.isSelected() || Measures.ELLIPSE_C.isSelected() || Measures.YAW.isSelected() || Measures.PITCH.isSelected() || Measures.ROLL.isSelected() || Measures.ELONGATION.isSelected() || Measures.FLATNESS3D.isSelected()) {
                    ellipsoidValues = ROIEllipsoidFittingDescriptor.computeOrientation(roi, sequenceOfInterest);
                }
                double[] channelMins = null;
                double[] channelMaxs = null;
                double[] channelSums = null;
                int[] channelPointCounts = null;
                double[] channelAvgs = null;
                double[] channelStdDevs = null;
                if (Measures.INTENSITY_MIN.isSelected() || Measures.INTENSITY_AVG.isSelected() || Measures.INTENSITY_MAX.isSelected() || Measures.INTENSITY_SUM.isSelected() || Measures.INTENSITY_STD.isSelected()) {
                    channelMins = new double[sequenceOfInterest.getSizeC()];
                    channelMaxs = new double[sequenceOfInterest.getSizeC()];
                    channelSums = new double[sequenceOfInterest.getSizeC()];
                    channelPointCounts = new int[sequenceOfInterest.getSizeC()];
                    channelAvgs = new double[sequenceOfInterest.getSizeC()];
                    channelStdDevs = new double[sequenceOfInterest.getSizeC()];
                    for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                        if (Thread.currentThread().isInterrupted()) {
                            return measures;
                        }
                        SequenceDataIterator iterator = new SequenceDataIterator(sequenceOfInterest, roi, true, -1, -1, c);
                        channelMins[c] = Double.MAX_VALUE;
                        channelMaxs[c] = 0.0;
                        channelSums[c] = 0.0;
                        channelPointCounts[c] = 0;
                        while (!iterator.done()) {
                            double val = iterator.get();
                            if (val > channelMaxs[c]) {
                                channelMaxs[c] = val;
                            }
                            if (val < channelMins[c]) {
                                channelMins[c] = val;
                            }
                            int n = c;
                            channelSums[n] = channelSums[n] + val;
                            int n2 = c;
                            channelPointCounts[n2] = channelPointCounts[n2] + 1;
                            iterator.next();
                        }
                        channelAvgs[c] = channelSums[c] / (double)channelPointCounts[c];
                        if (!Measures.INTENSITY_STD.isSelected()) continue;
                        channelStdDevs[c] = 0.0;
                        iterator.reset();
                        while (!iterator.done()) {
                            double dev = iterator.get() - channelAvgs[c];
                            int n = c;
                            channelStdDevs[n] = channelStdDevs[n] + dev * dev;
                            iterator.next();
                        }
                        channelStdDevs[c] = Math.sqrt(channelStdDevs[c] / (double)channelPointCounts[c]);
                    }
                }
                Map[] haralickTextureValues = null;
                HashSet<String> haralickErrors = new HashSet<String>();
                if (Measures.INTENSITY_TEXTURE_ASM.isSelected() || Measures.INTENSITY_TEXTURE_CONT.isSelected() || Measures.INTENSITY_TEXTURE_ENT.isSelected() || Measures.INTENSITY_TEXTURE_HOMO.isSelected()) {
                    Map[] valueMap;
                    haralickTextureValues = valueMap = new Map[sequenceOfInterest.getSizeC()];
                    if (roi instanceof ROI2D) {
                        rCopy = (ROI2D)roi.getCopy();
                        for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                            try {
                                rCopy.setC(c);
                                haralickTextureValues[c] = new ROIHaralickTextureDescriptor().compute((ROI)rCopy, sequenceOfInterest);
                                continue;
                            }
                            catch (UnsupportedOperationException ex) {
                                String mess = ex.getMessage();
                                if (haralickErrors.contains(mess)) continue;
                                haralickErrors.add(mess);
                                System.err.println(mess);
                            }
                        }
                    }
                }
                Point3D[] intensityCenters = null;
                if (Measures.INTENSITY_X.isSelected() || Measures.INTENSITY_Y.isSelected() || Measures.INTENSITY_Z.isSelected()) {
                    intensityCenters = new Point3D[sequenceOfInterest.getSizeC()];
                    rCopy = roi.getCopy();
                    Point5D rPosition = rCopy.getPosition5D();
                    for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                        rPosition.setC((double)c);
                        rCopy.setPosition5D(rPosition);
                        intensityCenters[c] = ROIIntensityCenterDescriptorsPlugin.computeIntensityCenter((ROI)rCopy, sequenceOfInterest);
                    }
                }
                block64: for (Measures m : measuresToCalculate) {
                    if (Thread.currentThread().isInterrupted()) {
                        return measures;
                    }
                    try {
                        switch (m) {
                            case FULLPATH: 
                            case FOLDER: {
                                String path = "";
                                if (sequenceOfInterest != null && sequenceOfInterest.getFilename() != null) {
                                    path = sequenceOfInterest.getFilename();
                                }
                                if (m == Measures.FULLPATH) {
                                    if (StringUtil.isEmpty((String)path)) {
                                        measures.add("---");
                                    } else {
                                        measures.add(FileUtil.getDirectory((String)path, (boolean)false));
                                    }
                                }
                                if (m != Measures.FOLDER) break;
                                if (StringUtil.isEmpty((String)path)) {
                                    measures.add("---");
                                    break;
                                }
                                measures.add(FileUtil.getFileName((String)FileUtil.getDirectory((String)path, (boolean)false)));
                                break;
                            }
                            case DATASET: {
                                measures.add(ROIMeasures.this.getDataSetName(sequenceOfInterest));
                                break;
                            }
                            case NAME: {
                                measures.add(roi.getName());
                                break;
                            }
                            case COLOR: {
                                measures.add(roi.getColor());
                                break;
                            }
                            case X_CENTER: {
                                measures.add(center.getX());
                                break;
                            }
                            case Y_CENTER: {
                                measures.add(center.getY());
                                break;
                            }
                            case Z_CENTER: {
                                measures.add(roi instanceof ROI2D && center.getZ() == -1.0 ? "ALL" : Double.valueOf(center.getZ()));
                                break;
                            }
                            case T_CENTER: {
                                measures.add(center.getT() == -1.0 ? "ALL" : Double.valueOf(center.getT()));
                                break;
                            }
                            case C_CENTER: {
                                measures.add(center.getC() == -1.0 ? "ALL" : Double.valueOf(center.getC()));
                                break;
                            }
                            case X_GLOBAL_CENTER: {
                                measures.add(globalCenter.getX());
                                break;
                            }
                            case Y_GLOBAL_CENTER: {
                                measures.add(globalCenter.getY());
                                break;
                            }
                            case Z_GLOBAL_CENTER: {
                                measures.add(roi instanceof ROI2D && center.getZ() == -1.0 ? "ALL" : Double.valueOf(globalCenter.getZ()));
                                break;
                            }
                            case POSITION_X: {
                                measures.add(bounds5.getX());
                                break;
                            }
                            case POSITION_Y: {
                                measures.add(bounds5.getY());
                                break;
                            }
                            case POSITION_Z: {
                                if (Double.isInfinite(bounds5.getZ())) {
                                    measures.add("ALL");
                                    break;
                                }
                                measures.add(bounds5.getZ());
                                break;
                            }
                            case POSITION_T: {
                                if (Double.isInfinite(bounds5.getT())) {
                                    measures.add("ALL");
                                    break;
                                }
                                measures.add(bounds5.getT());
                                break;
                            }
                            case POSITION_C: {
                                if (Double.isInfinite(bounds5.getC())) {
                                    measures.add("ALL");
                                    break;
                                }
                                measures.add(bounds5.getC());
                                break;
                            }
                            case SIZE_X: {
                                measures.add(bounds5.getSizeX());
                                break;
                            }
                            case SIZE_Y: {
                                measures.add(bounds5.getSizeY());
                                break;
                            }
                            case SIZE_Z: {
                                if (roi instanceof ROI3D) {
                                    measures.add(bounds5.getSizeZ());
                                    break;
                                }
                                if (roi instanceof ROI2D) {
                                    if (Double.isInfinite(bounds5.getSizeZ())) {
                                        measures.add("ALL");
                                        break;
                                    }
                                    measures.add(1);
                                    break;
                                }
                                throw new RuntimeException("Not a ROI3D");
                            }
                            case SIZE_T: {
                                if (Double.isInfinite(bounds5.getSizeT())) {
                                    measures.add("ALL");
                                    break;
                                }
                                measures.add(bounds5.getSizeT());
                                break;
                            }
                            case SIZE_C: {
                                if (Double.isInfinite(bounds5.getSizeC())) {
                                    measures.add("ALL");
                                    break;
                                }
                                measures.add(bounds5.getSizeC());
                                break;
                            }
                            case CONTOUR: {
                                measures.add(ROIContourDescriptor.computeContour((ROI)roi));
                                break;
                            }
                            case INTERIOR: {
                                measures.add(ROIInteriorDescriptor.computeInterior((ROI)roi));
                                break;
                            }
                            case SPHERICITY: {
                                measures.add(ROISphericityDescriptor.ROISphericity.computeSphericity(roi));
                                break;
                            }
                            case ROUNDNESS: {
                                measures.add(roi.getNumberOfPoints() == 1.0 ? 100.0 : ROIRoundnessDescriptor.ROIRoundness.computeRoundness(roi));
                                break;
                            }
                            case CONVEXITY: {
                                measures.add(ROIConvexHullDescriptor.ROIConvexity.computeConvexity(roi));
                                break;
                            }
                            case MAX_FERET: {
                                measures.add(ROIFeretDiameterDescriptor.ROIFeretDiameter.computeFeretDiameter(roi, sequenceOfInterest));
                                break;
                            }
                            case ELLIPSE_A: {
                                measures.add(ellipsoidValues[0]);
                                break;
                            }
                            case ELLIPSE_B: {
                                measures.add(ellipsoidValues[1]);
                                break;
                            }
                            case ELLIPSE_C: {
                                if (roi instanceof ROI3D) {
                                    measures.add(ellipsoidValues[2]);
                                    break;
                                }
                                throw new RuntimeException("Not a ROI3D");
                            }
                            case YAW: {
                                measures.add(ROIEllipsoidFittingDescriptor.ROIYawAngle.computeYawAngle(ellipsoidValues));
                                break;
                            }
                            case PITCH: {
                                measures.add(ROIEllipsoidFittingDescriptor.ROIPitchAngle.computePitchAngle(ellipsoidValues));
                                break;
                            }
                            case ROLL: {
                                measures.add(ROIEllipsoidFittingDescriptor.ROIRollAngle.computeRollAngle(ellipsoidValues));
                                break;
                            }
                            case ELONGATION: {
                                if (ellipsoidValues[1] != 0.0) {
                                    measures.add(ROIEllipsoidFittingDescriptor.ROIElongation.computeElongation(ellipsoidValues));
                                    break;
                                }
                                throw new RuntimeException("Zero elongation");
                            }
                            case FLATNESS3D: {
                                if (roi instanceof ROI3D && ellipsoidValues[2] != 0.0) {
                                    measures.add(ROIEllipsoidFittingDescriptor.ROIFlatness3D.computeFlatness3D(ellipsoidValues));
                                    break;
                                }
                                throw new RuntimeException("Not a ROI3D or zero flatness");
                            }
                            case INTENSITY_MIN: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(channelMins[c]);
                                }
                                continue block64;
                            }
                            case INTENSITY_AVG: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(channelAvgs[c]);
                                }
                                continue block64;
                            }
                            case INTENSITY_MAX: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(channelMaxs[c]);
                                }
                                continue block64;
                            }
                            case INTENSITY_SUM: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(channelSums[c]);
                                }
                                continue block64;
                            }
                            case INTENSITY_STD: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(channelStdDevs[c]);
                                }
                                continue block64;
                            }
                            case INTENSITY_TEXTURE_ASM: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(haralickTextureValues[c].get(ROIHaralickTextureDescriptor.angularSecondMoment));
                                }
                                continue block64;
                            }
                            case INTENSITY_TEXTURE_CONT: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(haralickTextureValues[c].get(ROIHaralickTextureDescriptor.contrast));
                                }
                                continue block64;
                            }
                            case INTENSITY_TEXTURE_ENT: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(haralickTextureValues[c].get(ROIHaralickTextureDescriptor.entropy));
                                }
                                continue block64;
                            }
                            case INTENSITY_TEXTURE_HOMO: {
                                for (int c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(haralickTextureValues[c].get(ROIHaralickTextureDescriptor.homogeneity));
                                }
                                continue block64;
                            }
                            case PERIMETER: {
                                measures.add(roi.getLength(sequenceOfInterest));
                                break;
                            }
                            case AREA: {
                                double mul = ROIBasicMeasureDescriptorsPlugin.getMultiplierFactor((Sequence)sequenceOfInterest, (ROI)roi, (int)2);
                                if (mul == 0.0) {
                                    throw new UnsupportedOperationException();
                                }
                                measures.add(sequenceOfInterest.calculateSize(roi.getNumberOfPoints() * mul, 2, 2));
                                break;
                            }
                            case SURFACE_AREA: {
                                measures.add(((ROI3D)roi).getSurfaceArea(sequenceOfInterest));
                                break;
                            }
                            case VOLUME: {
                                double mul1 = ROIBasicMeasureDescriptorsPlugin.getMultiplierFactor((Sequence)sequenceOfInterest, (ROI)roi, (int)3);
                                if (mul1 == 0.0) {
                                    throw new UnsupportedOperationException();
                                }
                                measures.add(sequenceOfInterest.calculateSize(roi.getNumberOfPoints() * mul1, 3, 3));
                                break;
                            }
                            case INTENSITY_X: {
                                int c;
                                for (c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(intensityCenters[c].getX());
                                }
                                continue block64;
                            }
                            case INTENSITY_Y: {
                                int c;
                                for (c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(intensityCenters[c].getY());
                                }
                                continue block64;
                            }
                            case INTENSITY_Z: {
                                int c;
                                for (c = 0; c < sequenceOfInterest.getSizeC(); ++c) {
                                    measures.add(intensityCenters[c].getZ());
                                }
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof InterruptedException) {
                            return measures;
                        }
                        measures.add("NA");
                    }
                }
                return measures;
            }
        };
    }

    @Deprecated
    public static double[] computeEllipseDimensions(ROI roi) throws InterruptedException {
        double[] ellipse = ROIEllipsoidFittingDescriptor.computeOrientation(roi, null);
        return new double[]{ellipse[0], ellipse[1], ellipse[2]};
    }

    @Deprecated
    public static double computeSphericity(ROI roi) {
        return ROISphericityDescriptor.ROISphericity.computeSphericity(roi);
    }

    @Deprecated
    public static double computeRoundness(ROI roi) throws InterruptedException {
        return ROIRoundnessDescriptor.ROIRoundness.computeRoundness(roi);
    }

    @Deprecated
    public static double computeMaxFeret(ROI roi) {
        return ROIFeretDiameterDescriptor.ROIFeretDiameter.computeFeretDiameter(roi, null);
    }

    @Deprecated
    public static double computeConvexity(ROI roi) {
        return ROIConvexHullDescriptor.ROIConvexity.computeConvexity(roi);
    }

    @Deprecated
    public static double[] computeHullDimensions(ROI roi) {
        ROI convexHull = Convexify.createConvexROI((ROI)roi);
        return new double[]{convexHull.getNumberOfContourPoints(), convexHull.getNumberOfPoints()};
    }

    @Deprecated
    public static Point5D getMassCenter(ROI roi) throws InterruptedException {
        return ROIMassCenterDescriptorsPlugin.computeMassCenter((ROI)roi);
    }

    @Deprecated
    public static Point2D getMassCenter(ROI2D roi) throws InterruptedException {
        return ROIMeasures.getMassCenter((ROI)roi).toPoint2D();
    }

    @Deprecated
    public static Point3D getMassCenter(ROI3D roi) throws InterruptedException {
        return ROIMeasures.getMassCenter((ROI)roi).toPoint3D();
    }

    public void sequenceOpened(Sequence openedSequence) {
        openedSequence.addListener((SequenceListener)this);
        for (ROI roi : openedSequence.getROIs()) {
            roi.addListener((ROIListener)this);
        }
        this.updateStatistics(openedSequence);
        this.book.valueChanged((Var)this.book, null, this.book.getValue());
    }

    public void sequenceClosed(Sequence closedSequence) {
        closedSequence.removeListener((SequenceListener)this);
        for (ROI roi : closedSequence.getROIs()) {
            roi.removeListener((ROIListener)this);
        }
        String sheetName = this.getSheetName(closedSequence);
        int index = ((Workbook)this.book.getValue()).getSheetIndex(sheetName);
        if (index >= 0) {
            ((Workbook)this.book.getValue()).removeSheetAt(index);
            this.book.valueChanged((Var)this.book, null, this.book.getValue());
        }
    }

    public void sequenceChanged(SequenceEvent sequenceEvent) {
        if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_DATA) {
            this.updateStatistics(sequenceEvent.getSequence());
        } else if (sequenceEvent.getSourceType() == SequenceEvent.SequenceEventSourceType.SEQUENCE_ROI) {
            ROI roi = (ROI)sequenceEvent.getSource();
            switch (sequenceEvent.getType()) {
                case ADDED: {
                    if (roi == null) {
                        this.updateStatistics();
                        break;
                    }
                    for (Sequence sequenceOfInterest : roi.getSequences()) {
                        this.updateStatistics(sequenceOfInterest);
                    }
                    roi.removeListener((ROIListener)this);
                    roi.addListener((ROIListener)this);
                    break;
                }
                case REMOVED: {
                    if (roi == null) {
                        System.err.println("[ROI Statistics] Warning: potential memory leak");
                    } else {
                        roi.removeListener((ROIListener)this);
                    }
                    this.updateStatistics();
                    break;
                }
            }
        }
    }

    public void clean() {
        MeasureSelector selectorGui = this.measureSelector.gui;
        if (selectorGui != null) {
            selectorGui.selector.close();
        }
        for (Sequence openedSequence : Icy.getMainInterface().getSequences()) {
            openedSequence.removeListener((SequenceListener)this);
        }
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this);
        this.cpus.shutdownNow();
    }

    public void roiChanged(ROIEvent event) {
        if (event.getType() == ROIEvent.ROIEventType.ROI_CHANGED || event.getType() == ROIEvent.ROIEventType.PROPERTY_CHANGED && (event.getPropertyName().equalsIgnoreCase("name") || event.getPropertyName().equalsIgnoreCase("color"))) {
            this.updateStatistics(event.getSource());
            this.book.valueChanged((Var)this.book, null, this.book.getValue());
        }
    }

    public static void main(String[] args) {
        Icy.main((String[])args);
        PluginLauncher.start((PluginDescriptor)PluginLoader.getPlugin((String)ROIMeasures.class.getName()));
    }

    private class MeasureSelector
    implements VarMeasureSelectorListener {
        final EzDialog selector;
        final JCheckBox[] checkBoxes;

        public MeasureSelector() {
            if (Icy.getMainInterface().isHeadLess()) {
                this.selector = null;
                this.checkBoxes = null;
            } else {
                Measures[] measures = Measures.getOrderedById();
                this.selector = new EzDialog("Select measures...");
                this.selector.setLayout((LayoutManager)new BoxLayout(this.selector.getContentPane(), 1));
                this.checkBoxes = new JCheckBox[measures.length];
                for (int i = 0; i < measures.length; ++i) {
                    final Measures measure = measures[i];
                    String name = measure.toString();
                    final JCheckBox check = new JCheckBox(name, measure.isSelected());
                    check.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            measure.setSelected(check.isSelected());
                            ROIMeasures.this.measureSelectionChanged = true;
                        }
                    });
                    this.checkBoxes[i] = check;
                    this.selector.addComponent((Component)check);
                    if ((i + 1) % 16 != 0) continue;
                    this.selector.addComponent((Component)new JSeparator(1));
                }
            }
        }

        public void loadParameters(VarMeasureSelector source) {
            if (source != null) {
                final Measures[] measures = Measures.getOrderedById();
                long value = source.getValue();
                for (int i = 0; i < Math.min(measures.length, 64); ++i) {
                    boolean selected = (value & 1L << i) != 0L;
                    measures[i].setSelected(selected);
                    if (this.checkBoxes == null || this.checkBoxes[i].isSelected() == selected) continue;
                    this.checkBoxes[i].setSelected(selected);
                }
                if (this.checkBoxes != null) {
                    ThreadUtil.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < measures.length; ++i) {
                                boolean selected = measures[i].isSelected();
                                if (MeasureSelector.this.checkBoxes[i].isSelected() == selected) continue;
                                MeasureSelector.this.checkBoxes[i].setSelected(selected);
                            }
                        }
                    });
                }
            }
        }

        public void saveParameters(VarMeasureSelector source) {
            if (source != null) {
                Measures[] measures = Measures.getOrderedById();
                long value = 0L;
                for (int i = 0; i < Math.min(this.checkBoxes.length, 64); ++i) {
                    if (!measures[i].isSelected()) continue;
                    value |= 1L << i;
                }
                source.setValue(value);
            }
        }

        @Override
        public void triggered(VarMeasureSelector source) {
            if (Icy.getMainInterface().isHeadLess()) {
                return;
            }
            this.loadParameters(source);
            this.selector.pack();
            this.selector.showDialog(true);
            this.saveParameters(source);
            if (!ROIMeasures.this.isHeadLess() && ROIMeasures.this.measureSelectionChanged) {
                XMLPreferences prefs = ROIMeasures.this.getPreferences("measures");
                for (Measures measure : Measures.values()) {
                    prefs.node(measure.name()).putBoolean("selected", measure.isSelected());
                }
                ROIMeasures.this.book.setValue(null);
                ROIMeasures.this.execute();
            }
        }

        public void valueChanged(Var<Long> source, Long oldValue, Long newValue) {
            this.loadParameters((VarMeasureSelector)source);
        }

        public void referenceChanged(Var<Long> source, Var<? extends Long> oldReference, Var<? extends Long> newReference) {
        }
    }

    private static class VarMeasureSelector
    extends VarLong {
        final MeasureSelector gui;

        public VarMeasureSelector(MeasureSelector gui) {
            super("Select features...", -1L);
            this.gui = gui;
            if (gui != null) {
                this.addListener(gui);
            }
        }

        public VarEditor<Long> createVarEditor() {
            return new ButtonVarEditor(this);
        }

        public void trigger() {
            for (VarListener listener : this.listeners) {
                if (!(listener instanceof VarMeasureSelectorListener)) continue;
                ((VarMeasureSelectorListener)listener).triggered(this);
            }
        }
    }

    private static class ButtonVarEditor
    extends SwingVarEditor<Long> {
        private ActionListener listener;

        public ButtonVarEditor(VarMeasureSelector variable) {
            super((Var)variable);
            this.setNameVisible(false);
        }

        protected JButton createEditorComponent() {
            if (this.getEditorComponent() != null) {
                this.deactivateListeners();
            }
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((VarMeasureSelector)variable).trigger();
                }
            };
            return new JButton(this.variable.getName());
        }

        public JButton getEditorComponent() {
            return (JButton)super.getEditorComponent();
        }

        public double getComponentVerticalResizeFactor() {
            return 0.0;
        }

        protected void activateListeners() {
            this.getEditorComponent().addActionListener(this.listener);
        }

        protected void deactivateListeners() {
            this.getEditorComponent().removeActionListener(this.listener);
        }

        protected void updateInterfaceValue() {
        }
    }

    private static interface VarMeasureSelectorListener
    extends VarListener<Long> {
        public void triggered(VarMeasureSelector var1);
    }

    public static enum Measures {
        FULLPATH("Full path", 0, null),
        FOLDER("Folder", 1, null),
        DATASET("Dataset", 2, null),
        NAME("Name", 3, null),
        COLOR("Color", 4, null),
        POSITION_X("Position X", 43, "px"),
        POSITION_Y("Position Y", 44, "px"),
        POSITION_Z("Position Z", 45, "px"),
        POSITION_T("Position T", 46, null),
        POSITION_C("Position C", 47, null),
        SIZE_X("Size X", 13, "px"),
        SIZE_Y("Size Y", 14, "px"),
        SIZE_Z("Size Z", 15, "px"),
        SIZE_T("Size T", 48, null),
        SIZE_C("Size C", 49, null),
        X_CENTER("Center X", 5, "px"),
        Y_CENTER("Center Y", 6, "px"),
        Z_CENTER("Center Z", 7, "px"),
        T_CENTER("Center T", 8, null),
        C_CENTER("Center C", 9, null),
        X_GLOBAL_CENTER("Global center X", 10, "px"),
        Y_GLOBAL_CENTER("Global center Y", 11, "px"),
        Z_GLOBAL_CENTER("Global center Z", 12, "px"),
        CONTOUR("Contour", 16, "px"),
        INTERIOR("Interior", 17, "px"),
        SPHERICITY("Sphericity", 18, null),
        ROUNDNESS("Roundness", 19, "%"),
        CONVEXITY("Convexity", 20, "%"),
        MAX_FERET("Max Feret diameter", 21, "um"),
        ELLIPSE_A("1st Diameter", 22, "um"),
        ELLIPSE_B("2nd Diameter", 23, "um"),
        ELLIPSE_C("3rd Diameter", 24, "um"),
        YAW("Yaw", 25, "\u00b0"),
        PITCH("Pitch", 26, "\u00b0"),
        ROLL("Roll", 27, "\u00b0"),
        ELONGATION("Elongation", 28, null),
        FLATNESS3D("Flatness3D", 29, null),
        INTENSITY_MIN("Min Intensity", 30, null),
        INTENSITY_AVG("Mean Intensity", 31, null),
        INTENSITY_MAX("Max Intensity", 32, null),
        INTENSITY_SUM("Sum Intensity", 33, null),
        INTENSITY_STD("Standard Deviation", 34, null),
        INTENSITY_TEXTURE_ASM("Texture angular second moment", 35, null),
        INTENSITY_TEXTURE_CONT("Texture contrast", 36, null),
        INTENSITY_TEXTURE_ENT("Texture entropy", 37, null),
        INTENSITY_TEXTURE_HOMO("Texture homogeneity", 38, null),
        PERIMETER("Perimeter", 39, "um"),
        AREA("Area", 40, "um2"),
        SURFACE_AREA("Surface Area", 41, "um2"),
        VOLUME("Volume", 42, "um3"),
        INTENSITY_X("Intensity center X", 50, "px"),
        INTENSITY_Y("Intensity center Y", 51, "px"),
        INTENSITY_Z("Intensity center Z", 52, "px");

        final String name;
        final int id;
        final String unit;
        boolean selected = true;
        private static Measures[] orderedById;

        private Measures(String name, int id, String unit) {
            this.name = name;
            this.id = id;
            this.unit = unit;
        }

        public void toggleSelection() {
            this.selected = !this.selected;
        }

        public void setSelected(boolean value) {
            this.selected = value;
        }

        public String toString() {
            return this.name;
        }

        public String toHeader() {
            return this.name + (this.hasUnit() ? " (" + this.getUnit() + ")" : "");
        }

        public boolean hasUnit() {
            return this.unit != null && !this.unit.isEmpty();
        }

        public String getUnit() {
            return this.unit;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public int getColumnIndex() {
            if (!this.isSelected()) {
                return -1;
            }
            Measures[] allMeasures = Measures.values();
            int deselectedMeasures = 0;
            for (int i = 0; i < allMeasures.length; ++i) {
                if (allMeasures[i] == this) {
                    return i - deselectedMeasures;
                }
                if (allMeasures[i].isSelected()) continue;
                ++deselectedMeasures;
            }
            return -1;
        }

        public static Measures getMeasureById(int id) {
            return Measures.getOrderedById()[id];
        }

        public static Measures[] getOrderedById() {
            if (orderedById == null) {
                Measures.orderMeasures();
            }
            return orderedById;
        }

        private static void orderMeasures() {
            List<Measures> orderedMeasures = Arrays.asList(Measures.values());
            Collections.sort(orderedMeasures, new Comparator<Measures>(){

                @Override
                public int compare(Measures o1, Measures o2) {
                    return Integer.compare(o1.id, o2.id);
                }
            });
            orderedById = orderedMeasures.toArray(new Measures[0]);
        }
    }
}

