/*
 * Decompiled with CFR 0.152.
 */
package plugins.fab.spotDetector.filtering;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.JPanel;

public class IntervalSlider
extends JPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 5897728258613197422L;
    int min;
    int max;
    int currentLowValue;
    int currentHighValue;
    DRAGGING draggingState = DRAGGING.NOT_DRAGGING;
    DRAGGING displayMoveState = DRAGGING.NOT_DRAGGING;
    ArrayList<ActionListener> actionListenerList = new ArrayList();

    public IntervalSlider(int min, int max) {
        this.setPreferredSize(new Dimension(0, 20));
        this.min = min;
        this.max = max;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public IntervalSlider(int min, int max, int lowValue, int highValue) {
        this(min, max);
        this.currentLowValue = lowValue;
        this.currentHighValue = highValue;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.black);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        double lowx = this.getXForValue(this.currentLowValue);
        double highx = this.getXForValue(this.currentHighValue);
        g.setColor(Color.gray);
        g.fill3DRect((int)lowx - 1, 1, (int)(highx - lowx) + 1, this.getHeight() - 2, true);
        g.setColor(Color.lightGray);
        g.fillOval((int)((highx + lowx) / 2.0) - 3, 4, 10, 10);
        if (this.draggingState == DRAGGING.LOW || this.displayMoveState == DRAGGING.LOW) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.lightGray);
        }
        g.drawRect((int)lowx - 1, 1, 1, this.getHeight() - 3);
        g.drawRect((int)lowx - 1, 1, 5, 1);
        g.drawRect((int)lowx - 1, this.getHeight() - 3, 5, 1);
        if (this.draggingState == DRAGGING.HIGH || this.displayMoveState == DRAGGING.HIGH) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.lightGray);
        }
        g.drawRect((int)highx - 1, 1, 1, this.getHeight() - 3);
        g.drawRect((int)highx - 6, 1, 5, 1);
        g.drawRect((int)highx - 6, this.getHeight() - 3, 5, 1);
        if (this.draggingState == DRAGGING.ALL || this.displayMoveState == DRAGGING.ALL) {
            g.setColor(Color.yellow);
            g.drawRect((int)lowx - 1, 1, 1, this.getHeight() - 3);
            g.drawRect((int)lowx - 1, 1, 5, 1);
            g.drawRect((int)lowx - 1, this.getHeight() - 3, 5, 1);
            g.drawRect((int)highx - 1, 1, 1, this.getHeight() - 3);
            g.drawRect((int)highx - 6, 1, 5, 1);
            g.drawRect((int)highx - 6, this.getHeight() - 3, 5, 1);
            g.fillOval((int)((highx + lowx) / 2.0) - 3, 4, 10, 10);
        }
    }

    private double getXForValue(double value) {
        double pxVal = (double)this.getWidth() / (double)(this.max - this.min);
        double result = (value - (double)this.min) * pxVal;
        return result;
    }

    private double getValueForX(double x) {
        double pxVal = (double)(this.max - this.min) / (double)this.getWidth();
        double result = x * pxVal + (double)this.min;
        return result;
    }

    public void setCurrentLowValue(int value) {
        if (value <= this.currentHighValue) {
            this.currentLowValue = value;
            this.repaint();
            this.fireAction();
        }
    }

    public void setCurrentHighValue(int value) {
        if (value >= this.currentLowValue) {
            System.out.println(value);
            this.currentHighValue = value;
            this.repaint();
            this.fireAction();
        }
    }

    public int getCurrentLowValue() {
        this.repaint();
        return this.currentLowValue;
    }

    public int getCurrentHighValue() {
        this.repaint();
        return this.currentHighValue;
    }

    DRAGGING computeDraggingState(MouseEvent e) {
        DRAGGING draggingResult = this.draggingState;
        if (draggingResult == DRAGGING.NOT_DRAGGING) {
            double mouseX;
            double centerValue;
            double centerX;
            double xVal = this.getValueForX(e.getX());
            draggingResult = Math.abs(xVal - (double)this.currentLowValue) < Math.abs(xVal - (double)this.currentHighValue) ? DRAGGING.LOW : DRAGGING.HIGH;
            if (xVal > (double)this.currentLowValue && xVal < (double)this.currentHighValue && Math.abs((centerX = this.getXForValue(centerValue = (double)((this.currentLowValue + this.currentHighValue) / 2))) - (mouseX = (double)e.getX())) < 10.0) {
                draggingResult = DRAGGING.ALL;
            }
        }
        return draggingResult;
    }

    private void updateBounds(MouseEvent e) {
        this.draggingState = this.computeDraggingState(e);
        double mouseX = e.getX();
        if (this.draggingState == DRAGGING.LOW) {
            this.currentLowValue = (int)this.getValueForX(mouseX);
            if (this.currentLowValue > this.currentHighValue) {
                this.currentLowValue = this.currentHighValue;
            }
        }
        if (this.draggingState == DRAGGING.HIGH) {
            this.currentHighValue = (int)this.getValueForX(mouseX);
            if (this.currentHighValue < this.currentLowValue) {
                this.currentHighValue = this.currentLowValue;
            }
        }
        if (this.draggingState == DRAGGING.ALL) {
            double currentInterval = this.currentHighValue - this.currentLowValue;
            double centerValue = (int)this.getValueForX(mouseX);
            this.currentLowValue = (int)(centerValue - currentInterval / 2.0);
            this.currentHighValue = (int)(centerValue + currentInterval / 2.0);
            if (this.currentHighValue > this.max) {
                this.currentLowValue -= this.currentHighValue - this.max;
            }
            if (this.currentLowValue < this.min) {
                this.currentHighValue += this.min - this.currentLowValue;
            }
        }
        if (this.currentLowValue < this.min) {
            this.currentLowValue = this.min;
        }
        if (this.currentHighValue > this.max) {
            this.currentHighValue = this.max;
        }
        this.repaint();
        this.fireAction();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList.remove(actionListener);
    }

    private void fireAction() {
        for (ActionListener al : this.actionListenerList) {
            al.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.updateBounds(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.displayMoveState = DRAGGING.NOT_DRAGGING;
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.draggingState = DRAGGING.NOT_DRAGGING;
        this.updateBounds(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggingState = DRAGGING.NOT_DRAGGING;
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.draggingState = this.computeDraggingState(e);
        this.updateBounds(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.displayMoveState = this.computeDraggingState(e);
        this.repaint();
    }

    static enum DRAGGING {
        NOT_DRAGGING,
        LOW,
        HIGH,
        ALL;

    }
}

