/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Short1D;
import mitiv.array.ShortScalar;
import mitiv.array.impl.Helper;
import mitiv.array.impl.SelectedShort1D;
import mitiv.base.indexing.CompiledRange;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.ShortFunction;
import mitiv.base.mapping.ShortScanner;
import mitiv.random.ShortGenerator;

public class StriddenShort1D
extends Short1D {
    final int order;
    final short[] data;
    final int offset;
    final int stride1;
    final boolean flat;

    public StriddenShort1D(short[] arr, int offset, int[] stride, int[] dims) {
        super(dims);
        if (stride.length != 1) {
            throw new IllegalArgumentException("There must be as many strides as the rank");
        }
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride[0];
        this.order = Short1D.checkViewStrides(this.data.length, offset, this.stride1, this.dim1);
        this.flat = offset == 0 && this.stride1 == 1;
    }

    public StriddenShort1D(short[] arr, int offset, int stride1, int dim1) {
        super(dim1);
        this.data = arr;
        this.offset = offset;
        this.stride1 = stride1;
        this.order = Short1D.checkViewStrides(this.data.length, offset, stride1, dim1);
        this.flat = offset == 0 && stride1 == 1;
    }

    @Override
    public void checkSanity() {
        Short1D.checkViewStrides(this.data.length, this.offset, this.stride1, this.dim1);
    }

    final int index(int i1) {
        return this.offset + this.stride1 * i1;
    }

    @Override
    public final short get(int i1) {
        return this.data[this.offset + this.stride1 * i1];
    }

    @Override
    public final void set(int i1, short value) {
        this.data[this.offset + this.stride1 * i1] = value;
    }

    @Override
    public final int getOrder() {
        return this.order;
    }

    @Override
    public void fill(short value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = value;
        }
    }

    @Override
    public void fill(ShortGenerator generator) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = generator.nextShort();
        }
    }

    @Override
    public void increment(short value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = (short)(this.data[n] + value);
        }
    }

    @Override
    public void decrement(short value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = (short)(this.data[n] - value);
        }
    }

    @Override
    public void scale(short value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.stride1 * i1 + this.offset;
            this.data[n] = (short)(this.data[n] * value);
        }
    }

    @Override
    public void map(ShortFunction function) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            this.data[j1] = function.apply(this.data[j1]);
        }
    }

    @Override
    public void scan(ShortScanner scanner) {
        boolean initialized = false;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.stride1 * i1 + this.offset;
            if (initialized) {
                scanner.update(this.data[j1]);
                continue;
            }
            scanner.initialize(this.data[j1]);
            initialized = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return this.flat;
    }

    @Override
    public short[] flatten(boolean forceCopy) {
        if (!forceCopy && this.flat) {
            return this.data;
        }
        short[] out = new short[this.number];
        if (this.flat) {
            System.arraycopy(this.data, 0, out, 0, this.number);
        } else {
            int j = -1;
            for (int i1 = 0; i1 < this.dim1; ++i1) {
                int j1 = this.stride1 * i1 + this.offset;
                out[++j] = this.data[j1];
            }
        }
        return out;
    }

    @Override
    public short[] getData() {
        return this.flat ? this.data : null;
    }

    @Override
    public ShortScalar slice(int idx) {
        return new ShortScalar(this.data, this.offset + this.stride1 * idx);
    }

    @Override
    public ShortScalar slice(int idx, int dim) {
        if (dim < 0) {
            ++dim;
        }
        if (dim != 0) {
            throw new IndexOutOfBoundsException("Dimension index out of bounds");
        }
        int sliceOffset = this.offset + this.stride1 * idx;
        return new ShortScalar(this.data, sliceOffset);
    }

    @Override
    public Short1D view(Range rng1) {
        CompiledRange cr1 = new CompiledRange(rng1, this.dim1, this.offset, this.stride1);
        if (cr1.doesNothing()) {
            return this;
        }
        return new StriddenShort1D(this.data, cr1.getOffset(), cr1.getStride(), cr1.getNumber());
    }

    @Override
    public Short1D view(int[] sel1) {
        int[] idx1 = Helper.select(this.offset, this.stride1, this.dim1, sel1);
        return new SelectedShort1D(this.data, idx1);
    }

    @Override
    public Short1D as1D() {
        return this;
    }
}

