/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.ezplug;

import icy.system.thread.ThreadUtil;
import java.awt.Container;
import javax.swing.SwingUtilities;
import plugins.adufour.ezplug.EzDialog;
import plugins.adufour.ezplug.EzGroup;
import plugins.adufour.ezplug.EzPanel;

public abstract class EzComponent {
    public final String name;
    protected boolean visible = true;
    private EzDialog gui;
    private EzPanel parent = null;

    protected EzComponent(String name) {
        this.name = name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Deprecated
    public boolean getVisible() {
        return this.isVisible();
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    void addToContainer(final Container container) {
        if (!this.visible) {
            return;
        }
        ThreadUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                EzComponent.this.addTo(container);
            }
        }, (!SwingUtilities.isEventDispatchThread() ? 1 : 0) != 0);
    }

    protected abstract void addTo(Container var1);

    final EzDialog getUI() {
        return this.gui;
    }

    final void setUI(EzDialog ezDialog) {
        this.gui = ezDialog;
    }

    @Deprecated
    protected final EzGroup getGroup() {
        return (EzGroup)this.parent;
    }

    protected EzPanel getParentPanel() {
        return this.parent;
    }

    @Deprecated
    protected void setGroup(EzGroup group) throws IllegalArgumentException {
        this.setParentPanel(group);
    }

    protected void setParentPanel(EzPanel parent) {
        if (this.parent != null && parent != null) {
            throw new IllegalArgumentException("component " + this.name + " already belongs to group " + parent.name);
        }
        this.parent = parent;
    }

    public abstract void setToolTipText(String var1);

    protected void dispose() {
        this.gui = null;
        this.parent = null;
    }
}

