/*
 * Decompiled with CFR 0.152.
 */
package mitiv.array.impl;

import mitiv.array.Long1D;
import mitiv.array.LongScalar;
import mitiv.array.impl.Helper;
import mitiv.base.indexing.Range;
import mitiv.base.mapping.LongFunction;
import mitiv.base.mapping.LongScanner;
import mitiv.random.LongGenerator;

public class SelectedLong1D
extends Long1D {
    static final int order = 0;
    final long[] data;
    final int[] idx1;

    public SelectedLong1D(long[] arr, int[] idx1) {
        super(idx1.length);
        this.data = arr;
        this.idx1 = idx1;
    }

    @Override
    public final void checkSanity() {
        int indexMax;
        int offsetMin = 0;
        int offsetMax = 0;
        int indexMin = indexMax = this.idx1[0];
        for (int i1 = 1; i1 < this.dim1; ++i1) {
            int index = this.idx1[i1];
            if (index < indexMin) {
                indexMin = index;
            }
            if (index <= indexMax) continue;
            indexMax = index;
        }
        if ((offsetMin += indexMin) < 0 || (offsetMax += indexMax) >= this.data.length) {
            throw new IndexOutOfBoundsException("Selected indices are out of bounds");
        }
    }

    final int index(int i1) {
        return this.idx1[i1];
    }

    @Override
    public final long get(int i1) {
        return this.data[this.idx1[i1]];
    }

    @Override
    public final void set(int i1, long value) {
        this.data[this.idx1[i1]] = value;
    }

    @Override
    public final int getOrder() {
        return 0;
    }

    @Override
    public void fill(long value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = value;
        }
    }

    @Override
    public void fill(LongGenerator generator) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = generator.nextLong();
        }
    }

    @Override
    public void increment(long value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] + value;
        }
    }

    @Override
    public void decrement(long value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] - value;
        }
    }

    @Override
    public void scale(long value) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1;
            int n = j1 = this.idx1[i1];
            this.data[n] = this.data[n] * value;
        }
    }

    @Override
    public void map(LongFunction function) {
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            this.data[j1] = function.apply(this.data[j1]);
        }
    }

    @Override
    public void scan(LongScanner scanner) {
        boolean initialized = false;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            if (initialized) {
                scanner.update(this.data[j1]);
                continue;
            }
            scanner.initialize(this.data[j1]);
            initialized = true;
        }
    }

    @Override
    public final boolean isFlat() {
        return false;
    }

    @Override
    public long[] flatten(boolean forceCopy) {
        long[] out = new long[this.number];
        int j = -1;
        for (int i1 = 0; i1 < this.dim1; ++i1) {
            int j1 = this.idx1[i1];
            out[++j] = this.data[j1];
        }
        return out;
    }

    @Override
    public long[] getData() {
        return null;
    }

    @Override
    public LongScalar slice(int idx) {
        return new LongScalar(this.data, this.idx1[Helper.fixIndex(idx, this.dim1)]);
    }

    @Override
    public LongScalar slice(int idx, int dim) {
        Helper.fixSliceIndex(dim, 1);
        return new LongScalar(this.data, Helper.fixIndex(idx, this.dim1));
    }

    @Override
    public Long1D view(Range rng1) {
        int[] viewIndex1 = Helper.select(this.idx1, rng1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedLong1D(this.data, viewIndex1);
    }

    @Override
    public Long1D view(int[] sel1) {
        int[] viewIndex1 = Helper.select(this.idx1, sel1);
        if (viewIndex1 == this.idx1) {
            return this;
        }
        return new SelectedLong1D(this.data, viewIndex1);
    }

    @Override
    public Long1D as1D() {
        return this;
    }
}

