/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.icon.EmptyResizableIcon;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.BandControlPanelUI;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

abstract class AbstractBandControlPanelUI
extends BandControlPanelUI {
    protected AbstractBandControlPanel controlPanel;
    protected JCommandButton dummy;
    protected int layoutGap = 4;
    public static final String TOP_ROW = "flamingo.internal.ribbonBandControlPanel.topRow";
    public static final String MID_ROW = "flamingo.internal.ribbonBandControlPanel.midRow";
    public static final String BOTTOM_ROW = "flamingo.internal.ribbonBandControlPanel.bottomRow";

    AbstractBandControlPanelUI() {
    }

    @Override
    public void installUI(JComponent c) {
        this.controlPanel = (AbstractBandControlPanel)c;
        this.dummy = new JCommandButton("Dummy", new EmptyResizableIcon(16));
        this.dummy.setDisplayState(CommandButtonDisplayState.BIG);
        this.dummy.setCommandButtonKind(JCommandButton.CommandButtonKind.ACTION_AND_POPUP_MAIN_ACTION);
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        c.setLayout(this.createLayoutManager());
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        c.setLayout(null);
        this.controlPanel = null;
    }

    protected void installListeners() {
    }

    protected void uninstallListeners() {
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installDefaults() {
        Border b;
        Color bg = this.controlPanel.getBackground();
        if (bg == null || bg instanceof UIResource) {
            this.controlPanel.setBackground(FlamingoUtilities.getColor(Color.lightGray, "ControlPanel.background", "Panel.background"));
        }
        if ((b = this.controlPanel.getBorder()) == null || b instanceof UIResource) {
            Border toSet = UIManager.getBorder("ControlPanel.border");
            if (toSet == null) {
                new BorderUIResource.EmptyBorderUIResource(1, 2, 1, 2);
            }
            this.controlPanel.setBorder(toSet);
        }
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.controlPanel);
    }

    protected abstract LayoutManager createLayoutManager();

    @Override
    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.paintBandBackground(graphics, new Rectangle(0, 0, c.getWidth(), c.getHeight()));
        graphics.dispose();
    }

    protected void paintBandBackground(Graphics graphics, Rectangle toFill) {
        graphics.setColor(this.controlPanel.getBackground());
        graphics.fillRect(toFill.x, toFill.y, toFill.width, toFill.height);
    }

    public void setLayoutGap(int value) {
        this.layoutGap = value;
    }

    @Override
    public int getLayoutGap() {
        return this.layoutGap;
    }
}

