/*
 * Decompiled with CFR 0.152.
 */
package plugins.adufour.protocols.gui.link;

import icy.system.SystemUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import plugins.adufour.blocks.lang.BlockDescriptor;
import plugins.adufour.blocks.lang.WorkFlow;
import plugins.adufour.protocols.gui.link.DragDropZone;
import plugins.adufour.protocols.gui.link.TransferableVar;
import plugins.adufour.vars.lang.Var;

class DropZone<T>
extends DragDropZone
implements ActionListener,
DropTargetListener {
    private final DropTarget dropTarget;
    private final JPopupMenu errorPopup = new JPopupMenu();
    private final WorkFlow workFlow;
    private final BlockDescriptor dstBlock;
    private final Var<T> dstVar;

    DropZone(Image image, WorkFlow workFlow, BlockDescriptor dstBlock, Var<T> dstVar) {
        super("Drop a variable here to create a link\nLeft-click: remove link (if any)", image, dstVar);
        this.addActionListener(this);
        this.dropTarget = new DropTarget(this, 0x40000000, this, true);
        this.dstBlock = dstBlock;
        this.workFlow = workFlow;
        this.dstVar = dstVar;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dstVar.getReference() == null) {
            return;
        }
        this.workFlow.removeLink(this.dstVar);
        this.setDefaultLinkIcon();
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.checkDrag(e);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.errorPopup.setVisible(false);
        this.errorPopup.removeAll();
        this.setDefaultLinkIcon();
    }

    private void checkDrag(DropTargetDragEvent e) {
        block4: {
            try {
                TransferableVar transfer = (TransferableVar)e.getTransferable().getTransferData(TransferableVar.varFlavor);
                this.workFlow.checkLink(transfer.getSrcBlock(), transfer.getSrcVar(), this.dstBlock, this.dstVar);
                e.acceptDrag(0x40000000);
            }
            catch (Exception exception) {
                this.setErrorLinkIcon();
                e.rejectDrag();
                if (!this.errorPopup.isVisible()) {
                    this.errorPopup.add(new JLabel("<html><h4>" + exception.getLocalizedMessage().replace("\n", "<br/>") + "</h4></html>"));
                    Point location = this.getLocationOnScreen();
                    this.errorPopup.setLocation(location.x + 10, location.y + 20);
                    this.errorPopup.setVisible(true);
                }
            }
            catch (Error error) {
                this.setErrorLinkIcon();
                e.rejectDrag();
                if (this.errorPopup.isVisible()) break block4;
                this.errorPopup.add(new JLabel("<html><h4>" + error.getClass().getSimpleName() + ": " + error.getLocalizedMessage().replace("\n", "<br/>") + "</h4></html>"));
                Point location = this.getLocationOnScreen();
                this.errorPopup.setLocation(location.x + 10, location.y + 20);
                this.errorPopup.setVisible(true);
                error.printStackTrace();
            }
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            TransferableVar transfer = (TransferableVar)e.getTransferable().getTransferData(TransferableVar.varFlavor);
            if (this.dstVar.getReference() != null) {
                this.workFlow.removeLink(this.dstVar);
            }
            this.workFlow.addLink(transfer.getSrcBlock(), transfer.getSrcVar(), this.dstBlock, this.dstVar);
            e.dropComplete(true);
        }
        catch (Exception e1) {
            JOptionPane.showMessageDialog(null, e1.getMessage() + "\n(stack trace will be sent to the console)", "Error", 0);
            e1.printStackTrace();
            e.dropComplete(false);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeActionListener(this);
        this.dropTarget.removeDropTargetListener(this);
        this.dropTarget.setComponent(null);
        if (SystemUtil.getJavaVersionAsNumber() < 10.0) {
            this.dropTarget.getDropTargetContext().removeNotify();
        }
    }
}

