/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.gui.frame.progress.ProgressFrame;
import icy.main.Icy;
import icy.resource.icon.IcyIcon;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.pushingpixels.flamingo.api.common.RichTooltip;

public abstract class IcyAbstractAction
extends AbstractAction {
    private static final long serialVersionUID = -8544059445777661407L;
    private static final int DEFAULT_ICON_SIZE = 20;
    public static final String ENABLED_KEY = "enabled";
    protected boolean bgProcess;
    protected boolean processing;
    protected String processMessage;
    protected ProgressFrame progressFrame;

    public static void setToolTipTextFromAction(JComponent c, Action a) {
        if (a != null) {
            String longDesc = (String)a.getValue("LongDescription");
            String shortDesc = (String)a.getValue("ShortDescription");
            if (StringUtil.isEmpty(longDesc)) {
                c.setToolTipText(shortDesc);
            } else {
                c.setToolTipText(longDesc);
            }
        }
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, String longDescription, int keyCode, int modifiers, boolean bgProcess, String processMessage) {
        super(name, (Icon)((Object)icon));
        this.putValue("ActionCommandKey", name);
        if (keyCode != 0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keyCode, modifiers));
        }
        if (!StringUtil.isEmpty(description)) {
            this.putValue("ShortDescription", description);
        }
        if (!StringUtil.isEmpty(longDescription)) {
            this.putValue("LongDescription", longDescription);
        }
        this.bgProcess = bgProcess;
        this.processMessage = processMessage;
        this.progressFrame = null;
        this.processing = false;
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, String longDescription, int keyCode, int modifiers) {
        this(name, icon, description, longDescription, keyCode, modifiers, false, null);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, String longDescription, boolean bgProcess, String processMessage) {
        this(name, icon, description, longDescription, 0, 0, bgProcess, processMessage);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, boolean bgProcess, String processMessage) {
        this(name, icon, description, null, 0, 0, bgProcess, processMessage);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, int keyCode, int modifiers) {
        this(name, icon, description, null, keyCode, modifiers, false, null);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, int keyCode) {
        this(name, icon, description, null, keyCode, 0, false, null);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description, String longDescription) {
        this(name, icon, description, longDescription, 0, 0, false, null);
    }

    public IcyAbstractAction(String name, IcyIcon icon, String description) {
        this(name, icon, description, null, 0, 0, false, null);
    }

    public IcyAbstractAction(String name, IcyIcon icon) {
        this(name, icon, null, null, 0, 0, false, null);
    }

    public IcyAbstractAction(String name) {
        this(name, null, null, null, 0, 0, false, null);
    }

    @Deprecated
    public IcyAbstractAction(String name, String iconName, String description, int keyCode, int modifiers) {
        this(name, new IcyIcon(iconName, 20), description, null, keyCode, modifiers, false, null);
    }

    @Deprecated
    public IcyAbstractAction(String name, String iconName, String description, int keyCode) {
        this(name, new IcyIcon(iconName, 20), description, null, keyCode, 0, false, null);
    }

    @Deprecated
    public IcyAbstractAction(String name, String iconName, String description) {
        this(name, new IcyIcon(iconName, 20), description, null, 0, 0, false, null);
    }

    @Deprecated
    public IcyAbstractAction(String name, String iconName) {
        this(name, new IcyIcon(iconName, 20), null, null, 0, 0, false, null);
    }

    public boolean isBgProcess() {
        return this.bgProcess;
    }

    public void setBgProcess(boolean bgProcess) {
        this.bgProcess = bgProcess;
    }

    public String getProcessMessage() {
        return this.processMessage;
    }

    public RichTooltip getRichToolTip() {
        String desc = this.getDescription();
        String longDesc = this.getLongDescription();
        IcyIcon icon = this.getIcon();
        if (StringUtil.isEmpty(desc) && StringUtil.isEmpty(longDesc)) {
            return null;
        }
        RichTooltip result = new RichTooltip();
        if (!StringUtil.isEmpty(desc)) {
            result.setTitle(desc);
        }
        if (!StringUtil.isEmpty(longDesc)) {
            for (String ld : longDesc.split("\n")) {
                result.addDescriptionSection(ld);
            }
        }
        if (icon != null) {
            result.setMainImage(icon.getImage());
        }
        return result;
    }

    public void setProcessMessage(String processMessage) {
        this.processMessage = processMessage;
    }

    public void setName(String value) {
        this.putValue("Name", value);
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public void setIcon(IcyIcon value) {
        this.putValue("SmallIcon", value);
    }

    public IcyIcon getIcon() {
        return (IcyIcon)this.getValue("SmallIcon");
    }

    public void setDescription(String value) {
        this.putValue("ShortDescription", value);
    }

    public String getDescription() {
        return (String)this.getValue("ShortDescription");
    }

    public void setLongDescription(String value) {
        this.putValue("LongDescription", value);
    }

    public String getLongDescription() {
        return (String)this.getValue("LongDescription");
    }

    public void setAccelerator(int keyCode, int modifiers) {
        if (keyCode != 0) {
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(keyCode, modifiers));
        } else {
            this.putValue("AcceleratorKey", null);
        }
    }

    public void setAccelerator(int keyCode) {
        this.setAccelerator(keyCode, 0);
    }

    public boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    public void setSelected(boolean value) {
        this.putValue("SwingSelectedKey", value);
    }

    public KeyStroke getKeyStroke() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }

    public boolean isProcessing() {
        return this.processing;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled && !this.processing;
    }

    @Override
    public void setEnabled(boolean value) {
        if (this.enabled != value) {
            boolean wasEnabled = this.isEnabled();
            this.enabled = value;
            boolean isEnabled = this.isEnabled();
            if (wasEnabled != isEnabled) {
                this.firePropertyChange(ENABLED_KEY, wasEnabled, isEnabled);
            }
        }
    }

    protected void setProcessing(boolean value) {
        if (this.processing != value) {
            boolean wasEnabled = this.isEnabled();
            this.processing = value;
            boolean isEnabled = this.isEnabled();
            if (wasEnabled != isEnabled) {
                this.firePropertyChange(ENABLED_KEY, wasEnabled, isEnabled);
            }
        }
    }

    public void enabledChanged() {
        boolean enabledState = this.isEnabled();
        this.firePropertyChange(ENABLED_KEY, !enabledState, enabledState);
    }

    public JLabel getLabelComponent(boolean wantIcon, boolean wantText) {
        String desc;
        JLabel result = new JLabel();
        if (wantIcon) {
            result.setIcon((Icon)((Object)this.getIcon()));
        }
        if (wantText) {
            result.setText(this.getName());
        }
        if (StringUtil.isEmpty(desc = this.getDescription())) {
            result.setToolTipText(this.getLongDescription());
        } else {
            result.setToolTipText(this.getDescription());
        }
        return result;
    }

    public JLabel getLabelComponent() {
        return this.getLabelComponent(true, true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setProcessing(true);
        if (this.isBgProcess()) {
            final ActionEvent event = e;
            ThreadUtil.bgRun(new Runnable(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public void run() {
                    block3: {
                        String mess = IcyAbstractAction.this.getProcessMessage();
                        IcyAbstractAction.this.progressFrame = !StringUtil.isEmpty(mess) && !Icy.getMainInterface().isHeadLess() ? new ProgressFrame(mess) : null;
                        try {
                            IcyAbstractAction.this.doAction(event);
                            if (IcyAbstractAction.this.progressFrame == null) break block3;
                        }
                        catch (Throwable throwable) {
                            if (IcyAbstractAction.this.progressFrame != null) {
                                IcyAbstractAction.this.progressFrame.close();
                            }
                            ThreadUtil.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    IcyAbstractAction.this.setProcessing(false);
                                }
                            });
                            throw throwable;
                        }
                        IcyAbstractAction.this.progressFrame.close();
                    }
                    ThreadUtil.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        } else {
            try {
                this.doAction(e);
            }
            finally {
                this.setProcessing(false);
            }
        }
    }

    public void execute() {
        this.actionPerformed(new ActionEvent(this, 0, ""));
    }

    @Deprecated
    public boolean doAction() {
        return this.doAction(new ActionEvent(this, 0, ""));
    }

    public boolean executeNow() {
        return this.doAction(new ActionEvent(this, 0, ""));
    }

    protected abstract boolean doAction(ActionEvent var1);
}

