/*
 * Decompiled with CFR 0.152.
 */
package icy.action;

import icy.action.IcyAbstractAction;
import icy.gui.preferences.PreferenceFrame;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.util.ClassUtil;
import java.awt.event.ActionEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PreferencesActions {
    public static IcyAbstractAction preferencesAction = new IcyAbstractAction("Preferences  ", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the preferences window", "Setup Icy preferences"){
        private static final long serialVersionUID = 1536708346834850905L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("General");
            return true;
        }
    };
    public static IcyAbstractAction generalPreferencesAction = new IcyAbstractAction("Preferences", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the general preferences window", "Setup general setting as font size, automatic update, maximum memory..."){
        private static final long serialVersionUID = 1536708346834850905L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("General");
            return true;
        }
    };
    public static IcyAbstractAction canvasPreferencesAction = new IcyAbstractAction("Canvas preferences", new IcyIcon(ResourceUtil.ICON_PICTURE), "Show the canvas preferences window", "Setup canvas setting as filtering, mouse wheel sensivity and reverse mouse axis..."){
        private static final long serialVersionUID = 5758147926869943436L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("GUI & Canvas");
            return true;
        }
    };
    public static IcyAbstractAction networkPreferencesAction = new IcyAbstractAction("Network preferences", new IcyIcon(ResourceUtil.ICON_NETWORK), "Show the network preferences window", "Setup network setting as proxy server."){
        private static final long serialVersionUID = -8056321522618950702L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Network");
            return true;
        }
    };
    public static IcyAbstractAction pluginPreferencesAction = new IcyAbstractAction("Plugin preferences", new IcyIcon(ResourceUtil.ICON_PLUGIN), "Show the plugin preferences window", "Setup plugin setting as automatic update and enable beta version."){
        private static final long serialVersionUID = 1703582841917110419L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Plugin");
            return true;
        }
    };
    public static IcyAbstractAction localPluginPreferencesAction = new IcyAbstractAction("Local plugin", new IcyIcon(ResourceUtil.ICON_PLUGIN), "Show the local plugin window", "Browse, remove, update and show informations about installed plugin."){
        private static final long serialVersionUID = -8604088116271591026L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Local Plugin");
            return true;
        }
    };
    public static IcyAbstractAction onlinePluginPreferencesAction = new IcyAbstractAction("Online plugin", new IcyIcon(ResourceUtil.ICON_PLUGIN), "Show the online plugin window", "Browse online plugins and install them."){
        private static final long serialVersionUID = -4583665324845708263L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Online Plugin");
            return true;
        }
    };
    public static IcyAbstractAction startupPluginPreferencesAction = new IcyAbstractAction("Startup plugin", new IcyIcon(ResourceUtil.ICON_PLUGIN), "Show the startup plugin window", "Enable / disable startup plugins."){
        private static final long serialVersionUID = 3354219389334167804L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Startup Plugin");
            return true;
        }
    };
    public static IcyAbstractAction repositoryPreferencesAction = new IcyAbstractAction("Repository preferences", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the repository preferences window", "Add, edit or remove repository address."){
        private static final long serialVersionUID = -8186738344041266273L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Repository");
            return true;
        }
    };
    public static IcyAbstractAction workspacePreferencesAction = new IcyAbstractAction("Workspace preferences", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the workspace preferences window"){
        private static final long serialVersionUID = -7568519363461531069L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Workspace");
            return true;
        }
    };
    public static IcyAbstractAction localWorkspacePreferencesAction = new IcyAbstractAction("Local workspace", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the local workspace window", "Enable / disable or remove installed workspaces."){
        private static final long serialVersionUID = 5843627734779598519L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Local Workspace");
            return true;
        }
    };
    public static IcyAbstractAction onlineWorkspacePreferencesAction = new IcyAbstractAction("Online workspace", new IcyIcon(ResourceUtil.ICON_TOOLS), "Show the online workspace window", "Browse online workspaces and install them."){
        private static final long serialVersionUID = 4739347012951517215L;

        @Override
        public boolean doAction(ActionEvent e) {
            new PreferenceFrame("Online Workspace");
            return true;
        }
    };

    public static List<IcyAbstractAction> getAllActions() {
        ArrayList<IcyAbstractAction> result = new ArrayList<IcyAbstractAction>();
        for (Field field : PreferencesActions.class.getFields()) {
            Class<?> type = field.getType();
            try {
                if (ClassUtil.isSubClass(type, IcyAbstractAction[].class)) {
                    result.addAll(Arrays.asList((IcyAbstractAction[])field.get(null)));
                    continue;
                }
                if (!ClassUtil.isSubClass(type, IcyAbstractAction.class)) continue;
                result.add((IcyAbstractAction)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }
}

