/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.util;

import java.awt.CheckboxMenuItem;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class SwingUtil {
    public static JMenuBar getJMenuBar(MenuBar menuBar, boolean heavy) {
        JMenuBar result = new JMenuBar();
        if (menuBar != null) {
            for (int i = 0; i < menuBar.getMenuCount(); ++i) {
                result.add(SwingUtil.getJMenu(menuBar.getMenu(i), heavy));
            }
        }
        return result;
    }

    public static JMenu getJMenu(Menu menu, boolean heavy) {
        JMenu result = new JMenu();
        if (menu != null) {
            result.setText(menu.getLabel());
            if (heavy) {
                result.getPopupMenu().setLightWeightPopupEnabled(false);
            }
            for (int i = 0; i < menu.getItemCount(); ++i) {
                result.add(SwingUtil.getJMenuItem(menu.getItem(i), heavy));
            }
        }
        return result;
    }

    public static JMenuItem getJMenuItem(MenuItem menuItem, boolean heavy) {
        if (menuItem != null) {
            if (menuItem instanceof Menu) {
                return SwingUtil.getJMenu((Menu)menuItem, heavy);
            }
            if (menuItem instanceof CheckboxMenuItem) {
                return new JCheckBoxMenuItemWrapper((CheckboxMenuItem)menuItem);
            }
            return new JMenuItemWrapper(menuItem);
        }
        return new JMenuItem();
    }

    private static class JMenuItemWrapper
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = -3283063959812167447L;
        final MenuItem menuItem;

        public JMenuItemWrapper(MenuItem menuItem) {
            super(menuItem.getLabel());
            this.menuItem = menuItem;
            this.setActionCommand(menuItem.getActionCommand());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e.setSource(this.menuItem);
            for (ActionListener al : this.menuItem.getActionListeners()) {
                al.actionPerformed(e);
            }
        }
    }

    private static class JCheckBoxMenuItemWrapper
    extends JCheckBoxMenuItem
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -3283063959812167447L;
        final CheckboxMenuItem checkboxMenuItem;

        public JCheckBoxMenuItemWrapper(CheckboxMenuItem checkboxMenuItem) {
            super(checkboxMenuItem.getLabel(), checkboxMenuItem.getState());
            this.checkboxMenuItem = checkboxMenuItem;
            this.setActionCommand(checkboxMenuItem.getActionCommand());
            checkboxMenuItem.addItemListener(this);
            this.addActionListener(this);
            this.addItemListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            e.setSource(this.checkboxMenuItem);
            for (ActionListener al : this.checkboxMenuItem.getActionListeners()) {
                al.actionPerformed(e);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == this.checkboxMenuItem) {
                this.setSelected(this.checkboxMenuItem.getState());
            } else {
                boolean state = this.isSelected();
                if (this.checkboxMenuItem.getState() != state) {
                    this.checkboxMenuItem.setState(this.isSelected());
                    ItemEvent iv = new ItemEvent(this.checkboxMenuItem, 701, this.getText(), state ? 1 : 2);
                    for (ItemListener il : this.checkboxMenuItem.getItemListeners()) {
                        il.itemStateChanged(iv);
                    }
                }
            }
        }
    }
}

