/*
 * Decompiled with CFR 0.152.
 */
package icy.image.colormodel;

import icy.image.colormodel.IcyColorModel;
import icy.image.lut.LUT;
import icy.type.DataType;
import icy.type.TypeUtil;

public class ULongColorModel
extends IcyColorModel {
    public ULongColorModel(int numComponents, int[] bits) {
        super(numComponents, DataType.ULONG, bits);
    }

    @Override
    public int getRGB(Object pixel) {
        long[] pix = (long[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)this.colormapScalers[comp].scale(TypeUtil.unsign(pix[comp]));
        }
        return this.getIcyColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int getRGB(Object pixel, LUT lut) {
        long[] pix = (long[])pixel;
        int[] scaledData = new int[this.numComponents];
        for (int comp = 0; comp < this.numComponents; ++comp) {
            scaledData[comp] = (int)lut.getLutChannel(comp).getScaler().scale(TypeUtil.unsign(pix[comp]));
        }
        return lut.getColorSpace().toRGBUnnorm(scaledData);
    }

    @Override
    public int[] getComponents(Object pixel, int[] components, int offset) {
        int[] result;
        if (components == null) {
            result = new int[offset + this.numComponents];
        } else {
            if (components.length - offset < this.numComponents) {
                throw new IllegalArgumentException("Length of components array < number of components in model");
            }
            result = components;
        }
        long[] data = (long[])pixel;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            result[offset + i] = (int)data[i];
        }
        return result;
    }

    @Override
    public Object getDataElements(int[] components, int offset, Object obj) {
        if (components.length - offset < this.numComponents) {
            throw new IllegalArgumentException("Component array too small (should be " + this.numComponents);
        }
        int len = components.length;
        long[] pixel = obj == null ? new long[this.numComponents] : (long[])obj;
        for (int i = 0; i < len; ++i) {
            pixel[i] = components[offset + i];
        }
        return pixel;
    }

    @Override
    public Object getDataElements(float[] normComponents, int offset, Object obj) {
        long[] pixel = obj == null ? new long[this.numComponents] : (long[])obj;
        int c = 0;
        int nc = offset;
        while (c < this.numComponents) {
            pixel[c] = TypeUtil.toLong(this.normalScalers[c].unscale(normComponents[nc]));
            ++c;
            ++nc;
        }
        return pixel;
    }

    @Override
    public float[] getNormalizedComponents(Object pixel, float[] normComponents, int normOffset) {
        float[] result = normComponents == null ? new float[this.numComponents + normOffset] : normComponents;
        long[] data = (long[])pixel;
        int c = 0;
        int nc = normOffset;
        while (c < this.numComponents) {
            result[nc] = (float)this.normalScalers[c].scale(TypeUtil.unsign(data[c]));
            ++c;
            ++nc;
        }
        return result;
    }
}

