/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.component;

import icy.system.thread.ThreadUtil;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jxl.Sheet;
import jxl.write.WritableSheet;

public class ExcelTable
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    JTable table;

    public ExcelTable() {
    }

    public ExcelTable(Sheet page) {
        this.updateSheet(page);
        this.setViewportView(this.table);
        this.setAutoscrolls(true);
    }

    public ExcelTable(WritableSheet page) {
        this((Sheet)page);
    }

    public synchronized void updateSheet(final Sheet page) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExcelTable.this.table = new JTable();
                ExcelTable.this.setViewportView(ExcelTable.this.table);
                if (page != null) {
                    ExcelTable.this.table.setModel(new SheetTableModel(page));
                }
            }
        });
    }

    public synchronized void updateSheet(WritableSheet page) {
        this.updateSheet((Sheet)page);
    }

    private class SheetTableModel
    implements TableModel {
        private Sheet sheet = null;

        public SheetTableModel(Sheet sheet) {
            this.sheet = sheet;
        }

        @Override
        public int getRowCount() {
            return this.sheet.getRows();
        }

        @Override
        public int getColumnCount() {
            return this.sheet.getColumns();
        }

        @Override
        public String getColumnName(int column) {
            String result = "";
            while (column >= 0) {
                result = (char)((char)(column % 26) + 65) + result;
                column = column / 26 - 1;
            }
            return result;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            try {
                return this.sheet.getCell(columnIndex, rowIndex).getContents();
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

