/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu;

import icy.action.IcyAbstractAction;
import icy.action.RoiActions;
import icy.gui.component.NumberTextField;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyCommandButton;
import icy.gui.component.button.IcyCommandMenuButton;
import icy.gui.component.button.IcyCommandToggleButton;
import icy.gui.inspector.RoisPanel;
import icy.gui.plugin.PluginCommandButton;
import icy.gui.util.RibbonUtil;
import icy.main.Icy;
import icy.plugin.PluginDescriptor;
import icy.plugin.PluginLoader;
import icy.plugin.interface_.PluginROI;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.roi.ROI;
import icy.roi.ROI2D;
import icy.roi.ROI3D;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandToggleButtonGroup;
import org.pushingpixels.flamingo.api.common.HorizontalAlignment;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.JCommandMenuButton;
import org.pushingpixels.flamingo.api.common.JCommandToggleButton;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.api.common.popup.JCommandPopupMenu;
import org.pushingpixels.flamingo.api.common.popup.JPopupPanel;
import org.pushingpixels.flamingo.api.common.popup.PopupPanelCallback;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.RibbonTask;
import org.pushingpixels.flamingo.api.ribbon.resize.CoreRibbonResizeSequencingPolicies;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizeSequencingPolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import plugins.kernel.roi.roi2d.ROI2DArea;
import plugins.kernel.roi.roi2d.ROI2DShape;
import plugins.kernel.roi.roi2d.plugin.ROI2DAreaPlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DEllipsePlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DLinePlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DPointPlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DPolyLinePlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DPolygonPlugin;
import plugins.kernel.roi.roi2d.plugin.ROI2DRectanglePlugin;
import plugins.kernel.roi.roi3d.ROI3DArea;
import plugins.kernel.roi.roi3d.plugin.ROI3DLinePlugin;
import plugins.kernel.roi.roi3d.plugin.ROI3DPointPlugin;
import plugins.kernel.roi.roi3d.plugin.ROI3DPolyLinePlugin;
import plugins.kernel.roi.roi4d.ROI4DArea;
import plugins.kernel.roi.roi5d.ROI5DArea;
import plugins.kernel.roi.tool.plugin.ROILineCutterPlugin;

public class ROITask
extends RibbonTask
implements PluginLoader.PluginLoaderListener {
    public static final String NAME = "Region Of Interest";
    @Deprecated
    public static final String SELECT = "Selection";
    @Deprecated
    public static final String MOVE = "Move";
    final ROI2DBand roi2dBand;
    final ROI3DBand roi3dBand;
    final ROIExtBand roiExtBand;
    final ROIConversionBand roiConversionBand;
    final ROISeparationBand roiSeparationBand;
    final ROIMorphologyBand roiMorphologyBand;
    final ROIBooleanOpBand roiBooleanOpBand;
    final ROIFillBand roiFillBand;
    final ROIIOBand roiIOBand;
    final CommandToggleButtonGroup buttonGroup;
    final ActionListener buttonActionListener;
    private final EventListenerList listeners;
    private Runnable buttonUpdater;

    @Deprecated
    public static boolean isROITool(String command) {
        return command != null;
    }

    public ROITask() {
        super(NAME, new AbstractRibbonBand[]{new ROI2DBand(), new ROI3DBand(), new ROIExtBand(), new ROIConversionBand(), new ROISeparationBand(), new ROIMorphologyBand(), new ROIBooleanOpBand(), new ROIFillBand(), new ROIIOBand()});
        this.setResizeSequencingPolicy((RibbonBandResizeSequencingPolicy)new CoreRibbonResizeSequencingPolicies.CollapseFromLast((RibbonTask)this));
        this.roi2dBand = (ROI2DBand)RibbonUtil.getBand(this, "2D ROI");
        this.roi3dBand = (ROI3DBand)RibbonUtil.getBand(this, "3D ROI");
        this.roiExtBand = (ROIExtBand)RibbonUtil.getBand(this, "External ROI");
        this.roiConversionBand = (ROIConversionBand)RibbonUtil.getBand(this, "Conversion");
        this.roiSeparationBand = (ROISeparationBand)RibbonUtil.getBand(this, "Separation");
        this.roiMorphologyBand = (ROIMorphologyBand)RibbonUtil.getBand(this, "Morphology");
        this.roiBooleanOpBand = (ROIBooleanOpBand)RibbonUtil.getBand(this, "Boolean Op");
        this.roiFillBand = (ROIFillBand)RibbonUtil.getBand(this, "Fill operation");
        this.roiIOBand = (ROIIOBand)RibbonUtil.getBand(this, "File");
        this.buttonUpdater = new Runnable(){

            @Override
            public void run() {
                ThreadUtil.sleep(1);
                ThreadUtil.invokeNow(new Runnable(){

                    @Override
                    public void run() {
                        ROITask.this.roi2dBand.updateButtonsState();
                        ROITask.this.roi3dBand.updateButtonsState();
                        ROITask.this.roiExtBand.updateButtonsState();
                        ROITask.this.roiConversionBand.updateButtonsState();
                        ROITask.this.roiSeparationBand.updateButtonsState();
                        ROITask.this.roiMorphologyBand.updateButtonsState();
                        ROITask.this.roiBooleanOpBand.updateButtonsState();
                        ROITask.this.roiFillBand.updateButtonsState();
                        ROITask.this.roiIOBand.updateButtonsState();
                    }
                });
            }
        };
        this.listeners = new EventListenerList();
        this.buttonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROITask.this.setSelectedButton((IcyCommandToggleButton)((Object)e.getSource()), true);
            }
        };
        this.buttonGroup = new CommandToggleButtonGroup();
        this.buttonGroup.setAllowsClearingSelection(true);
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi2dBand)) {
            button.addActionListener(this.buttonActionListener);
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi3dBand)) {
            button.addActionListener(this.buttonActionListener);
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roiExtBand)) {
            button.addActionListener(this.buttonActionListener);
        }
        this.roiSeparationBand.cutButton.addActionListener(this.buttonActionListener);
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi2dBand)) {
            this.buttonGroup.add((JCommandToggleButton)((IcyCommandToggleButton)button));
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi3dBand)) {
            this.buttonGroup.add((JCommandToggleButton)((IcyCommandToggleButton)button));
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roiExtBand)) {
            this.buttonGroup.add((JCommandToggleButton)((IcyCommandToggleButton)button));
        }
        this.buttonGroup.add((JCommandToggleButton)this.roiSeparationBand.cutButton);
        PluginLoader.addListener(this);
    }

    protected void refreshROIButtons() {
        this.roi2dBand.setHidden(ROITask.setROIFromPlugins(this.roi2dBand.pluginButtons, this.roi2dBand, ROI2DBand.getROIPlugins(), this.buttonGroup, this.buttonActionListener));
        this.roi3dBand.setHidden(ROITask.setROIFromPlugins(this.roi3dBand.pluginButtons, this.roi3dBand, ROI3DBand.getROIPlugins(), this.buttonGroup, this.buttonActionListener));
        this.roiExtBand.setHidden(ROITask.setROIFromPlugins(this.roiExtBand.pluginButtons, this.roiExtBand, ROIExtBand.getROIPlugins(), this.buttonGroup, this.buttonActionListener));
        this.roi2dBand.updateButtonsState();
        this.roi3dBand.updateButtonsState();
        this.roiExtBand.updateButtonsState();
    }

    protected static boolean setROIFromPlugins(List<IcyCommandToggleButton> pluginButtons, JRibbonBand band, List<PluginDescriptor> roiPlugins, CommandToggleButtonGroup buttonGroup, ActionListener al) {
        for (IcyCommandToggleButton button : pluginButtons) {
            if (al != null) {
                button.removeActionListener(al);
            }
            band.removeCommandButton((AbstractCommandButton)button);
            if (buttonGroup == null) continue;
            buttonGroup.remove((JCommandToggleButton)button);
        }
        pluginButtons.clear();
        for (PluginDescriptor plugin : roiPlugins) {
            IcyCommandToggleButton button = PluginCommandButton.createToggleButton(plugin, false, plugin.isKernelPlugin());
            if (plugin.getClassName().equals(ROI2DAreaPlugin.class.getName())) {
                band.addCommandButton((AbstractCommandButton)button, RibbonElementPriority.TOP);
            } else {
                band.addCommandButton((AbstractCommandButton)button, RibbonElementPriority.MEDIUM);
            }
            if (al != null) {
                button.addActionListener(al);
            }
            if (buttonGroup != null) {
                buttonGroup.add((JCommandToggleButton)button);
            }
            pluginButtons.add(button);
        }
        return pluginButtons.isEmpty();
    }

    protected IcyCommandToggleButton getButtonFromName(String name) {
        if (StringUtil.isEmpty(name)) {
            return null;
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi2dBand)) {
            if (!name.equals(button.getName())) continue;
            return (IcyCommandToggleButton)button;
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roi3dBand)) {
            if (!name.equals(button.getName())) continue;
            return (IcyCommandToggleButton)button;
        }
        for (AbstractCommandButton button : RibbonUtil.getButtons(this.roiExtBand)) {
            if (!name.equals(button.getName())) continue;
            return (IcyCommandToggleButton)button;
        }
        return null;
    }

    public boolean isROITool() {
        return this.getSelected() != null;
    }

    protected JCommandToggleButton getSelectedButton() {
        return this.buttonGroup.getSelected();
    }

    protected void setSelectedButton(JCommandToggleButton button, boolean force) {
        if (force || this.getSelectedButton() != button) {
            if (button != null) {
                this.buttonGroup.setSelected(button, true);
            } else {
                this.buttonGroup.clearSelection();
            }
            this.toolChanged(this.getSelected());
        }
    }

    public String getSelected() {
        JCommandToggleButton button = this.getSelectedButton();
        if (button != null) {
            return button.getName();
        }
        return null;
    }

    public void setSelected(String value) {
        this.setSelectedButton(this.getButtonFromName(value), false);
    }

    public void toolChanged(String toolName) {
        this.fireChangedEvent(toolName);
    }

    public double getRadius() {
        return this.roiConversionBand.getRadius();
    }

    public double getDistance() {
        return this.roiMorphologyBand.getDistance();
    }

    public double getFillValue() {
        return this.roiFillBand.getFillValue();
    }

    public void addListener(ROITaskListener listener) {
        this.listeners.add(ROITaskListener.class, listener);
    }

    public void removeListener(ROITaskListener listener) {
        this.listeners.remove(ROITaskListener.class, listener);
    }

    void fireChangedEvent(String toolName) {
        for (ROITaskListener listener : (ROITaskListener[])this.listeners.getListeners(ROITaskListener.class)) {
            listener.toolChanged(toolName);
        }
    }

    public void onSequenceActivationChange() {
        ThreadUtil.runSingle(this.buttonUpdater);
    }

    public void onSequenceChange() {
        ThreadUtil.runSingle(this.buttonUpdater);
    }

    @Override
    public void pluginLoaderChanged(PluginLoader.PluginLoaderEvent e) {
        ThreadUtil.invokeLater(new Runnable(){

            @Override
            public void run() {
                ROITask.this.refreshROIButtons();
            }
        });
    }

    static class ROIFillBand
    extends JRibbonBand {
        public static final String BAND_NAME = "Fill operation";
        final NumberTextField fillValueField;
        final IcyButton fillInterior = new IcyButton(RoiActions.fillInteriorAction);
        final IcyButton fillExterior;

        public ROIFillBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon("document"));
            this.fillInterior.setHorizontalAlignment(10);
            this.fillInterior.setFlat(true);
            this.fillExterior = new IcyButton(RoiActions.fillExteriorAction);
            this.fillExterior.setHorizontalAlignment(10);
            this.fillExterior.setFlat(true);
            this.fillValueField = new NumberTextField();
            this.fillValueField.setHorizontalAlignment(0);
            this.fillValueField.setToolTipText("Value used for filling");
            this.fillValueField.setNumericValue(0.0);
            JRibbonComponent comp = new JRibbonComponent((JComponent)this.fillInterior);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.fillExterior);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.fillValueField);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            this.setToolTipText("Fill operation for ROI");
            ((BasicBandControlPanelUI)((JBandControlPanel)this.getControlPanel()).getUI()).setLayoutGap(0);
            RibbonUtil.setRestrictiveResizePolicies(this, 0);
            this.updateButtonsState();
        }

        public double getFillValue() {
            double value = this.fillValueField.getNumericValue();
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            if (sequence != null && !sequence.isFloatDataType()) {
                double[] bounds = sequence.getDataType_().getDefaultBounds();
                if (value < bounds[0]) {
                    value = bounds[0];
                }
                if (value > bounds[1]) {
                    value = bounds[1];
                }
            }
            this.fillValueField.setNumericValue(value);
            return value;
        }

        void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            boolean enabled = seq != null && !seq.isEmpty() && seq.hasSelectedROI();
            this.fillValueField.setEnabled(enabled);
            this.fillInterior.setEnabled(enabled);
            this.fillExterior.setEnabled(enabled);
        }
    }

    static class ROIIOBand
    extends JRibbonBand {
        public static final String BAND_NAME = "File";
        final IcyCommandButton loadFromXMLButton = new IcyCommandButton(RoiActions.loadAction);
        final IcyCommandButton saveToXMLButton = new IcyCommandButton(RoiActions.saveAction);
        final IcyCommandButton exportToXLSButton = new IcyCommandButton(RoiActions.xlsExportAction);

        public ROIIOBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_OPEN));
            this.addCommandButton((AbstractCommandButton)this.loadFromXMLButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.saveToXMLButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.exportToXLSButton, RibbonElementPriority.MEDIUM);
            this.setToolTipText("File operations for ROI");
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        public void updateButtonsState() {
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            RoisPanel roisPanel = Icy.getMainInterface().getRoisPanel();
            this.loadFromXMLButton.setEnabled(seq != null);
            this.saveToXMLButton.setEnabled(seq != null && seq.hasSelectedROI());
            this.exportToXLSButton.setEnabled(roisPanel != null && roisPanel.getVisibleRois().size() > 0);
        }
    }

    static class ROIMorphologyBand
    extends JRibbonBand {
        private static final long serialVersionUID = 3683589041361260009L;
        public static final String BAND_NAME = "Morphology";
        final IcyButton computeDistanceMapButton = this.createIcyButton(RoiActions.computeDistanceMapAction);
        final IcyButton computeSkeletonButton = this.createIcyButton(RoiActions.computeSkeleton);
        final IcyButton dilateButton = this.createIcyButton(RoiActions.dilateObjectsAction);
        final IcyButton erodeButton = this.createIcyButton(RoiActions.erodeObjectsAction);
        final NumberTextField distanceField = new NumberTextField();

        public ROIMorphologyBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_ROI_DISTANCE_MAP));
            this.distanceField.setHorizontalAlignment(0);
            this.distanceField.setToolTipText("Distance to dilate/erode in pixels (>= 1)");
            this.distanceField.setNumericValue(1.0);
            this.addButtonComponent(this.dilateButton);
            this.addButtonComponent(this.erodeButton);
            JRibbonComponent distanceComponent = new JRibbonComponent((JComponent)this.distanceField);
            distanceComponent.setResizingAware(true);
            distanceComponent.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(distanceComponent);
            this.addButtonComponent(this.computeDistanceMapButton);
            this.computeDistanceMapButton.setEnabled(false);
            this.dilateButton.setEnabled(false);
            this.erodeButton.setEnabled(false);
            this.setToolTipText("Morphological tools for ROIs");
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        private IcyButton createIcyButton(IcyAbstractAction action) {
            IcyButton button = new IcyButton(action);
            button.setHorizontalAlignment(10);
            button.setFlat(true);
            return button;
        }

        private void addButtonComponent(IcyButton button) {
            JRibbonComponent comp = new JRibbonComponent((JComponent)button);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
        }

        public double getDistance() {
            return Math.max(1.0, this.distanceField.getNumericValue());
        }

        public void updateButtonsState() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            boolean hasSequence = sequence != null;
            boolean hasRois = hasSequence && !sequence.getSelectedROIs().isEmpty();
            this.computeDistanceMapButton.setEnabled(hasRois);
            this.computeSkeletonButton.setEnabled(hasRois);
            this.dilateButton.setEnabled(hasRois);
            this.erodeButton.setEnabled(hasRois);
            this.distanceField.setEnabled(hasRois);
        }
    }

    static class ROISeparationBand
    extends JRibbonBand {
        public static final String BAND_NAME = "Separation";
        final IcyCommandButton separateObjectsButton = new IcyCommandButton(RoiActions.separateObjectsAction);
        final IcyCommandButton watershedSeparationButton = new IcyCommandButton(RoiActions.computeWatershedSeparation);
        final IcyCommandToggleButton cutButton = PluginCommandButton.createToggleButton(PluginLoader.getPlugin(ROILineCutterPlugin.class.getName()), false, true);
        final IcyCommandButton splitButton = new IcyCommandButton(RoiActions.autoSplitAction);

        public ROISeparationBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_ROI_COMP));
            this.addCommandButton((AbstractCommandButton)this.separateObjectsButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.watershedSeparationButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.cutButton, RibbonElementPriority.MEDIUM);
            this.cutButton.setEnabled(false);
            this.setToolTipText("Separation tools for ROI");
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        public void updateButtonsState() {
            boolean separateEnable = false;
            boolean cutEnable = false;
            boolean splitEnable = false;
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            if (seq != null) {
                ArrayList<ROI> selectedRois = seq.getSelectedROIs();
                cutEnable = seq.hasROI();
                separateEnable = !selectedRois.isEmpty();
                splitEnable = !selectedRois.isEmpty();
            }
            this.separateObjectsButton.setEnabled(separateEnable);
            this.watershedSeparationButton.setEnabled(separateEnable);
            this.cutButton.setEnabled(cutEnable);
            this.splitButton.setEnabled(splitEnable);
        }
    }

    static class ROIBooleanOpBand
    extends JRibbonBand {
        public static final String BAND_NAME = "Boolean Op";
        final IcyCommandButton booleanUnionButton = new IcyCommandButton(RoiActions.boolOrAction);
        final IcyCommandButton booleanIntersectionButton = new IcyCommandButton(RoiActions.boolAndAction);
        final IcyCommandButton booleanOthersButton;
        final IcyCommandMenuButton booleanInversionButton = new IcyCommandMenuButton(RoiActions.boolNotAction);
        final IcyCommandMenuButton booleanExclusiveUnionButton = new IcyCommandMenuButton(RoiActions.boolXorAction);
        final IcyCommandMenuButton booleanSubtractionButton = new IcyCommandMenuButton(RoiActions.boolSubtractAction);

        public ROIBooleanOpBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_ROI_OR));
            this.booleanOthersButton = new IcyCommandButton("Other operation");
            this.booleanOthersButton.setCommandButtonKind(JCommandButton.CommandButtonKind.POPUP_ONLY);
            this.booleanOthersButton.setPopupCallback(new PopupPanelCallback(){

                public JPopupPanel getPopupPanel(JCommandButton arg0) {
                    JCommandPopupMenu result = new JCommandPopupMenu();
                    result.addMenuButton((JCommandMenuButton)booleanInversionButton);
                    result.addMenuButton((JCommandMenuButton)booleanExclusiveUnionButton);
                    result.addMenuButton((JCommandMenuButton)booleanSubtractionButton);
                    return result;
                }
            });
            this.booleanOthersButton.setEnabled(false);
            this.addCommandButton((AbstractCommandButton)this.booleanUnionButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.booleanIntersectionButton, RibbonElementPriority.MEDIUM);
            this.addCommandButton((AbstractCommandButton)this.booleanOthersButton, RibbonElementPriority.MEDIUM);
            this.setToolTipText("Boolean operation for ROI");
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.updateButtonsState();
        }

        public void updateButtonsState() {
            boolean singleOp = false;
            boolean boolOp = false;
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            if (seq != null) {
                ArrayList<ROI> selectedRois = seq.getSelectedROIs();
                singleOp = !selectedRois.isEmpty();
                boolOp = selectedRois.size() > 1;
            }
            this.booleanUnionButton.setEnabled(boolOp);
            this.booleanIntersectionButton.setEnabled(boolOp);
            this.booleanInversionButton.setEnabled(singleOp);
            this.booleanExclusiveUnionButton.setEnabled(boolOp);
            this.booleanSubtractionButton.setEnabled(boolOp);
            this.booleanOthersButton.setEnabled(singleOp || boolOp);
        }
    }

    static class ROIConversionBand
    extends JRibbonBand {
        public static final String BAND_NAME = "Conversion";
        final NumberTextField radiusField;
        final IcyButton convertToEllipseButton;
        final IcyButton convertToRectangleButton;
        final IcyButton convertToStackButton = new IcyButton(RoiActions.convertToStackAction);
        final IcyButton unstackButton;
        final IcyButton convertToMaskButton;
        final IcyButton convertToShapeButton;

        public ROIConversionBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_LAYER_V2));
            this.convertToStackButton.setHorizontalAlignment(10);
            this.convertToStackButton.setFlat(true);
            this.unstackButton = new IcyButton(RoiActions.unstackAction);
            this.unstackButton.setHorizontalAlignment(10);
            this.unstackButton.setFlat(true);
            this.convertToMaskButton = new IcyButton(RoiActions.convertToMaskAction);
            this.convertToMaskButton.setHorizontalAlignment(10);
            this.convertToMaskButton.setFlat(true);
            this.convertToShapeButton = new IcyButton(RoiActions.convertToShapeAction);
            this.convertToShapeButton.setHorizontalAlignment(10);
            this.convertToShapeButton.setFlat(true);
            this.convertToEllipseButton = new IcyButton(RoiActions.convertToEllipseAction);
            this.convertToEllipseButton.setHorizontalAlignment(10);
            this.convertToEllipseButton.setFlat(true);
            this.convertToRectangleButton = new IcyButton(RoiActions.convertToRectangleAction);
            this.convertToRectangleButton.setHorizontalAlignment(10);
            this.convertToRectangleButton.setFlat(true);
            this.radiusField = new NumberTextField();
            this.radiusField.setHorizontalAlignment(0);
            this.radiusField.setToolTipText("Radius for Circle/Rectangle conversion in pixels");
            this.radiusField.setNumericValue(1.0);
            JRibbonComponent comp = new JRibbonComponent((JComponent)this.convertToStackButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.unstackButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.convertToMaskButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.convertToShapeButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.convertToEllipseButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            comp = new JRibbonComponent((JComponent)this.convertToRectangleButton);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            comp = new JRibbonComponent((JComponent)this.radiusField);
            comp.setResizingAware(true);
            comp.setHorizontalAlignment(HorizontalAlignment.FILL);
            this.addRibbonComponent(comp);
            this.setToolTipText("Conversion tools for ROI");
            ((BasicBandControlPanelUI)((JBandControlPanel)this.getControlPanel()).getUI()).setLayoutGap(0);
            RibbonUtil.setRestrictiveResizePolicies(this, 0);
            this.updateButtonsState();
        }

        public double getRadius() {
            return Math.max(0.0, this.radiusField.getNumericValue());
        }

        public void updateButtonsState() {
            boolean convertEllipseEnable = false;
            boolean convertRectangleEnable = false;
            boolean convertStackEnable = false;
            boolean unstackEnable = false;
            boolean convertMaskEnable = false;
            boolean convertShapeEnable = false;
            Sequence seq = Icy.getMainInterface().getActiveSequence();
            if (seq != null) {
                ArrayList<ROI> selectedRois = seq.getSelectedROIs();
                for (ROI roi : selectedRois) {
                    if (roi instanceof ROI2D) {
                        convertStackEnable = true;
                        if (!(roi instanceof ROI2DShape)) {
                            convertShapeEnable = true;
                        }
                    }
                    if (!(roi instanceof ROI2DArea || roi instanceof ROI3DArea || roi instanceof ROI4DArea || roi instanceof ROI5DArea)) {
                        convertMaskEnable = true;
                    }
                    if (roi instanceof ROI3D) {
                        unstackEnable = true;
                        if (roi instanceof ROI3DArea) {
                            convertShapeEnable = true;
                        }
                    }
                    convertEllipseEnable = true;
                    convertRectangleEnable = true;
                }
            }
            this.convertToEllipseButton.setEnabled(convertEllipseEnable);
            this.convertToRectangleButton.setEnabled(convertRectangleEnable);
            this.radiusField.setEnabled(convertEllipseEnable || convertRectangleEnable);
            this.convertToStackButton.setEnabled(convertStackEnable);
            this.unstackButton.setEnabled(unstackEnable);
            this.convertToMaskButton.setEnabled(convertMaskEnable);
            this.convertToShapeButton.setEnabled(convertShapeEnable);
        }
    }

    static class ROIExtBand
    extends JRibbonBand {
        public static final String BAND_NAME = "External ROI";
        final List<IcyCommandToggleButton> pluginButtons;

        public ROIExtBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_ROI));
            this.startGroup();
            this.pluginButtons = new ArrayList<IcyCommandToggleButton>();
            this.setHidden(ROITask.setROIFromPlugins(this.pluginButtons, this, ROIExtBand.getROIPlugins(), null, null));
            this.updateButtonsState();
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.setToolTipText("External Region Of Interest");
            this.updateButtonsState();
        }

        public static List<PluginDescriptor> getROIPlugins() {
            ArrayList<PluginDescriptor> result = PluginLoader.getPlugins(PluginROI.class);
            result.removeAll(ROI2DBand.getROIPlugins());
            result.removeAll(ROI3DBand.getROIPlugins());
            result.remove(PluginLoader.getPlugin(ROILineCutterPlugin.class.getName()));
            return result;
        }

        void updateButtonsState() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            for (IcyCommandToggleButton button : this.pluginButtons) {
                button.setEnabled(sequence != null);
            }
        }
    }

    static class ROI3DBand
    extends JRibbonBand {
        public static final String BAND_NAME = "3D ROI";
        final List<IcyCommandToggleButton> pluginButtons;

        public ROI3DBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_CUBE_3D));
            this.startGroup();
            this.pluginButtons = new ArrayList<IcyCommandToggleButton>();
            this.setHidden(ROITask.setROIFromPlugins(this.pluginButtons, this, ROI3DBand.getROIPlugins(), null, null));
            this.updateButtonsState();
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.setToolTipText("3D Region Of Interest");
        }

        public static List<PluginDescriptor> getROIPlugins() {
            ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
            result.add(PluginLoader.getPlugin(ROI3DPointPlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI3DLinePlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI3DPolyLinePlugin.class.getName()));
            return result;
        }

        void updateButtonsState() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            for (IcyCommandToggleButton button : this.pluginButtons) {
                button.setEnabled(sequence != null);
            }
        }
    }

    static class ROI2DBand
    extends JRibbonBand {
        public static final String BAND_NAME = "2D ROI";
        final List<IcyCommandToggleButton> pluginButtons;

        public ROI2DBand() {
            super(BAND_NAME, (ResizableIcon)new IcyIcon(ResourceUtil.ICON_ROI_POLYGON));
            this.startGroup();
            this.pluginButtons = new ArrayList<IcyCommandToggleButton>();
            this.setHidden(ROITask.setROIFromPlugins(this.pluginButtons, this, ROI2DBand.getROIPlugins(), null, null));
            this.updateButtonsState();
            RibbonUtil.setRestrictiveResizePolicies(this);
            this.setToolTipText("2D Region Of Interest");
        }

        public static List<PluginDescriptor> getROIPlugins() {
            ArrayList<PluginDescriptor> result = new ArrayList<PluginDescriptor>();
            result.add(PluginLoader.getPlugin(ROI2DAreaPlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DRectanglePlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DEllipsePlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DPolygonPlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DPointPlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DLinePlugin.class.getName()));
            result.add(PluginLoader.getPlugin(ROI2DPolyLinePlugin.class.getName()));
            return result;
        }

        void updateButtonsState() {
            Sequence sequence = Icy.getMainInterface().getActiveSequence();
            for (IcyCommandToggleButton button : this.pluginButtons) {
                button.setEnabled(sequence != null);
            }
        }
    }

    public static interface ROITaskListener
    extends EventListener {
        public void toolChanged(String var1);
    }
}

