/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.menu.search;

import icy.image.ImageUtil;
import icy.search.SearchResult;
import icy.util.GraphicsUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultTableCellRenderer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;

public class SearchResultTableCellRenderer
extends SubstanceDefaultTableCellRenderer {
    private static final long serialVersionUID = -6758382699884570205L;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof SearchResult) {
            SearchResult result = (SearchResult)value;
            String title = result.getTitle();
            String description = result.getDescription();
            Image img = result.getImage();
            int cellWidth = (int)((double)table.getCellRect((int)row, (int)column, (boolean)false).width * 0.9);
            if (img != null) {
                this.setIcon(new ImageIcon(ImageUtil.scale(img, 32, 32)));
            } else {
                this.setIcon(null);
            }
            String text = StringUtil.isEmpty(title) ? "<b>Unknow</b>" : "<b>" + title + "</b>";
            if (!StringUtil.isEmpty(description)) {
                text = text + "<br>" + GraphicsUtil.limitStringFor(table, description, cellWidth);
            }
            this.setText("<html>" + text);
            this.setToolTipText(result.getTooltip());
            this.setVerticalAlignment(0);
            this.setVerticalTextPosition(0);
            if (!result.isEnabled()) {
                ComponentState state = isSelected ? ComponentState.DISABLED_SELECTED : ComponentState.DISABLED_UNSELECTED;
                SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme((Component)table, (ComponentState)state);
                this.setForeground(new ColorUIResource(colorScheme.getForegroundColor()));
                this.setEnabled(false);
            } else {
                this.setEnabled(table.isEnabled());
            }
        }
        return this;
    }
}

