/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.system;

import icy.file.FileUtil;
import icy.gui.component.ExternalizablePanel;
import icy.gui.component.button.IcyButton;
import icy.gui.component.button.IcyToggleButton;
import icy.gui.frame.progress.ProgressFrame;
import icy.gui.util.GuiUtil;
import icy.preferences.GeneralPreferences;
import icy.resource.ResourceUtil;
import icy.resource.icon.IcyIcon;
import icy.system.IcyExceptionHandler;
import icy.util.EventUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class OutputConsolePanel
extends ExternalizablePanel
implements ClipboardOwner {
    private static final long serialVersionUID = 7142067146669860938L;
    protected final JTextPane textPane = new JTextPane();
    protected final StyledDocument doc = this.textPane.getStyledDocument();
    final SimpleAttributeSet normalAttributes;
    final SimpleAttributeSet errorAttributes = new SimpleAttributeSet();
    protected final JSpinner logMaxLineField;
    protected final JTextField logMaxLineTextField;
    public final IcyButton clearLogButton;
    public final IcyButton copyLogButton;
    public final IcyButton reportLogButton;
    public final IcyToggleButton scrollLockButton;
    public final IcyToggleButton fileLogButton;
    public final JPanel bottomPanel;
    int nbUpdate = 0;
    Writer logWriter;

    public OutputConsolePanel() {
        super("Output", "outputConsole");
        this.normalAttributes = new SimpleAttributeSet();
        StyleConstants.setFontFamily(this.errorAttributes, "arial");
        StyleConstants.setFontSize(this.errorAttributes, 11);
        StyleConstants.setForeground(this.errorAttributes, Color.red);
        StyleConstants.setFontFamily(this.normalAttributes, "arial");
        StyleConstants.setFontSize(this.normalAttributes, 11);
        StyleConstants.setForeground(this.normalAttributes, Color.black);
        this.logMaxLineField = new JSpinner(new SpinnerNumberModel(GeneralPreferences.getOutputLogSize(), 100, 1000000, 100));
        this.logMaxLineTextField = ((JSpinner.DefaultEditor)this.logMaxLineField.getEditor()).getTextField();
        this.clearLogButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_DELETE));
        this.copyLogButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_DOC_COPY));
        this.reportLogButton = new IcyButton(new IcyIcon(ResourceUtil.ICON_DOC_EXPORT));
        this.scrollLockButton = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_LOCK_OPEN));
        this.fileLogButton = new IcyToggleButton(new IcyIcon(ResourceUtil.ICON_SAVE));
        this.fileLogButton.setSelected(GeneralPreferences.getOutputLogToFile());
        this.textPane.setEditable(false);
        this.clearLogButton.setFlat(true);
        this.copyLogButton.setFlat(true);
        this.reportLogButton.setFlat(true);
        this.scrollLockButton.setFlat(true);
        this.fileLogButton.setFlat(true);
        this.logMaxLineField.setPreferredSize(new Dimension(80, 24));
        this.logMaxLineField.setFocusable(false);
        this.logMaxLineTextField.setFocusable(false);
        this.logMaxLineTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EventUtil.isLeftMouseButton(e)) {
                    OutputConsolePanel.this.logMaxLineField.setFocusable(true);
                    OutputConsolePanel.this.logMaxLineTextField.setFocusable(true);
                    OutputConsolePanel.this.logMaxLineTextField.requestFocus();
                }
            }
        });
        this.logMaxLineTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 && OutputConsolePanel.this.logMaxLineTextField.isFocusable()) {
                    OutputConsolePanel.this.logMaxLineTextField.setFocusable(false);
                    OutputConsolePanel.this.logMaxLineField.setFocusable(false);
                }
            }
        });
        this.logMaxLineField.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                GeneralPreferences.setOutputLogSize(OutputConsolePanel.this.getLogMaxLine());
                if (OutputConsolePanel.this.logMaxLineTextField.isFocusable()) {
                    OutputConsolePanel.this.logMaxLineTextField.setFocusable(false);
                    OutputConsolePanel.this.logMaxLineField.setFocusable(false);
                }
                try {
                    OutputConsolePanel.this.limitLog();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.logMaxLineField.setToolTipText("Double-click to edit the maximum number of line (max = 1000000)");
        this.clearLogButton.setToolTipText("Clear all");
        this.copyLogButton.setToolTipText("Copy to clipboard");
        this.reportLogButton.setToolTipText("Report content to dev team");
        this.scrollLockButton.setToolTipText("Scroll Lock");
        this.fileLogButton.setToolTipText("Enable/Disable log file saving (log.txt)");
        this.clearLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OutputConsolePanel.this.textPane.setText("");
            }
        });
        this.copyLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = OutputConsolePanel.this.getToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(OutputConsolePanel.this.getText()), OutputConsolePanel.this);
            }
        });
        this.reportLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try (ProgressFrame progressFrame = new ProgressFrame("Sending report...");){
                    IcyExceptionHandler.report(OutputConsolePanel.this.getText());
                }
            }
        });
        this.scrollLockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OutputConsolePanel.this.scrollLockButton.isSelected()) {
                    OutputConsolePanel.this.scrollLockButton.setIconImage(ResourceUtil.ICON_LOCK_CLOSE);
                } else {
                    OutputConsolePanel.this.scrollLockButton.setIconImage(ResourceUtil.ICON_LOCK_OPEN);
                }
            }
        });
        this.fileLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneralPreferences.setOutputLogFile(OutputConsolePanel.this.fileLogButton.isSelected());
            }
        });
        this.bottomPanel = GuiUtil.createPageBoxPanel(Box.createVerticalStrut(4), GuiUtil.createLineBoxPanel(this.clearLogButton, Box.createHorizontalStrut(4), this.copyLogButton, Box.createHorizontalStrut(4), this.reportLogButton, Box.createHorizontalGlue(), Box.createHorizontalStrut(4), new JLabel("Limit"), Box.createHorizontalStrut(4), this.logMaxLineField, Box.createHorizontalStrut(4), this.scrollLockButton, Box.createHorizontalStrut(4), this.fileLogButton));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.textPane, "Center");
        JScrollPane scrollPane = new JScrollPane(panel);
        this.setLayout(new BorderLayout());
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.validate();
        System.setOut(new WindowsOutPrintStream(System.out, false));
        System.setErr(new WindowsOutPrintStream(System.err, true));
        try {
            this.logWriter = new FileWriter(FileUtil.getApplicationDirectory() + "/icy.log", false);
        }
        catch (IOException e1) {
            this.logWriter = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addText(String text, boolean isError) {
        try {
            ++this.nbUpdate;
            StyledDocument styledDocument = this.doc;
            synchronized (styledDocument) {
                if (isError) {
                    this.doc.insertString(this.doc.getLength(), text, this.errorAttributes);
                } else {
                    this.doc.insertString(this.doc.getLength(), text, this.normalAttributes);
                }
                if ((this.nbUpdate & 0x7F) == 0) {
                    this.limitLog();
                }
                if (!this.scrollLockButton.isSelected()) {
                    this.textPane.setCaretPosition(this.doc.getLength());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.changed(isError);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        try {
            StyledDocument styledDocument = this.doc;
            synchronized (styledDocument) {
                return this.doc.getText(0, this.doc.getLength());
            }
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    public void limitLog() throws BadLocationException {
        int logMaxLine;
        Element root = this.doc.getDefaultRootElement();
        int numLine = root.getElementCount();
        if (numLine > (logMaxLine = this.getLogMaxLine())) {
            Element line = root.getElement(numLine - (logMaxLine + 1));
            this.doc.remove(0, line.getEndOffset());
        }
    }

    public int getLogMaxLine() {
        return (Integer)this.logMaxLineField.getValue();
    }

    public void setLogMaxLine(int value) {
        this.logMaxLineField.setValue(value);
    }

    private void changed(boolean isError) {
        this.fireChangedEvent(isError);
    }

    public void fireChangedEvent(boolean isError) {
        for (OutputConsoleChangeListener listener : (OutputConsoleChangeListener[])this.listenerList.getListeners(OutputConsoleChangeListener.class)) {
            listener.outputConsoleChanged(this, isError);
        }
    }

    public void addOutputConsoleChangeListener(OutputConsoleChangeListener listener) {
        this.listenerList.add(OutputConsoleChangeListener.class, listener);
    }

    public void removeOutputConsoleChangeListener(OutputConsoleChangeListener listener) {
        this.listenerList.remove(OutputConsoleChangeListener.class, listener);
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private class WindowsOutPrintStream
    extends PrintStream {
        boolean isStdErr;

        public WindowsOutPrintStream(PrintStream out, boolean isStdErr) {
            super(out);
            this.isStdErr = isStdErr;
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            try {
                super.write(buf, off, len);
                String text = new String(buf, off, len);
                OutputConsolePanel.this.addText(text, this.isStdErr);
                if (OutputConsolePanel.this.fileLogButton.isSelected() && OutputConsolePanel.this.logWriter != null) {
                    OutputConsolePanel.this.logWriter.write(text);
                    OutputConsolePanel.this.logWriter.flush();
                }
            }
            catch (Throwable t) {
                OutputConsolePanel.this.addText(t.getMessage(), this.isStdErr);
            }
        }
    }

    public static interface OutputConsoleChangeListener
    extends EventListener {
        public void outputConsoleChanged(OutputConsolePanel var1, boolean var2);
    }
}

