/*
 * Decompiled with CFR 0.152.
 */
package icy.image.cache;

import icy.image.cache.CacheException;
import java.util.Collection;

public abstract class AbstractCache {
    boolean profiling = false;
    long profilingTime;
    long startTime;

    public abstract String getName();

    public void setProfiling(boolean value) {
        this.profiling = value;
    }

    public void resetProfiling() {
        this.profilingTime = 0L;
    }

    public long getProfilingTime() {
        return this.profilingTime;
    }

    protected void startProf() {
        this.startTime = System.nanoTime();
    }

    protected void endProf() {
        this.profilingTime += (System.nanoTime() - this.startTime) / 1000000L;
    }

    public abstract boolean isEnabled();

    public abstract boolean isInCache(Integer var1);

    public abstract boolean isOnMemoryCache(Integer var1);

    public abstract boolean isOnDiskCache(Integer var1);

    public abstract long usedMemory();

    public abstract long usedDisk();

    public abstract Collection<Integer> getAllKeys() throws CacheException;

    public abstract Object get(Integer var1) throws CacheException;

    public abstract void set(Integer var1, Object var2, boolean var3) throws CacheException;

    public abstract void clear() throws CacheException;

    public abstract void remove(Integer var1) throws CacheException;

    public abstract void end();
}

