/*
 * Decompiled with CFR 0.152.
 */
package icy.type.geom;

import icy.type.geom.Polyline2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class Polygon2D
implements Shape,
Cloneable {
    public int npoints;
    public double[] xpoints;
    public double[] ypoints;
    protected Rectangle2D bounds;
    protected Path2D.Double path;
    protected Path2D.Double closedPath;

    private static void addFarthestPoint(List<Point2D> result, List<Point2D> points, int start, int end, double maxDeviation) {
        Point2D p1 = points.get(start);
        Point2D p2 = points.get(end);
        double x1 = p1.getX();
        double y1 = p1.getY();
        double x2 = p2.getX();
        double y2 = p2.getY();
        int farthest = -1;
        double maxDist = maxDeviation * maxDeviation;
        for (int i = start + 1; i < end; ++i) {
            Point2D p = points.get(i);
            double dist = Line2D.ptSegDistSq(x1, y1, x2, y2, p.getX(), p.getY());
            if (!(dist > maxDist)) continue;
            farthest = i;
            maxDist = dist;
        }
        if (farthest != -1) {
            Polygon2D.addFarthestPoint(result, points, start, farthest, maxDeviation);
            result.add(points.get(farthest));
            Polygon2D.addFarthestPoint(result, points, farthest, end, maxDeviation);
        }
    }

    public static Polygon2D getPolygon2D(List<Point2D> points, double maxDeviation) {
        if (points.size() < 3) {
            return new Polygon2D(points);
        }
        ArrayList<Point2D> result = new ArrayList<Point2D>(points.size() / 4);
        int ind = points.size() / 2;
        points.add(points.get(0));
        result.add(points.get(0));
        Polygon2D.addFarthestPoint(result, points, 0, ind, maxDeviation);
        result.add(points.get(ind));
        Polygon2D.addFarthestPoint(result, points, ind, points.size() - 1, maxDeviation);
        points.remove(points.size() - 1);
        return new Polygon2D(result);
    }

    public Polygon2D() {
        this.reset();
    }

    public Polygon2D(Rectangle2D rec) {
        if (rec == null) {
            throw new IllegalArgumentException("null Rectangle");
        }
        this.npoints = 4;
        this.xpoints = new double[4];
        this.ypoints = new double[4];
        this.xpoints[0] = rec.getMinX();
        this.ypoints[0] = rec.getMinY();
        this.xpoints[1] = rec.getMaxX();
        this.ypoints[1] = rec.getMinY();
        this.xpoints[2] = rec.getMaxX();
        this.ypoints[2] = rec.getMaxY();
        this.xpoints[3] = rec.getMinX();
        this.ypoints[3] = rec.getMaxY();
        this.calculatePath();
    }

    public Polygon2D(Polygon pol) {
        if (pol == null) {
            throw new IllegalArgumentException("null Polygon");
        }
        this.npoints = pol.npoints;
        this.xpoints = new double[pol.npoints];
        this.ypoints = new double[pol.npoints];
        for (int i = 0; i < pol.npoints; ++i) {
            this.xpoints[i] = pol.xpoints[i];
            this.ypoints[i] = pol.ypoints[i];
        }
        this.calculatePath();
    }

    public Polygon2D(double[] xpoints, double[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.calculatePath();
    }

    public Polygon2D(int[] xpoints, int[] ypoints, int npoints) {
        if (npoints > xpoints.length || npoints > ypoints.length) {
            throw new IndexOutOfBoundsException("npoints > xpoints.length || npoints > ypoints.length");
        }
        this.npoints = npoints;
        this.xpoints = new double[npoints];
        this.ypoints = new double[npoints];
        for (int i = 0; i < npoints; ++i) {
            this.xpoints[i] = xpoints[i];
            this.ypoints[i] = ypoints[i];
        }
        this.calculatePath();
    }

    public Polygon2D(List<Point2D> points) {
        int len;
        this.npoints = len = points.size();
        this.xpoints = new double[len];
        this.ypoints = new double[len];
        for (int i = 0; i < len; ++i) {
            Point2D pt = points.get(i);
            this.xpoints[i] = pt.getX();
            this.ypoints[i] = pt.getY();
        }
        this.calculatePath();
    }

    public void reset() {
        this.npoints = 0;
        this.xpoints = new double[0];
        this.ypoints = new double[0];
        this.bounds = new Rectangle2D.Double();
        this.path = null;
        this.closedPath = null;
    }

    public Object clone() {
        Polygon2D pol = new Polygon2D();
        for (int i = 0; i < this.npoints; ++i) {
            pol.addPoint(this.xpoints[i], this.ypoints[i]);
        }
        return pol;
    }

    public void calculatePath() {
        this.path = new Path2D.Double();
        this.path.moveTo(this.xpoints[0], this.ypoints[0]);
        for (int i = 1; i < this.npoints; ++i) {
            this.path.lineTo(this.xpoints[i], this.ypoints[i]);
        }
        this.bounds = this.path.getBounds2D();
        this.closedPath = null;
    }

    protected void updatePath(double x, double y) {
        if (this.path == null) {
            this.path = new Path2D.Double(0);
            this.path.moveTo(x, y);
            this.bounds = new Rectangle2D.Double(x, y, 0.0, 0.0);
        } else {
            this.path.lineTo(x, y);
            double _xmax = this.bounds.getMaxX();
            double _ymax = this.bounds.getMaxY();
            double _xmin = this.bounds.getMinX();
            double _ymin = this.bounds.getMinY();
            if (x < _xmin) {
                _xmin = x;
            } else if (x > _xmax) {
                _xmax = x;
            }
            if (y < _ymin) {
                _ymin = y;
            } else if (y > _ymax) {
                _ymax = y;
            }
            this.bounds = new Rectangle2D.Double(_xmin, _ymin, _xmax - _xmin, _ymax - _ymin);
        }
        this.closedPath = null;
    }

    public Polyline2D getPolyline2D() {
        Polyline2D pol = new Polyline2D(this.xpoints, this.ypoints, this.npoints);
        pol.addPoint(this.xpoints[0], this.ypoints[0]);
        return pol;
    }

    public Polygon getPolygon() {
        int[] _xpoints = new int[this.npoints];
        int[] _ypoints = new int[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            _xpoints[i] = (int)this.xpoints[i];
            _ypoints[i] = (int)this.ypoints[i];
        }
        return new Polygon(_xpoints, _ypoints, this.npoints);
    }

    public void addPoint(Point2D p) {
        this.addPoint(p.getX(), p.getY());
    }

    public void addPoint(double x, double y) {
        if (this.npoints == this.xpoints.length) {
            double[] tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.xpoints, 0, tmp, 0, this.npoints);
            this.xpoints = tmp;
            tmp = new double[this.npoints * 2 + 1];
            System.arraycopy(this.ypoints, 0, tmp, 0, this.npoints);
            this.ypoints = tmp;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        this.updatePath(x, y);
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.bounds.clone();
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds.getBounds();
    }

    @Override
    public boolean contains(double x, double y) {
        if (this.npoints <= 2 || !this.bounds.contains(x, y)) {
            return false;
        }
        return this.updateComputingPath().contains(x, y);
    }

    protected Path2D.Double updateComputingPath() {
        Path2D.Double result = this.closedPath;
        if (result == null) {
            if (this.path != null) {
                result = (Path2D.Double)this.path.clone();
                result.closePath();
            } else {
                result = new Path2D.Double();
            }
            this.closedPath = result;
        }
        return result;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.bounds.intersects(x, y, w, h)) {
            return false;
        }
        return this.updateComputingPath().intersects(x, y, w, h);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.npoints <= 0 || !this.bounds.intersects(x, y, w, h)) {
            return false;
        }
        return this.updateComputingPath().contains(x, y, w, h);
    }

    @Override
    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return this.updateComputingPath().getPathIterator(at);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }
}

