/*
 * Decompiled with CFR 0.152.
 */
package ij.gui;

import ij.IJ;
import ij.ImageListener;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageWindow;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;

public class NonBlockingGenericDialog
extends GenericDialog
implements ImageListener {
    ImagePlus imp;

    public NonBlockingGenericDialog(String title) {
        super(title, null);
        this.setModal(false);
    }

    @Override
    public synchronized void showDialog() {
        super.showDialog();
        if (this.isMacro()) {
            return;
        }
        if (!IJ.macroRunning()) {
            final NonBlockingGenericDialog thisDialog = this;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WindowManager.addWindow(thisDialog);
                }
            });
        }
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (!this.isVisible()) {
            this.notify();
        }
    }

    @Override
    public synchronized void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public synchronized void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        if (this.wasOKed() || this.wasCanceled()) {
            this.notify();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        WindowManager.removeWindow(this);
    }

    public static GenericDialog newDialog(String title, ImagePlus imp) {
        if (Prefs.nonBlockingFilterDialogs && imp != null && imp.getWindow() != null) {
            NonBlockingGenericDialog gd = new NonBlockingGenericDialog(title);
            gd.imp = imp;
            ImagePlus.addImageListener(gd);
            ImageWindow win = imp.getWindow();
            return gd;
        }
        return new GenericDialog(title);
    }

    @Override
    public void imageClosed(ImagePlus imp) {
        if (imp == this.imp) {
            super.windowClosing(null);
        }
    }

    @Override
    public void imageOpened(ImagePlus imp) {
    }

    @Override
    public void imageUpdated(ImagePlus imp) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
        if (e.getWindow() instanceof ImageWindow && e.getOppositeWindow() != this) {
            this.toFront();
        }
    }
}

