/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Menus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.EllipseRoi;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Line;
import ij.gui.Overlay;
import ij.gui.PointRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.RotatedRectRoi;
import ij.io.FileInfo;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import ij.measure.CurveFitter;
import ij.plugin.AVI_Reader;
import ij.plugin.FileInfoVirtualStack;
import ij.plugin.ListVirtualStack;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.text.TextWindow;
import ij.util.Tools;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.Method;

public class ImageInfo
implements PlugIn {
    @Override
    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            this.showInfo();
        } else {
            String info = this.getImageInfo(imp);
            if (info.contains("----")) {
                this.showInfo(imp, info, 450, 500);
            } else {
                int inc = info.contains("No Selection") ? 0 : 75;
                this.showInfo(imp, info, 300, 350 + inc);
            }
        }
    }

    private void showInfo() {
        String s = new String("");
        if (IJ.getInstance() != null) {
            s = s + IJ.getInstance().getInfo() + "\n \n";
        }
        s = s + "No images are open\n";
        Dimension screen = IJ.getScreenSize();
        s = s + "ImageJ home: " + IJ.getDir("imagej") + "\n";
        s = s + "Java home: " + System.getProperty("java.home") + "\n";
        s = s + "Screen size: " + screen.width + "x" + screen.height + "\n";
        s = s + "GUI scale: " + IJ.d2s(Prefs.getGuiScale(), 2) + "\n";
        String path = Prefs.getCustomPropsPath();
        if (path != null) {
            s = s + "*Custom properties*: " + path + "\n";
        }
        if ((path = Prefs.getCustomPrefsPath()) != null) {
            s = s + "*Custom preferences*: " + path + "\n";
        }
        if (IJ.isMacOSX()) {
            String time = " (" + ImageWindow.setMenuBarTime + "ms)";
            s = s + "SetMenuBarCount: " + Menus.setMenuBarCount + time + "\n";
        }
        new TextWindow("Info", s, 600, 300);
    }

    public String getImageInfo(ImagePlus imp) {
        ImageStack stack;
        String label;
        ImageProcessor ip = imp.getProcessor();
        String infoProperty = null;
        if (imp.getStackSize() > 1 && (label = (stack = imp.getStack()).getSliceLabel(imp.getCurrentSlice())) != null && label.indexOf(10) > 0) {
            infoProperty = label;
        }
        if (infoProperty == null && (infoProperty = (String)imp.getProperty("Info")) == null) {
            infoProperty = this.getExifData(imp);
        }
        String info = this.getInfo(imp, ip);
        if (infoProperty != null) {
            return infoProperty + "\n------------------------------------------------------\n" + info;
        }
        return info;
    }

    private String getExifData(ImagePlus imp) {
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi == null) {
            return null;
        }
        String directory = fi.directory;
        String name = fi.fileName;
        if (directory == null) {
            return null;
        }
        if ((name == null || name.equals("")) && imp.getStack().isVirtual()) {
            name = imp.getStack().getSliceLabel(imp.getCurrentSlice());
        }
        if (name == null || !name.endsWith("jpg") && !name.endsWith("JPG")) {
            return null;
        }
        String path = directory + name;
        String metadata = null;
        try {
            Class<?> c = IJ.getClassLoader().loadClass("Exif_Reader");
            if (c == null) {
                return null;
            }
            String methodName = "getMetadata";
            Class[] argClasses = new Class[]{methodName.getClass()};
            Method m = c.getMethod("getMetadata", argClasses);
            Object[] args = new Object[]{path};
            Object obj = m.invoke(null, args);
            metadata = obj != null ? obj.toString() : null;
        }
        catch (Exception e) {
            return null;
        }
        if (metadata != null && !metadata.startsWith("Error:")) {
            return metadata;
        }
        return null;
    }

    private String getInfo(ImagePlus imp, ImageProcessor ip) {
        double[] p;
        Roi roi;
        Overlay overlay;
        ImageWindow win;
        double mag;
        String s = new String("");
        if (IJ.getInstance() != null) {
            s = s + IJ.getInstance().getInfo() + "\n \n";
        }
        s = s + "Title: " + imp.getTitle() + "\n";
        Calibration cal = imp.getCalibration();
        int stackSize = imp.getStackSize();
        int channels = imp.getNChannels();
        int slices = imp.getNSlices();
        int frames = imp.getNFrames();
        int digits = imp.getBitDepth() == 32 ? 4 : 0;
        boolean nonUniformUnits = !cal.getXUnit().equals(cal.getYUnit());
        String xunit = cal.getXUnit();
        String yunit = cal.getYUnit();
        String zunit = cal.getZUnit();
        if (cal.scaled()) {
            String xunits;
            String yunits = xunits = cal.getUnits();
            String zunits = xunits;
            if (nonUniformUnits) {
                xunits = xunit;
                yunits = yunit;
                zunits = zunit;
            }
            double pw = (double)imp.getWidth() * cal.pixelWidth;
            double ph = (double)imp.getHeight() * cal.pixelHeight;
            s = s + "Width:  " + this.d2s(pw) + " " + xunits + " (" + imp.getWidth() + ")\n";
            s = s + "Height:  " + this.d2s(ph) + " " + yunits + " (" + imp.getHeight() + ")\n";
            if (slices > 1) {
                double pd = (double)slices * cal.pixelDepth;
                s = s + "Depth:  " + this.d2s(pd) + " " + zunits + " (" + slices + ")\n";
            }
            s = s + "Size:  " + ImageWindow.getImageSize(imp) + "\n";
            double xResolution = 1.0 / cal.pixelWidth;
            double yResolution = 1.0 / cal.pixelHeight;
            if (xResolution == yResolution) {
                s = s + "Resolution:  " + this.d2s(xResolution) + " pixels per " + xunit + "\n";
            } else {
                s = s + "X Resolution:  " + this.d2s(xResolution) + " pixels per " + xunit + "\n";
                s = s + "Y Resolution:  " + this.d2s(yResolution) + " pixels per " + yunit + "\n";
            }
        } else {
            s = s + "Width:  " + imp.getWidth() + " pixels\n";
            s = s + "Height:  " + imp.getHeight() + " pixels\n";
            if (stackSize > 1) {
                s = s + "Depth:  " + slices + " pixels\n";
            }
            s = s + "Size:  " + ImageWindow.getImageSize(imp) + "\n";
        }
        if (stackSize > 1) {
            String vunit = cal.getUnit() + "^3";
            if (nonUniformUnits) {
                vunit = "(" + xunit + " x " + yunit + " x " + zunit + ")";
            }
            s = s + "Voxel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + "x" + this.d2s(cal.pixelDepth) + " " + vunit + "\n";
        } else {
            String punit = cal.getUnit() + "^2";
            if (nonUniformUnits) {
                punit = "(" + xunit + " x " + yunit + ")";
            }
            int dp = Tools.getDecimalPlaces(cal.pixelWidth, cal.pixelHeight);
            s = s + "Pixel size: " + this.d2s(cal.pixelWidth) + "x" + this.d2s(cal.pixelHeight) + " " + punit + "\n";
        }
        s = s + "ID: " + imp.getID() + "\n";
        int type = imp.getType();
        switch (type) {
            case 0: {
                s = s + "Bits per pixel: 8 ";
                String lut = "LUT";
                lut = imp.getProcessor().isColorLut() ? "color " + lut : "grayscale " + lut;
                if (imp.isInvertedLut()) {
                    lut = "inverting " + lut;
                }
                s = s + "(" + lut + ")\n";
                if (imp.getNChannels() > 1) {
                    s = s + this.displayRanges(imp);
                    break;
                }
                s = s + "Display range: " + (int)ip.getMin() + "-" + (int)ip.getMax() + "\n";
                break;
            }
            case 1: 
            case 2: {
                if (type == 1) {
                    String sign = cal.isSigned16Bit() ? "signed" : "unsigned";
                    s = s + "Bits per pixel: 16 (" + sign + ")\n";
                } else {
                    s = s + "Bits per pixel: 32 (float)\n";
                }
                if (imp.getNChannels() > 1) {
                    s = s + this.displayRanges(imp);
                    break;
                }
                s = s + "Display range: ";
                double min = ip.getMin();
                double max = ip.getMax();
                if (cal.calibrated()) {
                    min = cal.getCValue((int)min);
                    max = cal.getCValue((int)max);
                }
                s = s + this.d2s(min) + " - " + this.d2s(max) + "\n";
                break;
            }
            case 3: {
                s = s + "Bits per pixel: 8 (color LUT)\n";
                break;
            }
            case 4: {
                s = s + "Bits per pixel: 32 (RGB)\n";
            }
        }
        double interval = cal.frameInterval;
        double fps = cal.fps;
        if (stackSize > 1) {
            ImageStack stack = imp.getStack();
            int slice = imp.getCurrentSlice();
            String number = slice + "/" + stackSize;
            String label = stack.getSliceLabel(slice);
            if (label != null && label.contains("\n")) {
                label = stack.getShortSliceLabel(slice);
            }
            label = label != null && label.length() > 0 ? " (" + label + ")" : "";
            if (interval > 0.0 || fps != 0.0) {
                s = s + "Frame: " + number + label + "\n";
                if (fps != 0.0) {
                    String sRate = Math.abs(fps - (double)Math.round(fps)) < 1.0E-5 ? IJ.d2s(fps, 0) : IJ.d2s(fps, 5);
                    s = s + "Frame rate: " + sRate + " fps\n";
                }
                if (interval != 0.0) {
                    s = s + "Frame interval: " + ((double)((int)interval) == interval ? IJ.d2s(interval, 0) : IJ.d2s(interval, 5)) + " " + cal.getTimeUnit() + "\n";
                }
            } else {
                s = s + "Image: " + number + label + "\n";
            }
            if (imp.isHyperStack()) {
                if (channels > 1) {
                    s = s + "  Channel: " + imp.getChannel() + "/" + channels + "\n";
                }
                if (slices > 1) {
                    s = s + "  Slice: " + imp.getSlice() + "/" + slices + "\n";
                }
                if (frames > 1) {
                    s = s + "  Frame: " + imp.getFrame() + "/" + frames + "\n";
                }
            }
            if (imp.isComposite()) {
                if (!imp.isHyperStack() && channels > 1) {
                    s = s + "  Channels: " + channels + "\n";
                }
                String mode = ((CompositeImage)imp).getModeAsString();
                s = s + "  Composite mode: \"" + mode + "\"\n";
            }
            if (stack.isVirtual()) {
                String stackType = "virtual";
                if (stack instanceof AVI_Reader) {
                    stackType = stackType + " (AVI Reader)";
                }
                if (stack instanceof FileInfoVirtualStack) {
                    stackType = stackType + " (FileInfoVirtualStack)";
                }
                if (stack instanceof ListVirtualStack) {
                    stackType = stackType + " (ListVirtualStack)";
                }
                s = s + "Stack type: " + stackType + "\n";
            }
        }
        if (imp.isLocked()) {
            s = s + "**Locked**\n";
        }
        if (ip.getMinThreshold() == -808080.0) {
            s = s + "No threshold\n";
        } else {
            double lower = ip.getMinThreshold();
            double upper = ip.getMaxThreshold();
            String uncalibrated = "";
            if (cal.calibrated()) {
                uncalibrated = " (" + (int)lower + "-" + (int)upper + ")";
                lower = cal.getCValue((int)lower);
                upper = cal.getCValue((int)upper);
            }
            int lutMode = ip.getLutUpdateMode();
            String mode = "red";
            switch (lutMode) {
                case 1: {
                    mode = "B&W";
                    break;
                }
                case 2: {
                    mode = "invisible";
                    break;
                }
                case 3: {
                    mode = "over/under";
                }
            }
            s = s + "Threshold: " + this.d2s(lower) + "-" + this.d2s(upper) + uncalibrated + " (" + mode + ")\n";
        }
        ImageCanvas ic = imp.getCanvas();
        double d = mag = ic != null ? ic.getMagnification() : 1.0;
        if (mag != 1.0) {
            s = s + "Magnification: " + IJ.d2s(mag, 2) + "\n";
        }
        if (ic != null) {
            s = s + "ScaleToFit: " + ic.getScaleToFit() + "\n";
        }
        String valueUnit = cal.getValueUnit();
        if (cal.calibrated()) {
            s = s + " \n";
            int curveFit = cal.getFunction();
            s = s + "Calibration function: ";
            s = curveFit == 21 ? s + "Uncalibrated OD\n" : (curveFit == 22 ? s + "Custom lookup table\n" : s + CurveFitter.fList[curveFit] + "\n");
            double[] c = cal.getCoefficients();
            if (c != null) {
                s = s + "  a: " + IJ.d2s(c[0], 6) + "\n";
                s = s + "  b: " + IJ.d2s(c[1], 6) + "\n";
                if (c.length >= 3) {
                    s = s + "  c: " + IJ.d2s(c[2], 6) + "\n";
                }
                if (c.length >= 4) {
                    s = s + "  c: " + IJ.d2s(c[3], 6) + "\n";
                }
                if (c.length >= 5) {
                    s = s + "  c: " + IJ.d2s(c[4], 6) + "\n";
                }
            }
            s = s + "  Unit: \"" + valueUnit + "\"\n";
        } else if (valueUnit != null && !valueUnit.equals("Gray Value")) {
            s = s + "Calibration function: None\n";
            s = s + "  Unit: \"" + valueUnit + "\"\n";
        } else {
            s = s + "Uncalibrated\n";
        }
        FileInfo fi = imp.getOriginalFileInfo();
        if (fi != null) {
            if (fi.url != null && !fi.url.equals("")) {
                s = s + "URL: " + fi.url + "\n";
            } else {
                String defaultDir;
                String string = defaultDir = fi.directory == null || fi.directory.length() == 0 ? System.getProperty("user.dir") : "";
                if (defaultDir.length() > 0) {
                    defaultDir = defaultDir.replaceAll("\\\\", "/");
                    defaultDir = defaultDir + "/";
                }
                s = s + "Path: " + defaultDir + fi.getFilePath() + "\n";
            }
        }
        if ((win = imp.getWindow()) != null) {
            Point loc = win.getLocation();
            Rectangle bounds = GUI.getScreenBounds(win);
            s = s + "Screen location: " + (loc.x - bounds.x) + "," + (loc.y - bounds.y) + " (" + bounds.width + "x" + bounds.height + ")\n";
        }
        if (IJ.isMacOSX()) {
            String time = " (" + ImageWindow.setMenuBarTime + "ms)";
            s = s + "SetMenuBarCount: " + Menus.setMenuBarCount + time + "\n";
        }
        String zOrigin = stackSize > 1 || cal.zOrigin != 0.0 ? "," + this.d2s(cal.zOrigin) : "";
        String origin = this.d2s(cal.xOrigin) + "," + this.d2s(cal.yOrigin) + zOrigin;
        if (!origin.equals("0,0") || cal.getInvertY()) {
            s = s + "Coordinate origin:  " + origin + "\n";
        }
        if (cal.getInvertY()) {
            s = s + "Inverted y coordinates\n";
        }
        if ((overlay = imp.getOverlay()) != null) {
            int n = overlay.size();
            String elements = n == 1 ? " element" : " elements";
            String selectable = overlay.isSelectable() ? " selectable " : " non-selectable ";
            String hidden = imp.getHideOverlay() ? " (hidden)" : "";
            s = s + "Overlay: " + n + selectable + elements + hidden + "\n";
        } else {
            s = s + "No overlay\n";
        }
        Interpreter interp = Interpreter.getInstance();
        if (interp != null) {
            s = s + "Macro is running" + (Interpreter.isBatchMode() ? " in batch mode" : "") + "\n";
        }
        if ((roi = imp.getRoi()) == null) {
            if (cal.calibrated()) {
                s = s + " \n";
            }
            s = s + "No selection\n";
        } else if (roi instanceof RotatedRectRoi) {
            s = s + "\nRotated rectangle selection\n";
            p = ((RotatedRectRoi)roi).getParams();
            double dx = p[2] - p[0];
            double dy = p[3] - p[1];
            double major = Math.sqrt(dx * dx + dy * dy);
            s = s + "  Length: " + IJ.d2s(major, 2) + "\n";
            s = s + "  Width: " + IJ.d2s(p[4], 2) + "\n";
            s = s + "  X1: " + IJ.d2s(p[0], 2) + "\n";
            s = s + "  Y1: " + IJ.d2s(p[1], 2) + "\n";
            s = s + "  X2: " + IJ.d2s(p[2], 2) + "\n";
            s = s + "  Y2: " + IJ.d2s(p[3], 2) + "\n";
        } else if (roi instanceof EllipseRoi) {
            s = s + "\nElliptical selection\n";
            p = ((EllipseRoi)roi).getParams();
            double dx = p[2] - p[0];
            double dy = p[3] - p[1];
            double major = Math.sqrt(dx * dx + dy * dy);
            s = s + "  Major: " + IJ.d2s(major, 2) + "\n";
            s = s + "  Minor: " + IJ.d2s(major * p[4], 2) + "\n";
            s = s + "  X1: " + IJ.d2s(p[0], 2) + "\n";
            s = s + "  Y1: " + IJ.d2s(p[1], 2) + "\n";
            s = s + "  X2: " + IJ.d2s(p[2], 2) + "\n";
            s = s + "  Y2: " + IJ.d2s(p[3], 2) + "\n";
            s = s + "  Aspect ratio: " + IJ.d2s(p[4], 2) + "\n";
        } else {
            String name;
            s = s + " \n";
            s = s + roi.getTypeAsString() + " Selection";
            String points = null;
            if (roi instanceof PointRoi) {
                int npoints = ((PolygonRoi)roi).getNCoordinates();
                String suffix = npoints > 1 ? "s)" : ")";
                points = " (" + npoints + " point" + suffix;
            }
            if ((name = roi.getName()) != null) {
                s = s + " (\"" + name + "\")";
                if (points != null) {
                    s = s + "\n " + points;
                }
            } else if (points != null) {
                s = s + points;
            }
            s = s + "\n";
            Rectangle r = roi.getBounds();
            if (roi instanceof Line) {
                Line line = (Line)roi;
                s = s + "  X1: " + IJ.d2s(line.x1d * cal.pixelWidth) + "\n";
                s = s + "  Y1: " + IJ.d2s(this.yy(line.y1d, imp) * cal.pixelHeight) + "\n";
                s = s + "  X2: " + IJ.d2s(line.x2d * cal.pixelWidth) + "\n";
                s = s + "  Y2: " + IJ.d2s(this.yy(line.y2d, imp) * cal.pixelHeight) + "\n";
            } else if (cal.scaled()) {
                s = s + "  X: " + IJ.d2s(cal.getX(r.x)) + " (" + r.x + ")\n";
                s = s + "  Y: " + IJ.d2s(cal.getY(r.y, imp.getHeight())) + " (" + r.y + ")\n";
                s = s + "  Width: " + IJ.d2s((double)r.width * cal.pixelWidth) + " (" + r.width + ")\n";
                s = s + "  Height: " + IJ.d2s((double)r.height * cal.pixelHeight) + " (" + r.height + ")\n";
            } else {
                s = s + "  X: " + r.x + "\n";
                s = s + "  Y: " + this.yy(r.y, imp) + "\n";
                s = s + "  Width: " + r.width + "\n";
                s = s + "  Height: " + r.height + "\n";
            }
        }
        return s;
    }

    private String displayRanges(ImagePlus imp) {
        LUT[] luts = imp.getLuts();
        if (luts == null) {
            return "";
        }
        String s = "Display ranges\n";
        int n = luts.length;
        if (n > 7) {
            n = 7;
        }
        for (int i = 0; i < n; ++i) {
            double min = luts[i].min;
            double max = luts[i].max;
            s = s + "  " + (i + 1) + ": " + this.d2s(min) + "-" + this.d2s(max) + "\n";
        }
        return s;
    }

    private int yy(int y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    private double yy(double y, ImagePlus imp) {
        return Analyzer.updateY(y, imp.getHeight());
    }

    private void showInfo(ImagePlus imp, String info, int width, int height) {
        new TextWindow("Info for " + imp.getTitle(), info, width, height);
    }

    private String d2s(double n) {
        return IJ.d2s(n, Tools.getDecimalPlaces(n));
    }
}

