/*
 * Decompiled with CFR 0.152.
 */
package mcib3d.utils;

import java.util.Date;

public final class Chrono {
    private Date D1Start = new Date();
    private Date D1Temp = new Date();
    private Date D2 = new Date();
    private int nbTasksTotal;
    private int nbTasksCompleted;
    private long minDelayToShow = 500L;

    public Chrono() {
        this.nbTasksTotal = -1;
        this.nbTasksCompleted = -1;
    }

    public Chrono(int nbt) {
        this.nbTasksTotal = nbt;
        this.nbTasksCompleted = 0;
    }

    public void start() {
        this.D1Start = new Date();
        this.D2 = new Date();
    }

    public void stop() {
        this.D2 = new Date();
    }

    public long delay() {
        return this.D2.getTime() - this.D1Start.getTime();
    }

    public String delayString() {
        return this.timeString(this.delay());
    }

    public long remain(int nb) {
        long delay = this.D2.getTime() - this.D1Start.getTime();
        long remain = (long)((float)delay * ((float)this.nbTasksTotal / (float)nb - 1.0f));
        return remain;
    }

    public String remainString(int nb) {
        return this.timeString(this.remain(nb));
    }

    public long totalTimeEstimate(int nb) {
        long delay = this.delay();
        long total = (long)((float)delay * ((float)this.nbTasksTotal / (float)nb));
        return total;
    }

    public String remainingTimeEstimate(int nb) {
        long delay = this.delay();
        long total = (long)((float)delay * ((float)(this.nbTasksTotal - nb) / (float)nb));
        return this.timeString(total);
    }

    public String totalTimeEstimateString(int nb) {
        return this.timeString(this.totalTimeEstimate(nb));
    }

    public synchronized String getFullInfo(int nbTasks) {
        this.D2 = new Date();
        this.nbTasksCompleted += nbTasks;
        if (this.D2.getTime() - this.D1Temp.getTime() > this.minDelayToShow) {
            String res = new String("" + this.nbTasksCompleted + "/" + this.nbTasksTotal + " (" + this.remainingTimeEstimate(this.nbTasksCompleted) + " ETC)");
            this.D1Temp = new Date();
            return res;
        }
        return null;
    }

    private String timeString(long delay) {
        String res;
        if (delay < 1000L) {
            res = new String(delay + " ms");
        } else {
            long d1 = delay / 1000L;
            long ms = delay - d1 * 1000L;
            if (d1 < 60L) {
                res = new String(d1 + " s " + ms + " ms");
            } else {
                long d2 = d1 / 60L;
                long reste = d1 - d2 * 60L;
                if (d2 < 60L) {
                    res = new String(d2 + " min " + reste + " s");
                } else {
                    long d3 = d2 / 60L;
                    long r2 = d2 - d3 * 60L;
                    if (d3 < 24L) {
                        res = new String(d3 + " h " + r2 + " min " + reste + " s");
                    } else {
                        long d4 = d3 / 24L;
                        res = new String(d4 + " j " + d3 + " h " + r2 + " min " + reste + " s");
                    }
                }
            }
        }
        return res;
    }
}

