/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.dialog;

import icy.file.FileUtil;
import icy.file.ImageFileFormat;
import icy.file.Saver;
import icy.gui.dialog.ConfirmDialog;
import icy.gui.dialog.SaverOptionPanel;
import icy.main.Icy;
import icy.preferences.ApplicationPreferences;
import icy.preferences.XMLPreferences;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.util.StringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import loci.formats.IFormatWriter;
import loci.formats.gui.ExtensionFileFilter;

public class SaverDialog
extends JFileChooser {
    private static final String PREF_ID = "frame/imageSaver";
    private static final String ID_WIDTH = "width";
    private static final String ID_HEIGHT = "height";
    private static final String ID_PATH = "path";
    private static final String ID_MULTIPLEFILE = "multipleFile";
    private static final String ID_OVERWRITENAME = "overwriteName";
    private static final String ID_FPS = "fps";
    private static final String ID_EXTENSION = "extension";
    private SaverOptionPanel settingPanel;
    private final XMLPreferences preferences = ApplicationPreferences.getPreferences().node("frame/imageSaver");
    private final boolean singleZ;
    private final boolean singleT;
    private final boolean singleImage;

    public SaverDialog(Sequence sequence, boolean autoSave) {
        int value;
        this.singleZ = sequence.getSizeZ() == 1;
        this.singleT = sequence.getSizeT() == 1;
        this.singleImage = this.singleZ && this.singleT;
        this.setCurrentDirectory(new File(this.preferences.get(ID_PATH, "")));
        this.setPreferredSize(new Dimension(this.preferences.getInt(ID_WIDTH, 600), this.preferences.getInt(ID_HEIGHT, 400)));
        this.setDialogTitle("Save image file");
        this.removeChoosableFileFilter(this.getAcceptAllFileFilter());
        this.addChoosableFileFilter(ImageFileFormat.TIFF.getExtensionFileFilter());
        this.addChoosableFileFilter(ImageFileFormat.PNG.getExtensionFileFilter());
        this.addChoosableFileFilter(ImageFileFormat.JPG.getExtensionFileFilter());
        this.addChoosableFileFilter(ImageFileFormat.AVI.getExtensionFileFilter());
        this.setFileFilter(this.getFileFilter(this.preferences.get(ID_EXTENSION, ImageFileFormat.TIFF.getDescription())));
        this.setMultiSelectionEnabled(false);
        this.setFileSelectionMode(0);
        String filename = sequence.getName();
        if (StringUtil.isEmpty(filename) || filename.startsWith("no name")) {
            filename = FileUtil.getFileName(sequence.getOutputFilename(false), false);
        }
        if (!StringUtil.isEmpty(filename)) {
            String ext = this.getDialogExtension(filename = FileUtil.cleanPath(filename.replaceAll("/", " ").replaceAll("\\\\", " ")));
            if (ext != null) {
                FileUtil.setExtension(filename, "");
            }
            this.setSelectedFile(new File(filename));
        }
        this.settingPanel = new SaverOptionPanel();
        this.settingPanel.setMultipleFiles(this.preferences.getBoolean(ID_MULTIPLEFILE, false));
        this.settingPanel.setOverwriteMetadata(this.preferences.getBoolean(ID_OVERWRITENAME, true));
        double ti = sequence.getTimeInterval() * 1000.0;
        if (ti != 0.0) {
            this.settingPanel.setTimeInterval(ti);
        } else {
            this.settingPanel.setFramePerSecond(this.preferences.getInt(ID_FPS, 20));
        }
        this.setAccessory(this.settingPanel);
        this.updateSettingPanel();
        this.addPropertyChangeListener("fileFilterChanged", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SaverDialog.this.updateSettingPanel();
            }
        });
        ImageFileFormat fileFormat = null;
        IFormatWriter writer = null;
        boolean accepted = false;
        while (!accepted && (value = this.showSaveDialog((Component)((Object)Icy.getMainInterface().getMainFrame()))) == 0) {
            fileFormat = this.getSelectedFileFormat();
            writer = Saver.getWriter(fileFormat);
            if (!this.isCompatible(fileFormat, sequence)) {
                accepted = ConfirmDialog.confirm("Warning", "Some information will be lost in the " + (Object)((Object)fileFormat) + " saved file(s). Do you want to continue ?");
                continue;
            }
            accepted = true;
        }
        if (accepted) {
            File file = this.getSelectedFile();
            String outFilename = file.getAbsolutePath();
            if (this.isFolderRequired()) {
                file = new File(FileUtil.setExtension(outFilename, ""));
                this.setSelectedFile(file);
            } else {
                ExtensionFileFilter extensionFilter = (ExtensionFileFilter)this.getFileFilter();
                if (!SaverDialog.hasExtension(outFilename.toLowerCase(), extensionFilter)) {
                    file = new File(outFilename + "." + extensionFilter.getExtension());
                    this.setSelectedFile(file);
                }
            }
            if (autoSave && (!file.exists() || ConfirmDialog.confirm("Overwrite existing file(s) ?"))) {
                if (file.exists()) {
                    FileUtil.delete(file, true);
                }
                this.preferences.put(ID_PATH, this.getCurrentDirectory().getAbsolutePath());
                if (this.isOverwriteNameEnabled()) {
                    sequence.setName(FileUtil.getFileName(file.getAbsolutePath(), false));
                }
                final Sequence s = sequence;
                final File f = file;
                final IFormatWriter w = writer;
                ThreadUtil.bgRun(new Runnable(){

                    @Override
                    public void run() {
                        Saver.save(w, s, f, SaverDialog.this.getFps(), SaverDialog.this.isSaveAsMultipleFilesEnabled(), true, true);
                    }
                });
            }
            this.preferences.putInt(ID_WIDTH, this.getWidth());
            this.preferences.putInt(ID_HEIGHT, this.getHeight());
            if (fileFormat == ImageFileFormat.TIFF) {
                this.preferences.putBoolean(ID_MULTIPLEFILE, this.isSaveAsMultipleFilesEnabled());
            }
            this.preferences.putBoolean(ID_OVERWRITENAME, this.settingPanel.getOverwriteMetadata());
            if (fileFormat == ImageFileFormat.AVI) {
                this.preferences.putInt(ID_FPS, this.getFps());
            }
            this.preferences.put(ID_EXTENSION, this.getFileFilter().getDescription());
        }
    }

    public SaverDialog(Sequence sequence) {
        this(sequence, true);
    }

    @Deprecated
    public SaverDialog(Sequence sequence, int defZ, int defT, boolean autoSave) {
        this(sequence, autoSave);
    }

    @Deprecated
    public SaverDialog(Sequence sequence, int defZ, int defT) {
        this(sequence, true);
    }

    protected FileFilter getFileFilter(String description) {
        FileFilter[] filters;
        for (FileFilter filter : filters = this.getChoosableFileFilters()) {
            if (!StringUtil.equals(filter.getDescription(), description)) continue;
            return filter;
        }
        return ImageFileFormat.TIFF.getExtensionFileFilter();
    }

    private static boolean hasExtension(String name, ExtensionFileFilter extensionFilter) {
        return SaverDialog.getExtension(name, extensionFilter) != null;
    }

    private static String getExtension(String name, ExtensionFileFilter extensionFilter) {
        for (String ext : extensionFilter.getExtensions()) {
            if (!name.endsWith(ext.toLowerCase())) continue;
            return ext;
        }
        return null;
    }

    private String getDialogExtension(String name) {
        for (FileFilter filter : this.getChoosableFileFilters()) {
            String ext = SaverDialog.getExtension(name, (ExtensionFileFilter)filter);
            if (ext == null) continue;
            return ext;
        }
        return null;
    }

    public ImageFileFormat getSelectedFileFormat() {
        FileFilter ff = this.getFileFilter();
        if (ff == null || !(ff instanceof ExtensionFileFilter)) {
            return ImageFileFormat.TIFF;
        }
        return ImageFileFormat.getWriteFormat(((ExtensionFileFilter)ff).getExtension(), ImageFileFormat.TIFF);
    }

    public boolean isFolderRequired() {
        return !this.singleImage && this.isSaveAsMultipleFilesEnabled();
    }

    public boolean isSaveAsMultipleFilesEnabled() {
        return this.settingPanel.isMultipleFilesVisible() && this.settingPanel.getMultipleFiles();
    }

    public boolean isOverwriteNameEnabled() {
        return this.settingPanel.isOverwriteMetadataVisible() && this.settingPanel.getOverwriteMetadata();
    }

    public int getFps() {
        if (this.settingPanel.isFramePerSecondVisible()) {
            return this.settingPanel.getFramePerSecond();
        }
        return 1;
    }

    public double getTimeInterval() {
        if (this.settingPanel.isFramePerSecondVisible()) {
            return this.settingPanel.getTimeInterval();
        }
        return 100.0;
    }

    @Deprecated
    public int getZMin() {
        return 0;
    }

    @Deprecated
    public int getZMax() {
        return 0;
    }

    @Deprecated
    public int getTMin() {
        return 0;
    }

    @Deprecated
    public int getTMax() {
        return 0;
    }

    void updateSettingPanel() {
        ImageFileFormat fileFormat = this.getSelectedFileFormat();
        if (this.singleImage) {
            this.settingPanel.setMultipleFilesVisible(false);
            this.settingPanel.setForcedMultipleFilesOff();
        } else {
            switch (fileFormat) {
                case AVI: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.setForcedMultipleFilesOff();
                    break;
                }
                case JPG: 
                case PNG: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.setForcedMultipleFilesOn();
                    break;
                }
                case TIFF: {
                    this.settingPanel.setMultipleFilesVisible(true);
                    this.settingPanel.removeForcedMultipleFiles();
                    this.settingPanel.setMultipleFiles(this.preferences.getBoolean(ID_MULTIPLEFILE, false));
                }
            }
        }
        this.settingPanel.setFramePerSecondVisible(fileFormat == ImageFileFormat.AVI);
    }

    private boolean isCompatible(ImageFileFormat fileFormat, Sequence sequence) {
        if (fileFormat == ImageFileFormat.AVI && !this.singleZ) {
            return false;
        }
        return Saver.isCompatible(fileFormat, sequence.getColorModel());
    }
}

