/*
 * Decompiled with CFR 0.152.
 */
package plugins.tprovoost.Microscopy.MicroManager.tools;

import icy.preferences.XMLPreferences;
import icy.roi.ROI2D;
import icy.sequence.Sequence;
import icy.system.thread.ThreadUtil;
import icy.type.point.Point3D;
import icy.util.StringUtil;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import plugins.tprovoost.Microscopy.MicroManager.MicroManager;

public class StageMover {
    private static List<StageListener> _listeners = new ArrayList<StageListener>();
    private static boolean invertX = false;
    private static boolean invertY = false;
    private static boolean invertZ = false;
    private static boolean switchXY = false;
    private static XMLPreferences prefs;
    private static final String INVERTX = "invertx";
    private static final String INVERTY = "inverty";
    private static final String INVERTZ = "invertz";
    private static final String SWITCHXY = "switchxy";

    public static void loadPreferences(XMLPreferences pref) {
        prefs = pref;
        invertX = prefs.getBoolean(INVERTX, false);
        invertY = prefs.getBoolean(INVERTY, false);
        invertZ = prefs.getBoolean(INVERTZ, false);
        switchXY = prefs.getBoolean(SWITCHXY, false);
    }

    public static void addListener(StageListener sl) {
        _listeners.add(sl);
    }

    public static void removeListener(StageListener sl) {
        _listeners.remove(sl);
    }

    public static void clearListener() {
        _listeners.clear();
    }

    public static void setInvertX(boolean invertX) {
        StageMover.invertX = invertX;
        prefs.putBoolean(INVERTX, invertX);
    }

    public static void setInvertY(boolean invertY) {
        StageMover.invertY = invertY;
        prefs.putBoolean(INVERTY, invertY);
    }

    public static void setInvertZ(boolean invertZ) {
        StageMover.invertZ = invertZ;
        prefs.putBoolean(INVERTZ, invertZ);
    }

    public static boolean isInvertX() {
        return invertX;
    }

    public static boolean isInvertY() {
        return invertY;
    }

    public static boolean isInvertZ() {
        return invertZ;
    }

    public static void setSwitchXY(boolean switchXY) {
        StageMover.switchXY = switchXY;
        prefs.putBoolean(SWITCHXY, switchXY);
    }

    public static boolean isSwitchXY() {
        return switchXY;
    }

    public static void onStagePositionChanged(String s, double z) {
        for (StageListener l : _listeners) {
            l.onStagePositionChanged(s, z);
        }
    }

    public static void onXYStagePositionChanged(String s, double x, double y) {
        for (StageListener l : _listeners) {
            l.onXYStagePositionChanged(s, x, y);
        }
    }

    public static String getXYStageDevice() {
        return MicroManager.getCore().getXYStageDevice();
    }

    public static String getZFocusDevice() {
        return MicroManager.getCore().getFocusDevice();
    }

    public static void waitXYToRespond() throws Exception {
        String device = StageMover.getXYStageDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.waitForDevice(device);
        }
    }

    public static void waitZToRespond() throws Exception {
        String device = StageMover.getZFocusDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.waitForDevice(device);
        }
    }

    public static double getX() throws Exception {
        String device = StageMover.getXYStageDevice();
        if (StringUtil.isEmpty((String)device)) {
            return 0.0;
        }
        return MicroManager.getCore().getXPosition(device);
    }

    public static double getY() throws Exception {
        String device = StageMover.getXYStageDevice();
        if (StringUtil.isEmpty((String)device)) {
            return 0.0;
        }
        return MicroManager.getCore().getYPosition(device);
    }

    public static double getZ() throws Exception {
        String device = StageMover.getZFocusDevice();
        if (StringUtil.isEmpty((String)device)) {
            return 0.0;
        }
        return MicroManager.getCore().getPosition(device);
    }

    public static Point2D.Double getXY() throws Exception {
        String device = StageMover.getXYStageDevice();
        if (StringUtil.isEmpty((String)device)) {
            return new Point2D.Double(0.0, 0.0);
        }
        return MicroManager.getCore().getXYStagePosition(device);
    }

    public static Point3D.Double getXYZ() throws Exception {
        Point2D.Double pt2d = StageMover.getXY();
        return new Point3D.Double(pt2d.x, pt2d.y, StageMover.getZ());
    }

    public static double[] getXYZAsDoubleArray() throws Exception {
        Point3D.Double pt = StageMover.getXYZ();
        return new double[]{pt.x, pt.y, pt.z};
    }

    public static boolean waitXYMoving() throws Exception {
        long start = System.currentTimeMillis();
        Point2D.Double last = StageMover.getXY();
        while (System.currentTimeMillis() - start < 5000L) {
            Point2D.Double current = StageMover.getXY();
            if (current.distance(last) < 0.05) {
                return true;
            }
            last = current;
            ThreadUtil.sleep((int)100);
        }
        return false;
    }

    public static boolean waitZMoving() throws Exception {
        long start = System.currentTimeMillis();
        double last = StageMover.getZ();
        while (System.currentTimeMillis() - start < 5000L) {
            double current = StageMover.getZ();
            if (Math.abs(last - current) < 0.05) {
                return true;
            }
            last = current;
            ThreadUtil.sleep((int)100);
        }
        return false;
    }

    public static void stopXYStage() throws Exception {
        String device = StageMover.getXYStageDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.lock();
            try {
                MicroManager.getCore().stop(device);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static void stopZFocus() throws Exception {
        String device = StageMover.getZFocusDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.lock();
            try {
                MicroManager.getCore().stop(device);
            }
            finally {
                MicroManager.unlock();
            }
        }
    }

    public static void moveZAbsolute(double position) throws Exception {
        StageMover.moveZAbsolute(position, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveZAbsolute(double position, boolean wait) throws Exception {
        String device = StageMover.getZFocusDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.waitForDevice(device);
            MicroManager.lock();
            try {
                MicroManager.getCore().setPosition(device, position);
            }
            finally {
                MicroManager.unlock();
            }
            if (wait) {
                MicroManager.waitForDevice(device);
            }
        }
    }

    public static void moveXYAbsolute(double posX, double posY) throws Exception {
        StageMover.moveXYAbsolute(posX, posY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveXYAbsolute(double posX, double posY, boolean wait) throws Exception {
        String device = StageMover.getXYStageDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.waitForDevice(device);
            MicroManager.lock();
            try {
                MicroManager.getCore().setXYPosition(device, posX, posY);
            }
            finally {
                MicroManager.unlock();
            }
            if (wait) {
                MicroManager.waitForDevice(device);
            }
        }
    }

    public static void moveZRelative(double movement) throws Exception {
        StageMover.moveZRelative(movement, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveZRelative(double movement, boolean wait) throws Exception {
        String device = StageMover.getZFocusDevice();
        if (!StringUtil.isEmpty((String)device)) {
            MicroManager.waitForDevice(device);
            MicroManager.lock();
            try {
                if (invertZ) {
                    MicroManager.getCore().setRelativePosition(device, -movement);
                } else {
                    MicroManager.getCore().setRelativePosition(device, movement);
                }
            }
            finally {
                MicroManager.unlock();
            }
            if (wait) {
                MicroManager.waitForDevice(device);
            }
        }
    }

    public static void moveXYRelative(double movX, double movY) throws Exception {
        StageMover.moveXYRelative(movX, movY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void moveXYRelative(double movX, double movY, boolean wait) throws Exception {
        String device = StageMover.getXYStageDevice();
        if (!StringUtil.isEmpty((String)device)) {
            int invXModifier = invertX ? -1 : 1;
            int invYModifier = invertY ? -1 : 1;
            MicroManager.waitForDevice(device);
            MicroManager.lock();
            try {
                if (switchXY) {
                    MicroManager.getCore().setRelativeXYPosition(device, movY * (double)invYModifier, movX * (double)invXModifier);
                } else {
                    MicroManager.getCore().setRelativeXYPosition(device, movX * (double)invXModifier, movY * (double)invYModifier);
                }
            }
            finally {
                MicroManager.unlock();
            }
            if (wait) {
                MicroManager.waitForDevice(device);
            }
        }
    }

    public static void moveStageToROI(Sequence s, ROI2D roi) throws Exception {
        if (roi == null) {
            return;
        }
        double vectx = roi.getBounds().getCenterX() - s.getBounds2D().getCenterX();
        double vecty = -(roi.getBounds().getCenterY() - s.getBounds2D().getCenterY());
        double pxsize = MicroManager.getCore().getPixelSizeUm();
        StageMover.moveXYRelative(vectx * pxsize, vecty * pxsize);
    }

    public static void moveToPoint(Sequence s, double x, double y) throws Exception {
        double vectx = x - s.getBounds2D().getCenterX();
        double vecty = y - s.getBounds2D().getCenterY();
        double pxsize = MicroManager.getCore().getPixelSizeUm();
        StageMover.moveXYRelative(vectx * pxsize, vecty * pxsize);
    }

    public static interface StageListener {
        public void onStagePositionChanged(String var1, double var2);

        public void onStagePositionChangedRelative(String var1, double var2);

        public void onXYStagePositionChanged(String var1, double var2, double var4);

        public void onXYStagePositionChangedRelative(String var1, double var2, double var4);
    }
}

