/*
 * Decompiled with CFR 0.152.
 */
package icy.gui.preferences;

import icy.gui.component.IcyTextField;
import icy.gui.preferences.PreferenceFrame;
import icy.gui.preferences.PreferencePanel;
import icy.preferences.ChatPreferences;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;

public class ChatPreferencePanel
extends PreferencePanel {
    private static final long serialVersionUID = 2856629717614258089L;
    public static final String NODE_NAME = "Chat";
    private IcyTextField realNameField;
    private JPasswordField passwordField;
    IcyTextField extraChannelsField;
    private JCheckBox connectAtStartCheckBox;
    private JCheckBox enableDesktopOverlayCheckBox;
    IcyTextField desktopChannelsField;
    private JCheckBox statusMessageCheckBox;

    public ChatPreferencePanel(PreferenceFrame parent) {
        super(parent, NODE_NAME, "Preferences");
        this.initialize();
        this.validate();
        this.load();
    }

    void initialize() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{46, 97, 0, 0, 18, 60, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, Double.MIN_VALUE};
        this.mainPanel.setLayout(gridBagLayout);
        this.connectAtStartCheckBox = new JCheckBox("Connect at start up");
        this.connectAtStartCheckBox.setToolTipText("Automatically connect when application starts");
        GridBagConstraints gbc_connectAtStartCheckBox = new GridBagConstraints();
        gbc_connectAtStartCheckBox.anchor = 17;
        gbc_connectAtStartCheckBox.gridwidth = 4;
        gbc_connectAtStartCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_connectAtStartCheckBox.gridx = 0;
        gbc_connectAtStartCheckBox.gridy = 0;
        this.mainPanel.add((Component)this.connectAtStartCheckBox, gbc_connectAtStartCheckBox);
        this.statusMessageCheckBox = new JCheckBox("Show status messages");
        this.statusMessageCheckBox.setToolTipText("Show chat status change messages");
        GridBagConstraints gbc_statusMessageCheckBox = new GridBagConstraints();
        gbc_statusMessageCheckBox.anchor = 17;
        gbc_statusMessageCheckBox.gridwidth = 4;
        gbc_statusMessageCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_statusMessageCheckBox.gridx = 0;
        gbc_statusMessageCheckBox.gridy = 1;
        this.mainPanel.add((Component)this.statusMessageCheckBox, gbc_statusMessageCheckBox);
        this.enableDesktopOverlayCheckBox = new JCheckBox("Enable desktop chat");
        this.enableDesktopOverlayCheckBox.setToolTipText("Display chat in the application desktop");
        GridBagConstraints gbc_enableDesktopOverlayCheckBox = new GridBagConstraints();
        gbc_enableDesktopOverlayCheckBox.anchor = 17;
        gbc_enableDesktopOverlayCheckBox.gridwidth = 2;
        gbc_enableDesktopOverlayCheckBox.insets = new Insets(0, 0, 5, 5);
        gbc_enableDesktopOverlayCheckBox.gridx = 0;
        gbc_enableDesktopOverlayCheckBox.gridy = 2;
        this.mainPanel.add((Component)this.enableDesktopOverlayCheckBox, gbc_enableDesktopOverlayCheckBox);
        this.desktopChannelsField = new IcyTextField();
        this.desktopChannelsField.setToolTipText("Channel(s) to display on dekstop chat. You can enter severals channels (ex : \"icy;icy-support\")");
        this.desktopChannelsField.setText("icy");
        GridBagConstraints gbc_desktopChannelsField = new GridBagConstraints();
        gbc_desktopChannelsField.gridwidth = 2;
        gbc_desktopChannelsField.insets = new Insets(0, 0, 5, 5);
        gbc_desktopChannelsField.fill = 2;
        gbc_desktopChannelsField.gridx = 2;
        gbc_desktopChannelsField.gridy = 2;
        this.mainPanel.add((Component)this.desktopChannelsField, gbc_desktopChannelsField);
        this.desktopChannelsField.setColumns(10);
        JButton btnDefault_1 = new JButton("Default");
        btnDefault_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPreferencePanel.this.desktopChannelsField.setText(ChatPreferences.getDefaultDesktopChannels());
            }
        });
        GridBagConstraints gbc_btnDefault_1 = new GridBagConstraints();
        gbc_btnDefault_1.insets = new Insets(0, 0, 5, 5);
        gbc_btnDefault_1.gridx = 5;
        gbc_btnDefault_1.gridy = 2;
        this.mainPanel.add((Component)btnDefault_1, gbc_btnDefault_1);
        JLabel lblNewLabel_2 = new JLabel("Real name");
        lblNewLabel_2.setToolTipText("Real name (give more information about user)");
        GridBagConstraints gbc_lblNewLabel_2 = new GridBagConstraints();
        gbc_lblNewLabel_2.anchor = 13;
        gbc_lblNewLabel_2.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_2.gridx = 0;
        gbc_lblNewLabel_2.gridy = 3;
        this.mainPanel.add((Component)lblNewLabel_2, gbc_lblNewLabel_2);
        this.realNameField = new IcyTextField();
        this.realNameField.setToolTipText("Real name (give more information about user)");
        GridBagConstraints gbc_realNameField = new GridBagConstraints();
        gbc_realNameField.fill = 2;
        gbc_realNameField.gridwidth = 3;
        gbc_realNameField.insets = new Insets(0, 0, 5, 5);
        gbc_realNameField.gridx = 1;
        gbc_realNameField.gridy = 3;
        this.mainPanel.add((Component)this.realNameField, gbc_realNameField);
        this.realNameField.setColumns(10);
        JLabel lblPassword = new JLabel("Password");
        lblPassword.setToolTipText("Password for registered nickname only");
        GridBagConstraints gbc_lblPassword = new GridBagConstraints();
        gbc_lblPassword.anchor = 13;
        gbc_lblPassword.insets = new Insets(0, 0, 5, 5);
        gbc_lblPassword.gridx = 0;
        gbc_lblPassword.gridy = 4;
        this.mainPanel.add((Component)lblPassword, gbc_lblPassword);
        this.passwordField = new JPasswordField();
        this.passwordField.setColumns(12);
        this.passwordField.setToolTipText("Password for registered nickname only");
        GridBagConstraints gbc_passwordField = new GridBagConstraints();
        gbc_passwordField.gridwidth = 3;
        gbc_passwordField.fill = 2;
        gbc_passwordField.insets = new Insets(0, 0, 5, 5);
        gbc_passwordField.gridx = 1;
        gbc_passwordField.gridy = 4;
        this.mainPanel.add((Component)this.passwordField, gbc_passwordField);
        JLabel lblChannels = new JLabel("Extra channels");
        lblChannels.setToolTipText("Extra channels to join at start up. You can enter severals channels (ex : \"icy-news;icy-support;others\")");
        GridBagConstraints gbc_lblChannels = new GridBagConstraints();
        gbc_lblChannels.anchor = 13;
        gbc_lblChannels.insets = new Insets(0, 0, 0, 5);
        gbc_lblChannels.gridx = 0;
        gbc_lblChannels.gridy = 5;
        this.mainPanel.add((Component)lblChannels, gbc_lblChannels);
        this.extraChannelsField = new IcyTextField();
        this.extraChannelsField.setToolTipText("Extra channel(s) to join at start up. You can enter severals channels (ex : \"icy-news;icy-support;...\")");
        GridBagConstraints gbc_channelsField = new GridBagConstraints();
        gbc_channelsField.gridwidth = 3;
        gbc_channelsField.insets = new Insets(0, 0, 0, 5);
        gbc_channelsField.fill = 2;
        gbc_channelsField.gridx = 1;
        gbc_channelsField.gridy = 5;
        this.mainPanel.add((Component)this.extraChannelsField, gbc_channelsField);
        this.extraChannelsField.setColumns(10);
        JButton btnDefault = new JButton("Default");
        btnDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChatPreferencePanel.this.extraChannelsField.setText(ChatPreferences.getDefaultExtraChannels());
            }
        });
        GridBagConstraints gbc_btnDefault = new GridBagConstraints();
        gbc_btnDefault.insets = new Insets(0, 0, 0, 5);
        gbc_btnDefault.gridx = 5;
        gbc_btnDefault.gridy = 5;
        this.mainPanel.add((Component)btnDefault, gbc_btnDefault);
    }

    @Override
    protected void load() {
        this.realNameField.setText(ChatPreferences.getRealname());
        this.passwordField.setText(ChatPreferences.getUserPassword());
        this.extraChannelsField.setText(ChatPreferences.getExtraChannels());
        this.connectAtStartCheckBox.setSelected(ChatPreferences.getAutoConnect());
        this.statusMessageCheckBox.setSelected(ChatPreferences.getShowStatusMessages());
        this.enableDesktopOverlayCheckBox.setSelected(ChatPreferences.getDesktopOverlay());
        this.desktopChannelsField.setText(ChatPreferences.getDesktopChannels());
    }

    @Override
    protected void save() {
        ChatPreferences.setRealname(this.realNameField.getText());
        ChatPreferences.setUserPassword(new String(this.passwordField.getPassword()));
        ChatPreferences.setExtraChannels(this.extraChannelsField.getText());
        ChatPreferences.setAutoConnect(this.connectAtStartCheckBox.isSelected());
        ChatPreferences.setShowStatusMessages(this.statusMessageCheckBox.isSelected());
        ChatPreferences.setDesktopOverlay(this.enableDesktopOverlayCheckBox.isSelected());
        ChatPreferences.setDesktopChannels(this.desktopChannelsField.getText());
    }
}

