/*
 * Decompiled with CFR 0.152.
 */
package icy.vtk;

import icy.gui.dialog.IdConfirmDialog;
import icy.gui.frame.progress.FailedAnnounceFrame;
import icy.system.IcyExceptionHandler;
import icy.system.IcyHandledException;
import icy.system.thread.ThreadUtil;
import icy.util.OpenGLUtil;
import icy.util.ReflectionUtil;
import java.awt.Graphics;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import jogamp.opengl.GLDrawableHelper;
import vtk.vtkCamera;
import vtk.vtkGenericOpenGLRenderWindow;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkLight;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkTIFFWriter;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public class VtkJoglPanel
extends GLJPanel {
    private static final long serialVersionUID = 8821516677188995191L;
    protected vtkGenericOpenGLRenderWindow rw = new vtkGenericOpenGLRenderWindow();
    protected vtkRenderer ren;
    protected vtkRenderWindowInteractor wi;
    protected vtkCamera cam;
    protected vtkLight lgt;
    protected ReentrantLock lock;
    protected GLEventImpl glEventImpl;
    protected int lastX;
    protected int lastY;
    protected boolean windowset;
    protected boolean lightingset;
    protected int interactionMode;
    protected boolean rendering;
    private boolean failed;

    public VtkJoglPanel() {
        super((GLCapabilitiesImmutable)new GLCapabilities(GLProfile.getDefault()));
        this.rw.SetIsDirect(1);
        this.rw.SetSupportsOpenGL(1);
        this.rw.SetIsCurrent(true);
        this.wi = new vtkGenericRenderWindowInteractor();
        this.wi.SetRenderWindow((vtkRenderWindow)this.rw);
        this.wi.ConfigureEvent();
        this.ren = new vtkRenderer();
        this.ren.SetLightFollowCamera(1);
        this.cam = null;
        this.lgt = new vtkLight();
        this.lgt.SetAmbientColor(1.0, 1.0, 1.0);
        this.lock = new ReentrantLock();
        this.glEventImpl = new GLEventImpl();
        this.windowset = false;
        this.lightingset = false;
        this.rendering = false;
        this.failed = false;
        this.addGLEventListener(this.glEventImpl);
        this.rw.AddRenderer(this.ren);
        this.cam = this.ren.GetActiveCamera();
        if (!OpenGLUtil.isOpenGLSupported(3) && !IdConfirmDialog.confirm("Warning", "Your graphics card driver does not support OpenGL 3, you may experience issues or crashes with VTK.\nDo you want to try anyway ?", 0, ((Object)((Object)this)).getClass().getName() + ".notCompatibleDialog")) {
            throw new IcyHandledException("Your graphics card driver is not compatible with OpenGL 3 !");
        }
    }

    @Deprecated
    public void Delete() {
        this.delete();
    }

    protected void delete() {
        if (this.rendering) {
            this.rw.SetAbortRender(1);
            ThreadUtil.sleep(500);
            if (this.rendering) {
                return;
            }
        }
        this.lock.lock();
        try {
            this.rendering = true;
            this.ren = null;
            this.cam = null;
            this.lgt = null;
            if (!this.rw.GetClassName().equals("vtkXOpenGLRenderWindow")) {
                this.rw = null;
            } else {
                System.out.println("The renderwindow has been kept arount to prevent a crash");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void dispose() {
    }

    public void disposeInternal() {
        super.dispose();
        this.removeGLEventListener(this.glEventImpl);
        try {
            GLDrawableHelper helper = (GLDrawableHelper)ReflectionUtil.getFieldObject((Object)this, "helper", true);
            ThreadLocal threadLocal = (ThreadLocal)ReflectionUtil.getFieldObject(helper, "perThreadInitAction", true);
            threadLocal.remove();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Deprecated
    public void Lock() {
        this.lock();
    }

    @Deprecated
    public void UnLock() {
        this.unlock();
    }

    @Deprecated
    public vtkRenderer GetRenderer() {
        return this.getRenderer();
    }

    @Deprecated
    public vtkRenderWindow GetRenderWindow() {
        return this.getRenderWindow();
    }

    public vtkRenderer getRenderer() {
        return this.ren;
    }

    public vtkRenderWindow getRenderWindow() {
        return this.rw;
    }

    public vtkCamera getCamera() {
        return this.cam;
    }

    public vtkLight getLight() {
        return this.lgt;
    }

    public vtkRenderWindowInteractor getInteractor() {
        return this.wi;
    }

    public boolean isRendering() {
        return this.rendering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        int[] size;
        super.setBounds(x, y, width, height);
        if (this.windowset && ((size = this.rw.GetSize())[0] != width || size[1] != height)) {
            this.lock();
            try {
                this.wi.SetSize(width, height);
                this.rw.SetSize(width, height);
                this.sizeChanged();
            }
            finally {
                this.unlock();
            }
        }
    }

    public void sizeChanged() {
    }

    @Deprecated
    public void Render() {
        this.render();
    }

    public void render() {
        if (this.rendering) {
            return;
        }
        this.rendering = true;
        this.lock();
        try {
            this.rw.Render();
        }
        finally {
            this.unlock();
            this.rendering = false;
        }
    }

    public boolean isWindowSet() {
        return this.windowset;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    @Deprecated
    public void InteractionModeRotate() {
    }

    @Deprecated
    public void InteractionModeTranslate() {
    }

    @Deprecated
    public void InteractionModeZoom() {
    }

    @Deprecated
    public void UpdateLight() {
        this.updateLight();
    }

    public void updateLight() {
        this.lgt.SetPosition(this.cam.GetPosition());
        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
    }

    public void resetCameraClippingRange() {
        this.lock();
        try {
            this.ren.ResetCameraClippingRange();
        }
        finally {
            this.unlock();
        }
    }

    public void resetCamera() {
        this.lock();
        try {
            this.ren.ResetCamera();
        }
        finally {
            this.unlock();
        }
    }

    public void paint(Graphics g) {
        if (this.failed) {
            return;
        }
        try {
            super.paint(g);
        }
        catch (Throwable t) {
            this.failed = true;
            new FailedAnnounceFrame("An error occured while initializing OpenGL !\nYou may try to update your graphics card driver to fix this issue.", 0);
            IcyExceptionHandler.handleException(t, true);
        }
    }

    @Deprecated
    public void HardCopy(String filename, int mag) {
        this.doHardCopy(filename, mag);
    }

    public void doHardCopy(String filename, int mag) {
        this.lock();
        vtkWindowToImageFilter w2if = new vtkWindowToImageFilter();
        w2if.SetInput((vtkWindow)this.rw);
        w2if.SetMagnification(mag);
        w2if.Update();
        vtkTIFFWriter writer = new vtkTIFFWriter();
        writer.SetInputConnection(w2if.GetOutputPort());
        writer.SetFileName(filename);
        writer.Write();
        this.unlock();
    }

    class GLEventImpl
    implements GLEventListener {
        GLEventImpl() {
        }

        public void init(GLAutoDrawable drawable) {
            if (!VtkJoglPanel.this.windowset) {
                VtkJoglPanel.this.windowset = true;
                GLContext ctx = drawable.getContext();
                if (!ctx.isCurrent()) {
                    ctx.makeCurrent();
                }
                VtkJoglPanel.this.rw.SetMapped(1);
                VtkJoglPanel.this.rw.SetPosition(0, 0);
                VtkJoglPanel.this.setSize(drawable.getWidth(), drawable.getHeight());
                VtkJoglPanel.this.rw.OpenGLInit();
                if (!VtkJoglPanel.this.lightingset) {
                    VtkJoglPanel.this.lightingset = true;
                    VtkJoglPanel.this.ren.AddLight(VtkJoglPanel.this.lgt);
                    VtkJoglPanel.this.lgt.SetPosition(VtkJoglPanel.this.cam.GetPosition());
                    VtkJoglPanel.this.lgt.SetFocalPoint(VtkJoglPanel.this.cam.GetFocalPoint());
                }
            }
        }

        public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
            VtkJoglPanel.this.setSize(width, height);
        }

        public void display(GLAutoDrawable drawable) {
            VtkJoglPanel.this.render();
        }

        public void dispose(GLAutoDrawable drawable) {
            VtkJoglPanel.this.delete();
        }
    }
}

