/*
 * Decompiled with CFR 0.152.
 */
package plugins.nchenouard.roiintensityevolution;

import icy.canvas.IcyCanvas;
import icy.gui.component.sequence.SequenceChooser;
import icy.gui.frame.IcyFrame;
import icy.gui.frame.IcyFrameEvent;
import icy.gui.frame.IcyFrameListener;
import icy.gui.frame.progress.AnnounceFrame;
import icy.gui.main.GlobalROIListener;
import icy.gui.main.GlobalSequenceListener;
import icy.image.IcyBufferedImage;
import icy.main.Icy;
import icy.plugin.abstract_.PluginActionable;
import icy.roi.ROI;
import icy.roi.ROIEvent;
import icy.roi.ROIListener;
import icy.sequence.Sequence;
import icy.util.StringUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import plugins.nchenouard.roiintensityevolution.ROIAnalysis;
import plugins.nchenouard.roiintensityevolution.SwimmingObjectBox;

public class ROIIntensityEvolution
extends PluginActionable
implements IcyFrameListener,
ROIListener,
GlobalSequenceListener,
GlobalROIListener {
    IcyFrame mainFrame;
    JFreeChart chart;
    JPanel chartsPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    final SequenceChooser sequenceSelector = new SequenceChooser(false, "Select image sequence here", 20);
    Sequence selectedSequence = null;
    final JPanel roiListPane = new JPanel();
    HashMap<JCheckBox, ROI> listedROIBoxList = new HashMap();
    HashMap<ROI, ROIAnalysis> roiSeries = new HashMap();
    HashMap<Sequence, IcyBufferedImage> projections = new HashMap();
    static final String[] criteria = new String[]{"Mean intensity", "Max intensity", "Min intensity", "Median instensity", "Intensity sum", "Intensity variance", "Over threshold pixel count"};
    JComboBox<String> criteriaBox = new JComboBox<String>(criteria);
    JButton refreshButton = new JButton("Refresh display");
    JCheckBox autoRefreshBox = new JCheckBox("Auto refresh display");
    ArrayList<ROI> seriesToFill = new ArrayList();
    ReentrantLock seriesToFillLock = new ReentrantLock();
    Condition seriesToFillCondition = this.seriesToFillLock.newCondition();
    JCheckBox overLaySeriesBox = new JCheckBox("Overlay series:");
    ReentrantLock analyzedLock = new ReentrantLock();
    private FillSeriesThread fillSeriesThread;
    private ArrayList<Thread> savingThreadList = new ArrayList();
    boolean notPacked = true;
    double threshold = 0.0;
    boolean useRealScales = false;
    boolean pixelAboveThreshold = true;
    XYSeries seriesToOverlay = null;

    public void run() {
        this.mainFrame = new IcyFrame("ROI Intensity Evolution", true, true, true, true);
        this.mainFrame.addFrameListener((IcyFrameListener)this);
        this.mainFrame.setVisible(true);
        Icy.getMainInterface().addGlobalSequenceListener((GlobalSequenceListener)this);
        Icy.getMainInterface().addGlobalROIListener((GlobalROIListener)this);
        JMenuBar menuBar = new JMenuBar();
        JMenu exportMenu = new JMenu("Save");
        menuBar.add(exportMenu);
        JMenuItem exportItem = new JMenuItem("Save results to XLS file");
        exportMenu.add(exportItem);
        exportItem.addActionListener(arg0 -> this.exportResults());
        JMenu optionMenu = new JMenu("Options");
        menuBar.add(optionMenu);
        JMenuItem displaySeriesItem = new JMenuItem("Display extra series from SwimmingPool");
        optionMenu.add(displaySeriesItem);
        displaySeriesItem.addActionListener(e -> {
            ExtraSeriesFrame optionFrame = new ExtraSeriesFrame();
            optionFrame.setVisible(true);
            this.addIcyFrame(optionFrame);
        });
        JMenuItem setThresholdItem = new JMenuItem("Set thresholding options");
        optionMenu.add(setThresholdItem);
        setThresholdItem.addActionListener(e -> {
            ThresholdingOptionFrame optionFrame = new ThresholdingOptionFrame();
            optionFrame.setVisible(true);
            this.addIcyFrame(optionFrame);
        });
        JMenu aboutMenu = new JMenu("About");
        menuBar.add(aboutMenu);
        JMenuItem manualItem = new JMenuItem("Manual");
        aboutMenu.add(manualItem);
        manualItem.addActionListener(e -> JOptionPane.showMessageDialog(this.mainPanel, "Please refer to the online help:\n http://icy.bioimageanalysis.org/plugin/ROI-Intensity-Evolution", "Manual", 1));
        JMenuItem aboutItem = new JMenuItem("About");
        aboutMenu.add(aboutItem);
        aboutItem.addActionListener(e -> JOptionPane.showMessageDialog(this.mainPanel, "This plugin is distributed under GPL v3 license.\n Author: Nicolas Chenouard", "About", 1));
        this.mainFrame.setJMenuBar(menuBar);
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)this.chartsPanel, "Center");
        JPanel eastPanel = new JPanel(new BorderLayout());
        JPanel eastNorthPanel = new JPanel(new GridBagLayout());
        eastPanel.add((Component)eastNorthPanel, "North");
        GridBagConstraints eastC = new GridBagConstraints();
        eastC.fill = 2;
        eastC.gridheight = 1;
        eastC.gridwidth = 1;
        eastC.gridx = 0;
        eastC.gridy = 0;
        eastNorthPanel.add((Component)new JLabel("Sequence to analyse:"), eastC);
        ++eastC.gridy;
        eastNorthPanel.add((Component)this.sequenceSelector, eastC);
        ++eastC.gridy;
        this.sequenceSelector.addActionListener(arg0 -> this.changeSelectedSequence(this.sequenceSelector.getSelectedSequence()));
        eastNorthPanel.add((Component)this.refreshButton, eastC);
        ++eastC.gridy;
        eastNorthPanel.add((Component)this.autoRefreshBox, eastC);
        this.autoRefreshBox.setSelected(true);
        ++eastC.gridy;
        this.refreshButton.addActionListener(arg0 -> this.refreshROIlist(this.selectedSequence));
        this.autoRefreshBox.addActionListener(arg0 -> {
            if (this.autoRefreshBox.isSelected()) {
                this.refreshROIlist(this.selectedSequence);
            }
        });
        eastNorthPanel.add((Component)new JLabel("Criterion to display:"), eastC);
        ++eastC.gridy;
        eastNorthPanel.add(this.criteriaBox, eastC);
        ++eastC.gridy;
        this.criteriaBox.addActionListener(e -> this.updateDisplay());
        eastNorthPanel.add((Component)new JLabel("Regions of Interest:"), eastC);
        this.roiListPane.setLayout(new BoxLayout(this.roiListPane, 1));
        JScrollPane scrollRoiListPane = new JScrollPane(this.roiListPane);
        eastPanel.add((Component)scrollRoiListPane, "Center");
        JPanel eastSouthPanel = new JPanel(new GridBagLayout());
        eastC.gridy = 0;
        eastC.weightx = 1.0;
        JButton selectAllButton = new JButton("Select all");
        selectAllButton.addActionListener(e -> this.selectAllROIs());
        eastSouthPanel.add((Component)selectAllButton, eastC);
        ++eastC.gridy;
        JButton unselectAllButton = new JButton("Unselect all");
        unselectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ROIIntensityEvolution.this.unselectAllROIs();
            }
        });
        eastSouthPanel.add((Component)unselectAllButton, eastC);
        eastPanel.add((Component)eastSouthPanel, "South");
        this.mainPanel.add((Component)eastPanel, "East");
        this.mainFrame.setContentPane((Container)this.mainPanel);
        this.mainFrame.addToDesktopPane();
        this.mainFrame.center();
        this.mainFrame.setVisible(true);
        this.mainFrame.requestFocus();
        this.fillSeriesThread = new FillSeriesThread();
        this.fillSeriesThread.start();
        SwingUtilities.invokeLater(() -> this.refreshROIlist(this.selectedSequence));
    }

    public static ArrayList<ROIAnalysis> analyseRoisInSequence(Sequence seq, boolean useRealScales, double threshold, boolean pixelAboveThreshold) {
        ArrayList toFill = seq.getROIs();
        ArrayList<ROIAnalysis> analyzed = new ArrayList<ROIAnalysis>();
        for (ROI roi : toFill) {
            double scaling = 1.0;
            if (useRealScales) {
                scaling = seq.getPixelSizeX() * seq.getPixelSizeY() * seq.getPixelSizeZ();
            }
            ROIAnalysis analysis = new ROIAnalysis(roi, seq, roi.getShowName() + "#" + roi.getId(), threshold, pixelAboveThreshold, scaling);
            analyzed.add(analysis);
        }
        return analyzed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportResults() {
        ArrayList<ROIAnalysis> analyzedTracks = new ArrayList<ROIAnalysis>();
        try {
            this.analyzedLock.lock();
            for (Map.Entry<JCheckBox, ROI> entry : this.listedROIBoxList.entrySet()) {
                if (!entry.getKey().isSelected()) continue;
                analyzedTracks.add(this.roiSeries.get(entry.getValue()));
            }
        }
        finally {
            this.analyzedLock.unlock();
        }
        this.exportToXLS(analyzedTracks);
    }

    public static void exportToXLS(ArrayList<ROIAnalysis> trackList, File XLSFile) {
        WritableWorkbook workbook = null;
        try {
            WorkbookSettings wbSettings = new WorkbookSettings();
            wbSettings.setLocale(new Locale("en", "EN"));
            workbook = Workbook.createWorkbook((File)XLSFile, (WorkbookSettings)wbSettings);
        }
        catch (IOException e) {
            e.printStackTrace();
            new AnnounceFrame("Error creating XLS file. Resuls saving aborted!");
            return;
        }
        int numChannels = ROIIntensityEvolution.computeMaxNumChannels(trackList);
        try {
            int cntSheet = 0;
            for (int c = 0; c < numChannels; ++c) {
                for (int i = 0; i < 7; ++i) {
                    WritableSheet sheet = workbook.createSheet("Channel " + c + " - " + criteria[i], cntSheet);
                    ++cntSheet;
                    int minT = 0;
                    int maxT = 0;
                    int cnt = 0;
                    int maxNumCol = 200;
                    int cntSheet2 = 0;
                    for (ROIAnalysis trkAnalysis : trackList) {
                        switch (i) {
                            case 0: {
                                if (!(trkAnalysis.getMeanIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getMeanIntensity()[c].getMaxX();
                                break;
                            }
                            case 1: {
                                if (!(trkAnalysis.getMaxIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getMaxIntensity()[c].getMaxX();
                                break;
                            }
                            case 2: {
                                if (!(trkAnalysis.getMinIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getMinIntensity()[c].getMaxX();
                                break;
                            }
                            case 3: {
                                if (!(trkAnalysis.getMedianIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getMedianIntensity()[c].getMaxX();
                                break;
                            }
                            case 4: {
                                if (!(trkAnalysis.getSumIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getSumIntensity()[c].getMaxX();
                                break;
                            }
                            case 5: {
                                if (!(trkAnalysis.getVarIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getVarIntensity()[c].getMaxX();
                                break;
                            }
                            case 6: {
                                if (!(trkAnalysis.getVarIntensity()[c].getMaxX() > (double)maxT)) break;
                                maxT = (int)trkAnalysis.getROISize()[c].getMaxX();
                            }
                        }
                    }
                    sheet.addCell((WritableCell)new Label(0, 0, "Frame number"));
                    for (int t = minT; t <= maxT; ++t) {
                        sheet.addCell((WritableCell)new Number(0, t - minT + 1, (double)t));
                    }
                    int cntTrack = 0;
                    block29: for (ROIAnalysis trkAnalysis : trackList) {
                        if (cnt > maxNumCol) {
                            cnt = 0;
                            sheet = workbook.createSheet("Channel " + c + " - " + criteria[i] + "-" + ++cntSheet2, ++cntSheet);
                            sheet.addCell((WritableCell)new Label(0, 0, "Frame number"));
                            for (int t = minT; t <= maxT; ++t) {
                                sheet.addCell((WritableCell)new Number(0, t - minT + 1, (double)t));
                            }
                            cntTrack = 0;
                        }
                        ++cnt;
                        sheet.addCell((WritableCell)new Label(++cntTrack, 0, trkAnalysis.getDescription()));
                        int firstT = 0;
                        switch (i) {
                            case 0: {
                                int j;
                                if (trkAnalysis.getMeanIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getMeanIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getMeanIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 1: {
                                int j;
                                if (trkAnalysis.getMaxIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getMaxIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getMaxIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 2: {
                                int j;
                                if (trkAnalysis.getMinIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getMinIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getMinIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 3: {
                                int j;
                                if (trkAnalysis.getMedianIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getMedianIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getMedianIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 4: {
                                int j;
                                if (trkAnalysis.getSumIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getSumIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getSumIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 5: {
                                int j;
                                if (trkAnalysis.getVarIntensity().length < c) break;
                                for (j = 0; j < trkAnalysis.getVarIntensity()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getVarIntensity()[c].getY(j).doubleValue()));
                                }
                                continue block29;
                            }
                            case 6: {
                                int j;
                                if (trkAnalysis.getROISize().length < c) break;
                                for (j = 0; j < trkAnalysis.getROISize()[c].getItemCount(); ++j) {
                                    sheet.addCell((WritableCell)new Number(cntTrack, firstT + j + 1, trkAnalysis.getROISize()[c].getY(j).doubleValue()));
                                }
                                break;
                            }
                        }
                    }
                }
            }
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        try {
            workbook.write();
            workbook.close();
        }
        catch (WriteException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void exportToXLS(final ArrayList<ROIAnalysis> trackList) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("Choose xls file.");
        int returnVal = chooser.showOpenDialog(this.mainPanel);
        if (returnVal != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.getName().endsWith(".xls")) {
            try {
                file = new File(file.getCanonicalPath() + ".xls");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        final File XLSFile = file;
        Thread savingThread = new Thread(){

            @Override
            public void run() {
                AnnounceFrame announce1 = new AnnounceFrame("Saving results");
                ROIIntensityEvolution.exportToXLS(trackList, XLSFile);
                ROIIntensityEvolution.this.savingThreadList.remove(this);
                announce1.close();
                new AnnounceFrame("Results saved");
            }
        };
        this.savingThreadList.add(savingThread);
        savingThread.start();
    }

    private void selectAllROIs() {
        for (JCheckBox box : this.listedROIBoxList.keySet()) {
            box.setSelected(true);
        }
        this.refreshSelectedList();
    }

    private void unselectAllROIs() {
        for (JCheckBox box : this.listedROIBoxList.keySet()) {
            box.setSelected(false);
        }
        this.updateDisplay();
    }

    private void changeSelectedSequence(Sequence selectedSequence) {
        Sequence oldSequence = this.selectedSequence;
        this.selectedSequence = selectedSequence;
        this.refreshROIlist(this.selectedSequence);
        if (oldSequence != selectedSequence) {
            this.updateDisplay();
        }
    }

    private void refreshROIlist(Sequence sequence) {
        ArrayList toRemove = new ArrayList();
        ArrayList<ROI> toAdd = new ArrayList<ROI>();
        ArrayList rois = new ArrayList();
        if (sequence != null) {
            rois.addAll(sequence.getROIs());
        }
        for (ROI rOI : rois) {
            if (this.listedROIBoxList.containsValue(rOI)) continue;
            toAdd.add(rOI);
        }
        for (Map.Entry entry : this.listedROIBoxList.entrySet()) {
            if (rois.contains(entry.getValue())) continue;
            toRemove.add(entry.getKey());
        }
        SwingUtilities.invokeLater(() -> {
            for (JCheckBox box : toRemove) {
                this.roiListPane.remove(box);
                this.listedROIBoxList.remove(box);
            }
            for (ROI roi : toAdd) {
                JCheckBox box = new JCheckBox(roi.getName());
                box.addActionListener(e -> this.refreshSelectedList());
                this.roiListPane.add(box);
                this.listedROIBoxList.put(box, roi);
                roi.addListener((ROIListener)this);
            }
            this.roiListPane.updateUI();
            this.refreshSelectedList();
        });
    }

    private void refreshSelectedList() {
        this.refreshAllResults(this.selectedSequence);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<ROI> getToAnalyzeTracks() {
        ArrayList<ROI> toAnalyze = new ArrayList<ROI>();
        ArrayList<ROI> toFillCopy = new ArrayList<ROI>();
        ArrayList<ROI> analyzedROIs = new ArrayList<ROI>();
        try {
            this.seriesToFillLock.lock();
            toFillCopy.addAll(this.seriesToFill);
        }
        finally {
            this.seriesToFillLock.unlock();
        }
        try {
            this.analyzedLock.lock();
            analyzedROIs.addAll(this.roiSeries.keySet());
        }
        finally {
            this.analyzedLock.unlock();
        }
        for (Map.Entry<JCheckBox, ROI> entry : this.listedROIBoxList.entrySet()) {
            if (!entry.getKey().isSelected() || toFillCopy.contains(entry.getValue())) continue;
            toAnalyze.add(entry.getValue());
        }
        return toAnalyze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDisplay() {
        ArrayList<ROIAnalysis> analyzedROIList = new ArrayList<ROIAnalysis>();
        if (this.selectedSequence != null) {
            this.analyzedLock.lock();
            try {
                for (Map.Entry<JCheckBox, ROI> e : this.listedROIBoxList.entrySet()) {
                    if (!e.getKey().isSelected() || this.roiSeries.get(e.getValue()) == null) continue;
                    analyzedROIList.add(this.roiSeries.get(e.getValue()));
                }
            }
            finally {
                this.analyzedLock.unlock();
            }
        }
        this.updateCharts(analyzedROIList);
    }

    private static int computeMaxNumChannels(ArrayList<ROIAnalysis> analyzedROIList) {
        int maxNumChannels = 0;
        for (ROIAnalysis tr : analyzedROIList) {
            if (tr == null || tr.getNumChannels() <= maxNumChannels) continue;
            maxNumChannels = tr.getNumChannels();
        }
        return maxNumChannels;
    }

    private void updateCharts(ArrayList<ROIAnalysis> analyzedROIList) {
        String TitleString3;
        int maxNumChannels = ROIIntensityEvolution.computeMaxNumChannels(analyzedROIList);
        this.chartsPanel.removeAll();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer();
        for (int i = 0; i < analyzedROIList.size(); ++i) {
            renderer.setSeriesStroke(i, (Stroke)new BasicStroke(2.0f));
            renderer.setSeriesShapesVisible(i, false);
        }
        if (maxNumChannels > 0) {
            this.chartsPanel.setLayout(new GridLayout(maxNumChannels, 1));
        } else {
            this.chartsPanel.setLayout(new BoxLayout(this.chartsPanel, 3));
            XYSeriesCollection xyDataset = new XYSeriesCollection();
            if (this.seriesToOverlay != null) {
                xyDataset.addSeries(this.seriesToOverlay);
            }
            String TitleString = "ROI Intensity Evolution";
            String TitleString2 = "Time";
            TitleString3 = "Intensity";
            boolean displayLegend = true;
            this.chart = ChartFactory.createXYLineChart((String)TitleString, (String)TitleString2, (String)TitleString3, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)displayLegend, (boolean)true, (boolean)false);
            int minWidth = 300;
            int minHeight = 200;
            int width = 300;
            int height = 200;
            int maxWidth = 100000;
            int maxHeight = 100000;
            ChartPanel panel = new ChartPanel(this.chart, width, height, minWidth, minHeight, maxWidth, maxHeight, false, true, true, true, true, true);
            panel.setMinimumSize(new Dimension(width, height));
            panel.setSize(new Dimension(width, height));
            this.chart.getPlot().setBackgroundPaint((Paint)new Color(230, 230, 230));
            this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            this.chart.getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.chart.getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.chartsPanel.add((Component)panel);
        }
        for (int c = 0; c < maxNumChannels; ++c) {
            XYSeriesCollection xyDataset = new XYSeriesCollection();
            String TitleString = "";
            TitleString = this.selectedSequence != null ? this.selectedSequence.getChannelName(c) : "ch" + c;
            if (this.seriesToOverlay != null) {
                xyDataset.addSeries(this.seriesToOverlay);
            }
            TitleString3 = "";
            for (ROIAnalysis analysis : analyzedROIList) {
                XYSeries cropSeries = null;
                switch (this.criteriaBox.getSelectedIndex()) {
                    case 0: {
                        if (analysis.getMeanIntensity().length >= c) {
                            cropSeries = analysis.getMeanIntensity()[c];
                        }
                        TitleString3 = "Mean Intensity";
                        break;
                    }
                    case 1: {
                        if (analysis.getMaxIntensity().length >= c) {
                            cropSeries = analysis.getMaxIntensity()[c];
                        }
                        TitleString3 = "Max Intensity";
                        break;
                    }
                    case 2: {
                        if (analysis.getMinIntensity().length >= c) {
                            cropSeries = analysis.getMinIntensity()[c];
                        }
                        TitleString3 = "Min Intensity";
                        break;
                    }
                    case 3: {
                        if (analysis.getMedianIntensity().length >= c) {
                            cropSeries = analysis.getMedianIntensity()[c];
                        }
                        TitleString3 = "Median Intensity";
                        break;
                    }
                    case 4: {
                        if (analysis.getSumIntensity().length >= c) {
                            cropSeries = analysis.getSumIntensity()[c];
                        }
                        TitleString3 = "Intensity sum";
                        break;
                    }
                    case 5: {
                        if (analysis.getVarIntensity().length >= c) {
                            cropSeries = analysis.getVarIntensity()[c];
                        }
                        TitleString3 = "Intensity variance";
                        break;
                    }
                    case 6: {
                        if (analysis.getROISize().length >= c) {
                            cropSeries = analysis.getROISize()[c];
                        }
                        TitleString3 = this.pixelAboveThreshold ? "Pixel area over threshold" : "Pixel area below threshold";
                    }
                }
                xyDataset.addSeries(cropSeries);
            }
            String TitleString2 = "Time";
            boolean displayLegend = true;
            this.chart = ChartFactory.createXYLineChart((String)TitleString, (String)TitleString2, (String)TitleString3, (XYDataset)xyDataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)displayLegend, (boolean)true, (boolean)false);
            int minWidth = 300;
            int minHeight = 200;
            int width = 300;
            int height = 200;
            int maxWidth = 100000;
            int maxHeight = 100000;
            this.chart.getPlot().setBackgroundPaint((Paint)new Color(230, 230, 230));
            this.chart.getXYPlot().setRenderer((XYItemRenderer)renderer);
            this.chart.getXYPlot().setRangeGridlinePaint((Paint)Color.BLACK);
            this.chart.getXYPlot().setDomainGridlinePaint((Paint)Color.BLACK);
            this.chartsPanel.add((Component)new ChartPanel(this.chart, width, height, minWidth, minHeight, maxWidth, maxHeight, false, false, true, true, true, true));
        }
        if (this.notPacked) {
            this.notPacked = false;
            this.mainFrame.pack();
        }
        this.chartsPanel.validate();
        this.chartsPanel.repaint();
        this.mainFrame.repaint();
    }

    public void refreshAllResults(Sequence sequence) {
        try {
            this.seriesToFillLock.lock();
            this.analyzedLock.lock();
            this.seriesToFill.clear();
            this.roiSeries.clear();
        }
        finally {
            this.analyzedLock.unlock();
            this.seriesToFillLock.unlock();
        }
        ArrayList<ROI> toFill = this.getToAnalyzeTracks();
        try {
            this.seriesToFillLock.lock();
            this.seriesToFill.addAll(toFill);
            this.seriesToFillCondition.signalAll();
        }
        finally {
            this.seriesToFillLock.unlock();
        }
    }

    public void icyFrameIconified(IcyFrameEvent e) {
    }

    public void icyFrameDeiconified(IcyFrameEvent e) {
    }

    public void icyFrameActivated(IcyFrameEvent e) {
    }

    public void icyFrameDeactivated(IcyFrameEvent e) {
    }

    public void icyFrameInternalized(IcyFrameEvent e) {
    }

    public void icyFrameExternalized(IcyFrameEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void roiChanged(ROIEvent event) {
        ROI roi;
        if (event.getType() == ROIEvent.ROIEventType.PROPERTY_CHANGED && StringUtil.equals((String)event.getPropertyName(), (String)"name")) {
            for (Map.Entry<JCheckBox, ROI> e : this.listedROIBoxList.entrySet()) {
                if (e.getValue() != event.getSource()) continue;
                e.getKey().setText(event.getSource().getName());
            }
        }
        if (event.getType() != ROIEvent.ROIEventType.ROI_CHANGED) {
            return;
        }
        if (this.autoRefreshBox.isSelected() && (roi = event.getSource()) != null && roi.getSequences().contains(this.selectedSequence)) {
            ROIAnalysis analysis;
            if (event.getType() == ROIEvent.ROIEventType.ROI_CHANGED && (analysis = this.roiSeries.get(roi)) != null) {
                try {
                    this.seriesToFillLock.lock();
                    if (!this.seriesToFill.contains(roi)) {
                        this.seriesToFill.add(roi);
                    }
                    this.seriesToFillCondition.signalAll();
                }
                finally {
                    this.seriesToFillLock.unlock();
                }
            }
            if (event.getType() == ROIEvent.ROIEventType.FOCUS_CHANGED && roi.isSelected()) {
                for (Map.Entry<JCheckBox, ROI> entry : this.listedROIBoxList.entrySet()) {
                    if (entry.getValue() != roi) continue;
                    entry.getKey().setSelected(true);
                    this.refreshSelectedList();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillSeries(ArrayList<ROI> toFill, Sequence selectedSequence) {
        if (toFill.isEmpty()) {
            return;
        }
        ArrayList<ROIAnalysis> analyzed = new ArrayList<ROIAnalysis>();
        for (ROI roi : toFill) {
            double scaling = 1.0;
            if (this.useRealScales) {
                scaling = selectedSequence.getPixelSizeX() * selectedSequence.getPixelSizeY();
            }
            ROIAnalysis analysis = new ROIAnalysis(roi, selectedSequence, roi.getName() + "#" + roi.getId(), this.threshold, this.pixelAboveThreshold, scaling);
            analyzed.add(analysis);
        }
        try {
            this.analyzedLock.lock();
            for (ROIAnalysis analysis : analyzed) {
                this.roiSeries.put(analysis.getROI(), analysis);
            }
        }
        finally {
            this.analyzedLock.unlock();
        }
        SwingUtilities.invokeLater(this::updateDisplay);
    }

    double convertScale(IcyCanvas canvas, double value) {
        return canvas.canvasToImageLogDeltaX((int)value);
    }

    public void sequenceOpened(Sequence sequence) {
    }

    public void sequenceClosed(Sequence sequence) {
        if (sequence == this.selectedSequence) {
            for (ROI roi : this.selectedSequence.getROIs()) {
                roi.removeListener((ROIListener)this);
            }
        }
    }

    public void icyFrameOpened(IcyFrameEvent e) {
    }

    public void icyFrameClosing(IcyFrameEvent e) {
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this);
        for (ROI roi : this.listedROIBoxList.values()) {
            roi.removeListener((ROIListener)this);
        }
    }

    public void icyFrameClosed(IcyFrameEvent e) {
        Icy.getMainInterface().removeGlobalSequenceListener((GlobalSequenceListener)this);
        for (ROI roi : this.listedROIBoxList.values()) {
            roi.removeListener((ROIListener)this);
        }
    }

    public void roiAdded(ROI roi) {
        this.refreshROIlist(this.selectedSequence);
    }

    public void roiRemoved(ROI roi) {
        this.refreshROIlist(this.selectedSequence);
    }

    public void changeSeriesToOverlay(XYSeries series) {
        if (series != this.seriesToOverlay) {
            this.updateDisplay();
        }
    }

    class ExtraSeriesFrame
    extends IcyFrame {
        SwimmingObjectBox<XYSeries> seriesBox;

        protected ExtraSeriesFrame() {
            super("Extra series to display");
            this.seriesBox = new SwimmingObjectBox<XYSeries>(XYSeries.class);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.gridy = 0;
            gc.weightx = 1.0;
            gc.gridwidth = 2;
            this.setContentPane(mainPanel);
            mainPanel.add((Component)new JLabel("Select below a temporal series in the SwimmingPool to be overlayed:"), gc);
            ++gc.gridy;
            mainPanel.add(this.seriesBox, gc);
            ++gc.gridy;
            JButton displaySeriesButton = new JButton("Overlay series");
            gc.weightx = 0.5;
            gc.gridx = 0;
            gc.gridwidth = 1;
            mainPanel.add((Component)displaySeriesButton, gc);
            displaySeriesButton.addActionListener(arg0 -> {
                ROIIntensityEvolution.this.changeSeriesToOverlay((XYSeries)this.seriesBox.getSelectedItem());
                this.close();
            });
            ++gc.gridx;
            JButton cancelButton = new JButton("No series to overlay");
            cancelButton.addActionListener(e -> {
                ROIIntensityEvolution.this.changeSeriesToOverlay(null);
                this.close();
            });
            mainPanel.add((Component)cancelButton, gc);
            this.pack();
        }
    }

    class ThresholdingOptionFrame
    extends IcyFrame {
        NumberFormat numberFormat;
        JFormattedTextField thresholdField;
        JCheckBox countPixelAboveThreshold;
        JCheckBox useRealScalesBox;
        JButton setValuesButton;

        protected ThresholdingOptionFrame() {
            super("Thresholding options");
            this.thresholdField = new JFormattedTextField(this.numberFormat);
            this.countPixelAboveThreshold = new JCheckBox("Count pixel above threshold.");
            this.useRealScalesBox = new JCheckBox("Use real area scales instead of pixel count.");
            this.setValuesButton = new JButton("Set values");
            JPanel mainPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gc = new GridBagConstraints();
            gc.fill = 2;
            gc.gridy = 0;
            this.setContentPane(mainPanel);
            JTextArea descriptionArea = new JTextArea("In each selected ROI the number of pixels that or above, or below,\n a user-defined threshold for pixel value can be counted.");
            mainPanel.add((Component)descriptionArea, gc);
            ++gc.gridy;
            mainPanel.add((Component)new JLabel("Pixel threshold value:"), gc);
            ++gc.gridy;
            mainPanel.add((Component)this.thresholdField, gc);
            ++gc.gridy;
            this.thresholdField.setValue(ROIIntensityEvolution.this.threshold);
            mainPanel.add((Component)this.countPixelAboveThreshold, gc);
            ++gc.gridy;
            this.countPixelAboveThreshold.setSelected(ROIIntensityEvolution.this.pixelAboveThreshold);
            this.countPixelAboveThreshold.setSelected(ROIIntensityEvolution.this.pixelAboveThreshold);
            mainPanel.add((Component)this.useRealScalesBox, gc);
            ++gc.gridy;
            this.useRealScalesBox.setSelected(ROIIntensityEvolution.this.useRealScales);
            mainPanel.add((Component)this.setValuesButton, gc);
            ++gc.gridy;
            this.setValuesButton.addActionListener(arg0 -> {
                ROIIntensityEvolution.this.threshold = ((java.lang.Number)this.thresholdField.getValue()).doubleValue();
                ROIIntensityEvolution.this.pixelAboveThreshold = this.countPixelAboveThreshold.isSelected();
                ROIIntensityEvolution.this.useRealScales = this.useRealScalesBox.isSelected();
                ROIIntensityEvolution.this.refreshSelectedList();
                this.close();
            });
            this.pack();
        }
    }

    class FillSeriesThread
    extends Thread {
        boolean stop = false;

        FillSeriesThread() {
        }

        @Override
        public void run() {
            while (!this.stop) {
                ArrayList<ROI> toFill = new ArrayList<ROI>();
                try {
                    ROIIntensityEvolution.this.seriesToFillLock.lock();
                    if (ROIIntensityEvolution.this.seriesToFill.isEmpty()) {
                        ROIIntensityEvolution.this.seriesToFillCondition.await();
                    }
                    toFill.addAll(ROIIntensityEvolution.this.seriesToFill);
                    ROIIntensityEvolution.this.seriesToFill.clear();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    ROIIntensityEvolution.this.seriesToFillLock.unlock();
                }
                if (ROIIntensityEvolution.this.selectedSequence != null) {
                    ROIIntensityEvolution.this.fillSeries(toFill, ROIIntensityEvolution.this.selectedSequence);
                    continue;
                }
                SwingUtilities.invokeLater(ROIIntensityEvolution.this::updateDisplay);
            }
        }
    }
}

